/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.LockDataflow;
import edu.umd.cs.findbugs.ba.LockSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.MONITORENTER;
import org.apache.bcel.generic.MethodGen;

public final class FindTwoLockWait
implements Detector,
StatelessDetector {
    private BugReporter bugReporter;
    private JavaClass javaClass;
    private Collection<BugInstance> possibleWaitBugs = new LinkedList<BugInstance>();
    private Collection<SourceLineAnnotation> possibleNotifyLocations = new LinkedList<SourceLineAnnotation>();

    public FindTwoLockWait(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void visitClassContext(ClassContext classContext) {
        Method[] methodList;
        this.javaClass = classContext.getJavaClass();
        this.possibleWaitBugs.clear();
        this.possibleNotifyLocations.clear();
        for (Method method : methodList = this.javaClass.getMethods()) {
            MethodGen methodGen = classContext.getMethodGen(method);
            if (methodGen == null || !this.preScreen(methodGen)) continue;
            try {
                this.analyzeMethod(classContext, method);
            }
            catch (DataflowAnalysisException e) {
            }
            catch (CFGBuilderException e) {
                this.bugReporter.logError("Error analyzing " + method.toString(), e);
            }
        }
        if (!this.possibleNotifyLocations.isEmpty()) {
            for (BugInstance bug : this.possibleWaitBugs) {
                for (SourceLineAnnotation notifyLine : this.possibleNotifyLocations) {
                    bug.addSourceLine(notifyLine).describe("SOURCE_NOTIFICATION_DEADLOCK");
                }
                this.bugReporter.reportBug(bug);
            }
        }
    }

    private void analyzeMethod(ClassContext classContext, Method method) throws CFGBuilderException, DataflowAnalysisException {
        MethodGen methodGen = classContext.getMethodGen(method);
        CFG cfg = classContext.getCFG(method);
        LockDataflow dataflow = classContext.getLockDataflow(method);
        Iterator<Location> j = cfg.locationIterator();
        while (j.hasNext()) {
            Location location = j.next();
            this.visitLocation(classContext, location, methodGen, dataflow);
        }
    }

    public boolean preScreen(MethodGen mg) {
        ConstantPoolGen cpg = mg.getConstantPool();
        int lockCount = mg.isSynchronized() ? 1 : 0;
        boolean sawWaitOrNotify = false;
        for (InstructionHandle handle = mg.getInstructionList().getStart(); !(handle == null || lockCount >= 2 && sawWaitOrNotify); handle = handle.getNext()) {
            INVOKEVIRTUAL inv;
            String methodName;
            Instruction ins = handle.getInstruction();
            if (ins instanceof MONITORENTER) {
                ++lockCount;
                continue;
            }
            if (!(ins instanceof INVOKEVIRTUAL) || !(methodName = (inv = (INVOKEVIRTUAL)ins).getMethodName(cpg)).equals("wait") && !methodName.startsWith("notify")) continue;
            sawWaitOrNotify = true;
        }
        return lockCount >= 2 && sawWaitOrNotify;
    }

    public void visitLocation(ClassContext classContext, Location location, MethodGen methodGen, LockDataflow dataflow) throws DataflowAnalysisException {
        String sourceFile;
        int count;
        ConstantPoolGen cpg = methodGen.getConstantPool();
        if (Hierarchy.isMonitorWait(location.getHandle().getInstruction(), cpg) && (count = ((LockSet)dataflow.getFactAtLocation(location)).getNumLockedObjects()) > 1) {
            sourceFile = this.javaClass.getSourceFileName();
            this.possibleWaitBugs.add(new BugInstance(this, "TLW_TWO_LOCK_WAIT", 1).addClassAndMethod(methodGen, sourceFile).addSourceLine(classContext, methodGen, sourceFile, location.getHandle()));
        }
        if (Hierarchy.isMonitorNotify(location.getHandle().getInstruction(), cpg) && (count = ((LockSet)dataflow.getFactAtLocation(location)).getNumLockedObjects()) > 1) {
            sourceFile = this.javaClass.getSourceFileName();
            this.possibleNotifyLocations.add(SourceLineAnnotation.fromVisitedInstruction(classContext, methodGen, sourceFile, location.getHandle()));
        }
    }

    public void report() {
    }
}

