/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.plugin.eclipse.quickfix;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.BugResolution;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.exception.BugResolutionException;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.util.ASTUtil;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.util.ConditionCheck;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.util.ImportDeclarationComparator;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateDoPrivilegedBlockResolution
extends BugResolution {
    private static final String DO_PRIVILEGED_METHOD_NAME = "doPrivileged";
    private boolean updateImports = true;
    private boolean staticImport = false;
    private Comparator<ImportDeclaration> importComparator = new ImportDeclarationComparator<ImportDeclaration>();

    public CreateDoPrivilegedBlockResolution() {
    }

    public CreateDoPrivilegedBlockResolution(boolean updateImports) {
        this();
        this.setUpdateImports(updateImports);
    }

    public CreateDoPrivilegedBlockResolution(boolean updateImports, boolean staticImport) {
        this(updateImports);
        this.setStaticImport(staticImport);
    }

    public boolean isUpdateImports() {
        return this.updateImports;
    }

    public void setUpdateImports(boolean updateImports) {
        this.updateImports = updateImports;
    }

    public boolean isStaticImport() {
        return this.staticImport;
    }

    public void setStaticImport(boolean staticImport) {
        this.staticImport = staticImport;
    }

    public Comparator<ImportDeclaration> getImportComparator() {
        return this.importComparator;
    }

    public void setImportComparator(Comparator<ImportDeclaration> importComparator) {
        ConditionCheck.checkForNull(importComparator, "import comparator");
        this.importComparator = importComparator;
    }

    @Override
    protected boolean resolveBindings() {
        return true;
    }

    @Override
    protected void repairBug(ASTRewrite rewrite, CompilationUnit workingUnit, BugInstance bug) throws BugResolutionException {
        assert (rewrite != null);
        assert (workingUnit != null);
        assert (bug != null);
        ClassInstanceCreation classLoaderCreation = this.findClassLoaderCreation(ASTUtil.getASTNode(workingUnit, bug.getPrimarySourceLineAnnotation()));
        if (classLoaderCreation == null) {
            throw new BugResolutionException("No matching class loader creation found at the specified source line.");
        }
        this.updateVariableReferences(rewrite, classLoaderCreation);
        rewrite.replace((ASTNode)classLoaderCreation, (ASTNode)this.createDoPrivilegedInvocation(rewrite, classLoaderCreation), null);
        this.updateImportDeclarations(rewrite, workingUnit);
    }

    protected void updateVariableReferences(ASTRewrite rewrite, ClassInstanceCreation classLoaderCreation) {
        Set<String> variableReferences;
        assert (rewrite != null);
        assert (classLoaderCreation != null);
        MethodDeclaration method = this.findMethodDeclaration((ASTNode)classLoaderCreation);
        if (method != null && !(variableReferences = this.findVariableReferences(classLoaderCreation.arguments())).isEmpty()) {
            this.updateMethodParams(rewrite, variableReferences, method.parameters());
            this.updateLocalVariableDeclarations(rewrite, variableReferences, method.getBody());
        }
    }

    protected void updateMethodParams(ASTRewrite rewrite, Set<String> variables, List<?> params) {
        assert (rewrite != null);
        assert (variables != null);
        assert (params != null);
        for (Object paramObj : params) {
            SingleVariableDeclaration param = (SingleVariableDeclaration)paramObj;
            if (!variables.contains(param.getName().getFullyQualifiedName())) continue;
            ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)param, SingleVariableDeclaration.MODIFIERS2_PROPERTY);
            listRewrite.insertLast((ASTNode)rewrite.getAST().newModifier(Modifier.ModifierKeyword.FINAL_KEYWORD), null);
        }
    }

    protected void updateLocalVariableDeclarations(final ASTRewrite rewrite, final Set<String> variables, Block block) {
        assert (rewrite != null);
        assert (block != null);
        assert (variables != null);
        final AST ast = rewrite.getAST();
        block.accept(new ASTVisitor(){

            public boolean visit(VariableDeclarationFragment fragment) {
                ASTNode parent;
                if (variables.contains(fragment.getName().getFullyQualifiedName()) && (parent = fragment.getParent()) instanceof VariableDeclarationStatement) {
                    ListRewrite listRewrite = rewrite.getListRewrite(parent, VariableDeclarationStatement.MODIFIERS2_PROPERTY);
                    listRewrite.insertLast((ASTNode)ast.newModifier(Modifier.ModifierKeyword.FINAL_KEYWORD), null);
                }
                return true;
            }
        });
    }

    protected void updateImportDeclarations(ASTRewrite rewrite, CompilationUnit compilationUnit) {
        assert (rewrite != null);
        assert (compilationUnit != null);
        if (this.isUpdateImports()) {
            AST ast = rewrite.getAST();
            TreeSet<ImportDeclaration> imports = new TreeSet<ImportDeclaration>(this.importComparator);
            imports.add(this.createImportDeclaration(ast, PrivilegedAction.class));
            if (!this.isStaticImport()) {
                imports.add(this.createImportDeclaration(ast, AccessController.class));
            } else {
                imports.add(this.createImportDeclaration(ast, AccessController.class, DO_PRIVILEGED_METHOD_NAME));
            }
            ASTUtil.addImports(rewrite, compilationUnit, imports);
        }
    }

    protected ImportDeclaration createImportDeclaration(AST ast, Class<?> importClass) {
        assert (ast != null);
        assert (importClass != null);
        return this.createImportDeclaration(ast, importClass.getName(), false);
    }

    protected ImportDeclaration createImportDeclaration(AST ast, Class<?> importClass, String javaElementName) {
        assert (ast != null);
        assert (importClass != null);
        assert (javaElementName != null);
        return this.createImportDeclaration(ast, importClass.getName() + "." + javaElementName, true);
    }

    private ImportDeclaration createImportDeclaration(AST ast, String name, boolean isStatic) {
        ImportDeclaration importDeclaration = ast.newImportDeclaration();
        importDeclaration.setName(ast.newName(name));
        importDeclaration.setStatic(isStatic);
        return importDeclaration;
    }

    protected MethodInvocation createDoPrivilegedInvocation(ASTRewrite rewrite, ClassInstanceCreation classLoaderCreation) {
        AST ast = rewrite.getAST();
        MethodInvocation doPrivilegedInvocation = ast.newMethodInvocation();
        ClassInstanceCreation privilegedActionCreation = this.createPrivilegedActionCreation(rewrite, classLoaderCreation);
        List arguments = this.checkedList(doPrivilegedInvocation.arguments());
        if (!this.isStaticImport()) {
            Object accessControllerName = this.isUpdateImports() ? ast.newSimpleName(AccessController.class.getSimpleName()) : ast.newName(AccessController.class.getName());
            doPrivilegedInvocation.setExpression((Expression)accessControllerName);
        }
        doPrivilegedInvocation.setName(ast.newSimpleName(DO_PRIVILEGED_METHOD_NAME));
        arguments.add(privilegedActionCreation);
        return doPrivilegedInvocation;
    }

    private ClassInstanceCreation createPrivilegedActionCreation(ASTRewrite rewrite, ClassInstanceCreation classLoaderCreation) {
        AST ast = rewrite.getAST();
        ClassInstanceCreation privilegedActionCreation = ast.newClassInstanceCreation();
        ParameterizedType privilegedActionType = this.createPrivilegedActionType(rewrite, classLoaderCreation);
        AnonymousClassDeclaration anonymousClassDeclaration = this.createAnonymousClassDeclaration(rewrite, classLoaderCreation);
        privilegedActionCreation.setType((Type)privilegedActionType);
        privilegedActionCreation.setAnonymousClassDeclaration(anonymousClassDeclaration);
        return privilegedActionCreation;
    }

    private ParameterizedType createPrivilegedActionType(ASTRewrite rewrite, ClassInstanceCreation classLoaderCreation) {
        AST ast = rewrite.getAST();
        Object privilegedActionName = this.isUpdateImports() ? ast.newSimpleName(PrivilegedAction.class.getSimpleName()) : ast.newName(PrivilegedAction.class.getName());
        SimpleType rawPrivilegedActionType = ast.newSimpleType((Name)privilegedActionName);
        ParameterizedType privilegedActionType = ast.newParameterizedType((Type)rawPrivilegedActionType);
        Type typeArgument = (Type)rewrite.createCopyTarget((ASTNode)classLoaderCreation.getType());
        List typeArguments = this.checkedList(privilegedActionType.typeArguments());
        typeArguments.add(typeArgument);
        return privilegedActionType;
    }

    <V> List<V> checkedList(List<?> o) {
        return o;
    }

    private AnonymousClassDeclaration createAnonymousClassDeclaration(ASTRewrite rewrite, ClassInstanceCreation classLoaderCreation) {
        AST ast = rewrite.getAST();
        AnonymousClassDeclaration anonymousClassDeclaration = ast.newAnonymousClassDeclaration();
        MethodDeclaration runMethodDeclaration = this.createRunMethodDeclaration(rewrite, classLoaderCreation);
        List bodyDeclarations = this.checkedList(anonymousClassDeclaration.bodyDeclarations());
        bodyDeclarations.add(runMethodDeclaration);
        return anonymousClassDeclaration;
    }

    private MethodDeclaration createRunMethodDeclaration(ASTRewrite rewrite, ClassInstanceCreation classLoaderCreation) {
        AST ast = rewrite.getAST();
        MethodDeclaration methodDeclaration = ast.newMethodDeclaration();
        SimpleName methodName = ast.newSimpleName("run");
        Type returnType = (Type)rewrite.createCopyTarget((ASTNode)classLoaderCreation.getType());
        Block methodBody = this.createRunMethodBody(rewrite, classLoaderCreation);
        List modifiers = this.checkedList(methodDeclaration.modifiers());
        modifiers.add(ast.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));
        methodDeclaration.setName(methodName);
        methodDeclaration.setReturnType2(returnType);
        methodDeclaration.setBody(methodBody);
        return methodDeclaration;
    }

    private Block createRunMethodBody(ASTRewrite rewrite, ClassInstanceCreation classLoaderCreation) {
        AST ast = rewrite.getAST();
        Block methodBody = ast.newBlock();
        ReturnStatement returnStatement = ast.newReturnStatement();
        List statements = this.checkedList(methodBody.statements());
        statements.add(returnStatement);
        returnStatement.setExpression((Expression)((ClassInstanceCreation)rewrite.createCopyTarget((ASTNode)classLoaderCreation)));
        return methodBody;
    }

    @CheckForNull
    private ClassInstanceCreation findClassLoaderCreation(ASTNode node) {
        ClassLoaderCreationFinder finder = new ClassLoaderCreationFinder();
        node.accept((ASTVisitor)finder);
        return finder.getClassLoaderCreation();
    }

    @CheckForNull
    private MethodDeclaration findMethodDeclaration(ASTNode node) {
        if (node == null || node instanceof MethodDeclaration) {
            return (MethodDeclaration)node;
        }
        return this.findMethodDeclaration(node.getParent());
    }

    private Set<String> findVariableReferences(List<?> arguments) {
        final HashSet<String> refs = new HashSet<String>();
        for (Object argumentObj : arguments) {
            Expression argument = (Expression)argumentObj;
            argument.accept(new ASTVisitor(){

                public boolean visit(SimpleName node) {
                    if (!(node.getParent() instanceof Type)) {
                        refs.add(node.getFullyQualifiedName());
                    }
                    return true;
                }
            });
        }
        return refs;
    }

    protected static class ClassLoaderCreationFinder
    extends ASTVisitor {
        private ClassInstanceCreation classLoaderCreation;

        protected ClassLoaderCreationFinder() {
        }

        public boolean visit(ClassInstanceCreation node) {
            if (this.classLoaderCreation == null) {
                if (!ClassLoaderCreationFinder.isClassLoaderCreation(node)) {
                    return true;
                }
                this.classLoaderCreation = node;
            }
            return false;
        }

        public ClassInstanceCreation getClassLoaderCreation() {
            return this.classLoaderCreation;
        }

        private static boolean isClassLoaderCreation(ClassInstanceCreation node) {
            return ClassLoaderCreationFinder.isClassLoader(node.getType());
        }

        private static boolean isClassLoader(Type type) {
            return ClassLoaderCreationFinder.isClassLoader(type.resolveBinding());
        }

        private static boolean isClassLoader(ITypeBinding typeBinding) {
            if (typeBinding.getQualifiedName().equals(ClassLoader.class.getName())) {
                return true;
            }
            ITypeBinding superclass = typeBinding.getSuperclass();
            return superclass != null && ClassLoaderCreationFinder.isClassLoader(superclass);
        }
    }
}

