/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.workflow;

import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.PackageStats;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.util.Bag;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;

public class TreemapVisualization {
    static HashSet<String> buggyPackages = new HashSet();
    static HashSet<String> interiorPackages = new HashSet();
    static Bag<String> goodCodeSize = new Bag(new TreeMap());
    static Bag<String> goodCodeCount = new Bag(new TreeMap());

    public static void addInteriorPackages(String packageName) {
        String p = TreemapVisualization.superpackage(packageName);
        if (p.length() > 0) {
            interiorPackages.add(p);
            TreemapVisualization.addInteriorPackages(p);
        }
    }

    private static String superpackage(String packageName) {
        int i = packageName.lastIndexOf(46);
        if (i == -1) {
            return "";
        }
        String p = packageName.substring(0, i);
        return p;
    }

    public static boolean isInteriorPackage(String packageName) {
        return interiorPackages.contains(packageName);
    }

    public static void cleanCode(String packageName, int loc, int classes) {
        String superpackage = TreemapVisualization.superpackage(packageName);
        if (buggyPackages.contains(superpackage) || interiorPackages.contains(superpackage) || superpackage.length() == 0) {
            goodCodeCount.add(packageName, classes);
            goodCodeSize.add(packageName, loc);
            if (superpackage.length() > 0) {
                interiorPackages.add(superpackage);
            }
        } else {
            TreemapVisualization.cleanCode(superpackage, loc, classes);
        }
    }

    public static void main(String[] args) throws Exception {
        DetectorFactoryCollection.instance();
        SortedBugCollection bugCollection = new SortedBugCollection();
        int argCount = 0;
        if (argCount < args.length) {
            bugCollection.readXML(args[argCount++]);
        } else {
            bugCollection.readXML(System.in);
        }
        for (PackageStats packageStats : bugCollection.getProjectStats().getPackageStats()) {
            if (packageStats.getTotalBugs() <= 0) continue;
            buggyPackages.add(packageStats.getPackageName());
            TreemapVisualization.addInteriorPackages(packageStats.getPackageName());
        }
        for (PackageStats packageStats : bugCollection.getProjectStats().getPackageStats()) {
            if (packageStats.getTotalBugs() != 0) continue;
            TreemapVisualization.cleanCode(packageStats.getPackageName(), packageStats.size(), packageStats.getClassStats().size());
        }
        System.out.println("LOC\tTypes\tH\tHM\tDensity");
        System.out.println("INTEGER\tINTEGER\tINTEGER\tINTEGER\tFLOAT");
        for (PackageStats packageStats : bugCollection.getProjectStats().getPackageStats()) {
            if (packageStats.getTotalBugs() <= 0) continue;
            int high = packageStats.getBugsAtPriority(1);
            int normal = packageStats.getBugsAtPriority(2);
            System.out.printf("%d\t%d\t%d\t%d\t%g\t\t%s", packageStats.size(), packageStats.getClassStats().size(), high, high + normal, (double)(high + normal) * 1000.0 / (double)packageStats.size(), packageStats.getPackageName().substring(11).replace('.', '\t'));
            if (TreemapVisualization.isInteriorPackage(packageStats.getPackageName())) {
                System.out.print("\t*");
            }
            System.out.println();
        }
        for (Map.Entry entry : goodCodeSize.entrySet()) {
            System.out.printf("%d\t%d\t%d\t%d\t%g\t\t%s\n", entry.getValue(), goodCodeCount.getCount((String)entry.getKey()), 0, 0, 0.0, ((String)entry.getKey()).substring(11).replace('.', '\t'));
        }
    }
}

