/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.runtime.cmd;

import java.io.File;
import java.util.List;
import net.sourceforge.pmd.cpd.Language;
import net.sourceforge.pmd.eclipse.runtime.properties.PropertiesException;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.ResourceWorkingSetFilter;

public class CPDVisitor
implements IResourceVisitor {
    private static final Logger log;
    private boolean includeDerivedFiles;
    private ResourceWorkingSetFilter workingSetFilter;
    private Language language;
    private List files;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sourceforge.pmd.eclipse.runtime.cmd.CPDVisitor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public void setIncludeDerivedFiles(boolean bl) {
        this.includeDerivedFiles = bl;
    }

    public void setWorkingSet(IWorkingSet iWorkingSet) {
        this.workingSetFilter = new ResourceWorkingSetFilter();
        this.workingSetFilter.setWorkingSet(iWorkingSet);
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    public List getFiles() {
        return this.files;
    }

    public void setFiles(List list) {
        this.files = list;
    }

    public boolean visit(IResource iResource) throws CoreException {
        log.debug((Object)("CPD Visiting " + iResource.getName()));
        boolean bl = true;
        if (iResource instanceof IFile) {
            IFile iFile = (IFile)iResource;
            File file = ((IFile)iResource).getLocation().toFile();
            try {
                if (((IFile)iResource).getFileExtension() != null && this.language.getFileFilter().accept(file, iFile.getName()) && this.isFileInWorkingSet(iFile) && (this.includeDerivedFiles || !this.includeDerivedFiles && !iFile.isDerived())) {
                    log.debug((Object)("Add file " + iResource.getName()));
                    this.files.add(file);
                    bl = false;
                }
            }
            catch (PropertiesException propertiesException) {
                log.warn((Object)("ModelException when adding file " + iResource.getName() + " to CPD. Continuing."), (Throwable)propertiesException);
            }
        }
        return bl;
    }

    private boolean isFileInWorkingSet(IFile iFile) throws PropertiesException {
        boolean bl = true;
        if (this.workingSetFilter != null) {
            bl = this.workingSetFilter.select(null, null, (Object)iFile);
        }
        return bl;
    }
}

