/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.editor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.jboss.tools.common.model.ui.editor.EditorPartFactory;
import org.jboss.tools.common.model.ui.editor.EditorPartWrapper;
import org.jboss.tools.common.model.ui.editor.EditorPartWrapperExtension;

public class EditorActionBarContributorWrapper
implements IEditorActionBarContributor {
    IActionBars bars;
    IWorkbenchPage page;
    Map<String, IEditorActionBarContributor> contributors = new HashMap<String, IEditorActionBarContributor>();
    IEditorActionBarContributor active;

    public void init(IActionBars bars, IWorkbenchPage page) {
        this.bars = bars;
        this.page = page;
    }

    public void setActiveEditor(IEditorPart targetEditor) {
        IEditorPart p = targetEditor instanceof EditorPartWrapper ? ((EditorPartWrapper)targetEditor).getEditor() : targetEditor;
        String entity = targetEditor instanceof EditorPartWrapper ? ((EditorPartWrapper)targetEditor).getEntity() : null;
        IEditorActionBarContributor c = this.getContributor(entity);
        if (c != this.active && c != null) {
            if (this.active != null) {
                this.active.setActiveEditor(null);
            }
            this.active = c;
            this.bars.getMenuManager().removeAll();
            this.bars.getToolBarManager().removeAll();
            this.bars.getStatusLineManager().removeAll();
            this.active.init(this.bars, this.page);
            this.bars.updateActionBars();
            this.bars.getToolBarManager().update(false);
        }
        if (this.active != null) {
            this.active.setActiveEditor(p);
        }
    }

    public void dispose() {
        if (this.active != null) {
            this.active.dispose();
        }
        this.contributors.clear();
    }

    public IEditorActionBarContributor getActiveContributer() {
        return this.active;
    }

    IEditorActionBarContributor getContributor(String entity) {
        IEditorActionBarContributor c;
        if (entity == null) {
            entity = "";
        }
        if ((c = this.contributors.get(entity)) == null) {
            EditorPartFactory f = EditorPartWrapperExtension.getInstance().getFactory(entity);
            if (f != null) {
                c = f.createEditorActionBarContributor();
            }
            if (c != null) {
                this.contributors.put(entity, c);
            }
        }
        return c;
    }
}

