/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.template;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.tools.vpe.VpePlugin;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeAbstractCreator;
import org.jboss.tools.vpe.editor.template.VpeAttributeCreator;
import org.jboss.tools.vpe.editor.template.VpeChildrenInfo;
import org.jboss.tools.vpe.editor.template.VpeCreator;
import org.jboss.tools.vpe.editor.template.VpeCreatorInfo;
import org.jboss.tools.vpe.editor.template.VpeDependencyMap;
import org.jboss.tools.vpe.editor.template.VpeTemplateManager;
import org.jboss.tools.vpe.editor.template.expression.VpeExpression;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionBuilder;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionBuilderException;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionException;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionInfo;
import org.jboss.tools.vpe.editor.template.expression.VpeValue;
import org.mozilla.interfaces.nsIDOMAttr;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VpeGridCreator
extends VpeAbstractCreator {
    static final String VAL_PAGE_DIRECTION = "pageDirection";
    private boolean caseSensitive;
    private VpeExpression layoutExpr;
    private VpeExpression tableSizeExpr;
    private List propertyCreators;
    private Set dependencySet;

    VpeGridCreator(Element gridElement, VpeDependencyMap dependencyMap, boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
        this.build(gridElement, dependencyMap);
    }

    private void build(Element gridElement, VpeDependencyMap dependencyMap) {
        Attr tableSizeAttr;
        Attr layoutAttr = gridElement.getAttributeNode("layout");
        if (layoutAttr != null) {
            try {
                VpeExpressionInfo info = VpeExpressionBuilder.buildCompletedExpression(layoutAttr.getValue(), this.caseSensitive);
                this.layoutExpr = info.getExpression();
                this.dependencySet = info.getDependencySet();
            }
            catch (VpeExpressionBuilderException e) {
                VpePlugin.reportProblem(e);
            }
        }
        if ((tableSizeAttr = gridElement.getAttributeNode("table-size")) != null) {
            try {
                VpeExpressionInfo info = VpeExpressionBuilder.buildCompletedExpression(tableSizeAttr.getValue(), this.caseSensitive);
                this.tableSizeExpr = info.getExpression();
                if (this.dependencySet == null) {
                    this.dependencySet = info.getDependencySet();
                } else {
                    this.dependencySet.addAll(info.getDependencySet());
                }
            }
            catch (VpeExpressionBuilderException e) {
                VpePlugin.reportProblem(e);
            }
        }
        if (VpeTemplateManager.ATTR_GRID_PROPERTIES != null) {
            int i = 0;
            while (i < VpeTemplateManager.ATTR_GRID_PROPERTIES.length) {
                String attrName = VpeTemplateManager.ATTR_GRID_PROPERTIES[i];
                Attr attr = gridElement.getAttributeNode(attrName);
                if (attr != null) {
                    if (this.propertyCreators == null) {
                        this.propertyCreators = new ArrayList();
                    }
                    this.propertyCreators.add(new VpeAttributeCreator(attrName, attr.getValue(), dependencyMap, this.caseSensitive));
                }
                ++i;
            }
        }
    }

    @Override
    public VpeCreatorInfo create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument, nsIDOMElement visualElement, Map visualNodeMap) throws VpeExpressionException {
        NodeList children;
        int count;
        VpeValue vpeValue;
        VpeValue vpeValue2;
        boolean layoutHorizontal = true;
        if (this.layoutExpr != null && (vpeValue2 = this.layoutExpr.exec(pageContext, sourceNode)) != null) {
            String strValue = vpeValue2.stringValue();
            layoutHorizontal = this.caseSensitive ? !VAL_PAGE_DIRECTION.equals(strValue) : !VAL_PAGE_DIRECTION.equalsIgnoreCase(strValue);
        }
        int tableSize = 0;
        if (this.tableSizeExpr != null && (vpeValue = this.tableSizeExpr.exec(pageContext, sourceNode)) != null) {
            String strValue = vpeValue.stringValue();
            try {
                int val = Integer.parseInt(strValue);
                if (val > 0) {
                    tableSize = val;
                }
            }
            catch (NumberFormatException e) {
                VpePlugin.getPluginLog().logError((Throwable)e);
            }
        }
        nsIDOMElement visualTable = visualDocument.createElement("table");
        VpeCreatorInfo creatorInfo = new VpeCreatorInfo((nsIDOMNode)visualTable);
        if (this.propertyCreators != null) {
            int i = 0;
            while (i < this.propertyCreators.size()) {
                VpeCreatorInfo info;
                VpeCreator creator = (VpeCreator)this.propertyCreators.get(i);
                if (creator != null && (info = creator.create(pageContext, (Element)sourceNode, visualDocument, visualTable, visualNodeMap)) != null && info.getVisualNode() != null) {
                    nsIDOMAttr attr = (nsIDOMAttr)info.getVisualNode();
                    visualTable.setAttributeNode(attr);
                }
                ++i;
            }
        }
        int n = count = (children = sourceNode.getChildNodes()) != null ? children.getLength() : 0;
        if (count > 0) {
            Node[] sourceChildren = new Node[count];
            int childrenCount = 0;
            int i = 0;
            while (i < count) {
                Node node = children.item(i);
                short type = node.getNodeType();
                if (type == 1 || type == 3 && node.getNodeValue().trim().length() > 0) {
                    sourceChildren[childrenCount] = node;
                    ++childrenCount;
                }
                ++i;
            }
            if (childrenCount > 0) {
                int rowLength;
                int rowCount;
                if (tableSize == 0) {
                    tableSize = childrenCount;
                }
                if (layoutHorizontal) {
                    rowCount = (childrenCount + tableSize - 1) / tableSize;
                    rowLength = tableSize;
                } else {
                    rowCount = tableSize;
                    rowLength = (childrenCount + tableSize - 1) / tableSize;
                }
                int i2 = 0;
                while (i2 < rowCount) {
                    nsIDOMElement visualRow = visualDocument.createElement("tr");
                    int j = 0;
                    while (j < rowLength) {
                        int sourceIndex;
                        nsIDOMElement visualCell = visualDocument.createElement("td");
                        visualRow.appendChild((nsIDOMNode)visualCell);
                        int n2 = sourceIndex = layoutHorizontal ? rowLength * i2 + j : rowCount * j + i2;
                        if (sourceIndex < childrenCount) {
                            VpeChildrenInfo childrenInfo = new VpeChildrenInfo(visualCell);
                            childrenInfo.addSourceChild(sourceChildren[sourceIndex]);
                            creatorInfo.addChildrenInfo(childrenInfo);
                        }
                        ++j;
                    }
                    visualTable.appendChild((nsIDOMNode)visualRow);
                    ++i2;
                }
            }
        }
        creatorInfo.addDependencySet(this.dependencySet);
        return creatorInfo;
    }
}

