/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.views.properties;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionPropertySource
implements IPropertySource {
    private Collection<?> collection;
    IPropertyDescriptor[] descriptors = null;
    Map<Object, Object> values = new WeakHashMap<Object, Object>();

    public CollectionPropertySource(Collection<?> propertyValue) {
        this.collection = propertyValue;
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.descriptors == null) {
            PropertyDescriptor[] properties = new PropertyDescriptor[this.collection.size()];
            int i = 0;
            while (i < properties.length) {
                properties[i] = new PropertyDescriptor((Object)i, "#" + i);
                ++i;
            }
            this.descriptors = properties;
        }
        return this.descriptors;
    }

    public Object getPropertyValue(Object id) {
        Object value = this.values.get(id);
        if (value == null) {
            Integer i = (Integer)id;
            Iterator<?> iterator = this.collection.iterator();
            int base = 0;
            while (iterator.hasNext()) {
                value = iterator.next();
                if (base == i) {
                    this.values.put(id, value);
                    return value;
                }
                value = null;
                ++base;
            }
        }
        return value;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

