/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.graph.figures;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.hibernate.eclipse.console.utils.EclipseImages;
import org.hibernate.eclipse.graph.figures.FiguresConstants;

public class NodeHeaderFigure
extends Figure {
    private static final Font NAMEFONT = new Font(null, "Arial", 9, 1);
    private static final Font TYPEFONT = new Font(null, "Arial", 9, 2);
    private Figure embeddedFigure;
    private Figure typeAndLabelColumn;
    private Label typeLabel;
    private Label nameLabel;
    private Label iconLabel;

    public NodeHeaderFigure(String nodeName, String nodeType, String iconName, boolean hideName) {
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setMajorAlignment(0);
        this.setLayoutManager((LayoutManager)flowLayout);
        this.addEmbeddedParent(nodeName, nodeType, iconName, hideName);
    }

    private void addEmbeddedParent(String nodeName, String nodeType, String iconDescriptor, boolean hideName) {
        this.embeddedFigure = new Figure();
        ToolbarLayout layout = new ToolbarLayout(true);
        layout.setMinorAlignment(0);
        this.embeddedFigure.setLayoutManager((LayoutManager)layout);
        this.addIconLabel(iconDescriptor);
        this.addTypeAndNameColumn(nodeType, nodeName, hideName);
        this.add((IFigure)this.embeddedFigure);
    }

    private void addTypeAndNameColumn(String nodeType, String nodeName, boolean hideName) {
        ToolbarLayout layout = new ToolbarLayout();
        layout.setStretchMinorAxis(false);
        layout.setMinorAlignment(0);
        this.typeAndLabelColumn = new Figure();
        this.typeAndLabelColumn.setLayoutManager((LayoutManager)layout);
        if (!hideName) {
            this.addNameLabel(nodeName);
        }
        this.embeddedFigure.add((IFigure)this.typeAndLabelColumn);
    }

    private void addNameLabel(String nodeName) {
        this.nameLabel = new Label();
        this.nameLabel.setBorder((Border)new MarginBorder(2));
        this.nameLabel.setForegroundColor(ColorConstants.darkGray);
        this.nameLabel.setFont(NAMEFONT);
        this.nameLabel.setText(nodeName);
        this.typeAndLabelColumn.add((IFigure)this.nameLabel);
    }

    private void addTypeLabel(String nodeType) {
        this.typeLabel = new Label();
        this.typeLabel.setBorder((Border)new MarginBorder(2));
        this.typeLabel.setForegroundColor(ColorConstants.darkGray);
        this.typeLabel.setFont(TYPEFONT);
        this.typeLabel.setText("<<" + nodeType + ">>");
        this.typeAndLabelColumn.add((IFigure)this.typeLabel);
    }

    private void addIconLabel(String iconDescriptor) {
        this.iconLabel = new Label();
        this.iconLabel.setBorder((Border)new MarginBorder(2));
        this.iconLabel.setIcon(EclipseImages.getImage(iconDescriptor));
        this.embeddedFigure.add((IFigure)this.iconLabel);
    }

    protected void paintClientArea(Graphics graphics) {
        Color foreground = graphics.getForegroundColor();
        graphics.setForegroundColor(FiguresConstants.white);
        graphics.fillGradient(this.getClientArea(), true);
        graphics.setForegroundColor(foreground);
        super.paintClientArea(graphics);
    }

    public void setNodeName(String name) {
        if (name != null && this.nameLabel != null) {
            this.nameLabel.setText(name);
        }
    }

    public Label getNameLabel() {
        return this.nameLabel;
    }
}

