/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.freemarker.model;

import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TypedRegion;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.source.ISourceViewer;
import org.jboss.ide.eclipse.freemarker.Plugin;
import org.jboss.ide.eclipse.freemarker.model.AbstractDirective;
import org.jboss.ide.eclipse.freemarker.model.IfDirective;
import org.jboss.ide.eclipse.freemarker.model.ItemSet;
import org.jboss.ide.eclipse.freemarker.model.ListDirective;

public class CompletionDirective
extends AbstractDirective {
    private String contents;
    private int offset;
    private int length;
    private AbstractDirective directive = this;

    public CompletionDirective(int offset, int length, ItemSet itemSet, ISourceViewer viewer, IResource resource) throws BadLocationException {
        this.contents = viewer.getDocument().get(offset, length);
        TypedRegion region = new TypedRegion(offset, this.contents.length(), "default");
        this.offset = offset;
        this.length = length;
        String[] arr = this.splitContents();
        if (arr != null || arr.length > 0) {
            String s = arr[0];
            try {
                if (s.equals("list")) {
                    this.directive = new ListDirective();
                    this.directive.load((ITypedRegion)new TypedRegion(offset, this.contents.length(), "list"), viewer, resource);
                    this.directive.setItemSet(itemSet);
                } else if (s.equals("if")) {
                    this.directive = new IfDirective();
                    this.directive.load((ITypedRegion)new TypedRegion(offset, this.contents.length(), "if"), viewer, resource);
                    this.directive.setItemSet(itemSet);
                }
            }
            catch (Exception e) {
                Plugin.log(e);
                this.directive = this;
            }
        }
        try {
            this.load((ITypedRegion)region, viewer, resource);
        }
        catch (Exception e) {
            Plugin.log(e);
        }
    }

    public int getOffset() {
        return this.offset;
    }

    public String getFullContents() {
        return this.contents;
    }

    public int getLength() {
        return this.length;
    }

    public ICompletionProposal[] getCompletionProposals(int offset, Map context) {
        if (this.directive.equals(this)) {
            return super.getCompletionProposals(offset, context);
        }
        return this.directive.getCompletionProposals(offset, context);
    }

    protected void init(ITypedRegion region, ISourceViewer viewer, IResource resource) throws Exception {
    }
}

