/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import name.herlin.command.CommandException;
import net.sourceforge.pmd.IRuleViolation;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.PMDException;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.dfa.DaaRule;
import net.sourceforge.pmd.dfa.IDataFlowNode;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.cmd.ReviewResourceForRuleCommand;
import net.sourceforge.pmd.eclipse.ui.model.FileRecord;
import net.sourceforge.pmd.eclipse.ui.views.DataflowAnomalyTableContentProvider;
import net.sourceforge.pmd.eclipse.ui.views.DataflowAnomalyTableLabelProvider;
import net.sourceforge.pmd.eclipse.ui.views.DataflowAnomalyTableViewer;
import net.sourceforge.pmd.eclipse.ui.views.DataflowGraph;
import net.sourceforge.pmd.eclipse.ui.views.DataflowGraphViewer;
import net.sourceforge.pmd.util.designer.DFAGraphRule;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.texteditor.ITextEditor;

public class DataflowViewPage
extends Page
implements IPropertyListener,
ISelectionChangedListener,
SelectionListener {
    private Composite dfaFrame;
    private CCombo methodSelection;
    private Button switchButton;
    protected Composite titleArea;
    protected DataflowGraphViewer graphViewer;
    protected DataflowAnomalyTableViewer tableViewer;
    private List pmdMethodList;
    private FileRecord resourceRecord;
    private ITextEditor textEditor;
    private boolean isTableShown;
    private boolean isTableRefreshed;

    public DataflowViewPage(IWorkbenchPart iWorkbenchPart, FileRecord fileRecord) {
        this.resourceRecord = fileRecord;
        if (iWorkbenchPart instanceof ITextEditor) {
            this.textEditor = (ITextEditor)iWorkbenchPart;
        }
    }

    public void createControl(Composite composite) {
        this.dfaFrame = new Composite(composite, 0);
        this.titleArea = new Composite(this.dfaFrame, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.titleArea.setLayoutData((Object)gridData);
        this.titleArea.setLayout((Layout)new GridLayout(3, false));
        this.methodSelection = new CCombo(this.titleArea, 18444);
        this.refreshPMDMethods();
        this.methodSelection.setText(this.getString("view.dataflow.choose_method"));
        this.methodSelection.setLayoutData((Object)new GridData(200, -1));
        this.methodSelection.addSelectionListener((SelectionListener)this);
        Label label = new Label(this.titleArea, 0);
        label.setLayoutData((Object)new GridData(768));
        this.switchButton = new Button(this.titleArea, 131072);
        this.switchButton.setLayoutData((Object)new GridData(130, 20));
        this.switchButton.addSelectionListener((SelectionListener)this);
        this.switchButton.setText(this.getString("view.dataflow.switchbutton.show"));
        this.graphViewer = new DataflowGraphViewer(this.dfaFrame, 0);
        this.graphViewer.setVisible(false);
        this.tableViewer = new DataflowAnomalyTableViewer(this.dfaFrame, 2048);
        this.tableViewer.addSelectionChangedListener(this);
        this.tableViewer.setContentProvider((IContentProvider)new DataflowAnomalyTableContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new DataflowAnomalyTableLabelProvider());
        this.isTableRefreshed = false;
        GridLayout gridLayout = new GridLayout(2, true);
        gridLayout.verticalSpacing = 7;
        gridLayout.horizontalSpacing = 7;
        gridLayout.marginWidth = 3;
        gridLayout.marginHeight = 3;
        this.dfaFrame.setLayout((Layout)gridLayout);
        this.showTableArea(false);
    }

    public void dispose() {
    }

    private void refreshPMDMethods() {
        this.pmdMethodList = this.getPMDMethods();
        this.methodSelection.removeAll();
        int n = 0;
        while (n < this.pmdMethodList.size()) {
            ASTMethodDeclaration aSTMethodDeclaration = (ASTMethodDeclaration)this.pmdMethodList.get(n);
            this.methodSelection.add(this.getMethodLabel(aSTMethodDeclaration), n);
            ++n;
        }
    }

    private String getMethodLabel(ASTMethodDeclaration aSTMethodDeclaration) {
        return String.valueOf(aSTMethodDeclaration.getMethodName()) + " (line " + aSTMethodDeclaration.getBeginLine() + "-" + aSTMethodDeclaration.getEndLine() + ")";
    }

    public Control getControl() {
        return this.dfaFrame;
    }

    public void setFocus() {
        this.methodSelection.setFocus();
    }

    public FileRecord getFileRecord() {
        return this.resourceRecord;
    }

    private void showMethod(int n) {
        if (n >= 0 && n < this.pmdMethodList.size()) {
            ASTMethodDeclaration aSTMethodDeclaration = (ASTMethodDeclaration)this.pmdMethodList.get(n);
            this.showMethod(aSTMethodDeclaration);
        }
    }

    private void showMethod(final ASTMethodDeclaration aSTMethodDeclaration) {
        if (aSTMethodDeclaration != null) {
            String string = this.getDocument().get();
            this.graphViewer.setVisible(true);
            this.graphViewer.setData((SimpleNode)aSTMethodDeclaration, string);
            this.graphViewer.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent mouseEvent) {
                    if (DataflowViewPage.this.textEditor != null) {
                        int n = (int)((double)mouseEvent.y / 49.0);
                        DataflowViewPage.this.graphViewer.getGraph().demark();
                        DataflowViewPage.this.graphViewer.getGraph().markNode(n);
                        int n2 = ((IDataFlowNode)aSTMethodDeclaration.getDataFlowNode().getFlow().get(n)).getLine() - 1;
                        int n3 = 0;
                        int n4 = 0;
                        try {
                            n3 = DataflowViewPage.this.getDocument().getLineOffset(n2);
                            n4 = DataflowViewPage.this.getDocument().getLineLength(n2);
                        }
                        catch (BadLocationException badLocationException) {
                            PMDPlugin.getDefault().logError("message.error.runtime_exceptionException when selecting a line in the editor", badLocationException);
                        }
                        DataflowViewPage.this.textEditor.selectAndReveal(n3, n4);
                        DataflowViewPage.this.tableViewer.getTable().deselectAll();
                    }
                }
            });
            this.showTableArea(this.isTableShown);
        }
    }

    private void showMethodToViolation(IRuleViolation iRuleViolation) {
        int n = iRuleViolation.getBeginLine();
        int n2 = 0;
        while (n2 < this.pmdMethodList.size()) {
            ASTMethodDeclaration aSTMethodDeclaration = (ASTMethodDeclaration)this.pmdMethodList.get(n2);
            if (n >= aSTMethodDeclaration.getBeginLine() && n <= aSTMethodDeclaration.getEndLine()) {
                this.showMethod(aSTMethodDeclaration);
                this.methodSelection.select(n2);
                return;
            }
            ++n2;
        }
    }

    private List getPMDMethods() {
        ArrayList arrayList = new ArrayList();
        try {
            DFAGraphRule dFAGraphRule = new DFAGraphRule();
            RuleSet ruleSet = new RuleSet();
            ruleSet.addRule((Rule)dFAGraphRule);
            RuleContext ruleContext = new RuleContext();
            ruleContext.setSourceCodeFilename("[scratchpad]");
            StringReader stringReader = new StringReader(this.getDocument().get());
            new PMD().processFile((Reader)stringReader, ruleSet, ruleContext);
            arrayList.addAll(dFAGraphRule.getMethods());
        }
        catch (PMDException pMDException) {
            PMDPlugin.getDefault().logError("message.error.pmd_exception" + ((Object)((Object)this)).toString(), pMDException);
        }
        return arrayList;
    }

    public IDocument getDocument() {
        return this.textEditor.getDocumentProvider().getDocument((Object)this.textEditor.getEditorInput());
    }

    private void showTableArea(boolean bl) {
        this.tableViewer.setVisible(bl);
        if (bl) {
            ((GridData)this.graphViewer.getLayoutData()).horizontalSpan = 1;
            this.switchButton.setText(this.getString("view.dataflow.switchbutton.hide"));
            if (!this.isTableRefreshed) {
                this.refreshDFATable(this.resourceRecord.getResource());
            }
        } else {
            ((GridData)this.graphViewer.getLayoutData()).horizontalSpan = 2;
            this.switchButton.setText(this.getString("view.dataflow.switchbutton.show"));
        }
        this.dfaFrame.layout(true, true);
    }

    private String getString(String string) {
        return PMDPlugin.getDefault().getStringTable().getString(string);
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        Object object;
        if (selectionChangedEvent.getSelection() instanceof IStructuredSelection && (object = ((IStructuredSelection)selectionChangedEvent.getSelection()).getFirstElement()) instanceof IRuleViolation) {
            IRuleViolation iRuleViolation = (IRuleViolation)object;
            String string = iRuleViolation.getVariableName();
            int n = iRuleViolation.getBeginLine();
            int n2 = iRuleViolation.getEndLine();
            if (n != 0 && n2 != 0 && !"".equals(string)) {
                try {
                    int n3 = this.getDocument().getLineOffset(iRuleViolation.getBeginLine() - 1);
                    int n4 = this.getDocument().getLineOffset(iRuleViolation.getEndLine()) - n3;
                    this.textEditor.selectAndReveal(n3, n4);
                }
                catch (BadLocationException badLocationException) {
                    PMDPlugin.getDefault().logError("message.error.runtime_exceptionException when selecting a line in the editor", badLocationException);
                }
                this.showMethodToViolation(iRuleViolation);
                DataflowGraph dataflowGraph = this.graphViewer.getGraph();
                if (!this.graphViewer.isDisposed() && dataflowGraph != null) {
                    dataflowGraph.markPath(n, n2, string);
                }
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        if (this.methodSelection.equals(selectionEvent.widget)) {
            this.showMethod(this.methodSelection.getSelectionIndex());
        }
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (this.switchButton.equals(selectionEvent.widget)) {
            this.isTableShown = !this.isTableShown;
            this.showTableArea(this.isTableShown);
            if (!this.isTableShown) {
                if (this.graphViewer == null || this.graphViewer.getGraph() == null) {
                    return;
                }
                DataflowGraph dataflowGraph = this.graphViewer.getGraph();
                if (dataflowGraph.isMarked()) {
                    dataflowGraph.demark();
                }
            }
        } else if (this.methodSelection.equals(selectionEvent.widget)) {
            int n = this.methodSelection.getSelectionIndex();
            this.methodSelection.setSelection(new Point(0, 0));
            this.showMethod(n);
        }
    }

    public void refresh(IResource iResource) {
        if (iResource.getType() == 1) {
            this.resourceRecord = new FileRecord(iResource);
        }
        if (this.isTableShown) {
            this.refreshDFATable(iResource);
        } else {
            this.isTableRefreshed = false;
        }
        int n = this.methodSelection.getSelectionIndex();
        this.refreshPMDMethods();
        this.showMethod(n);
        this.methodSelection.select(n);
    }

    public void refreshDFATable(IResource iResource) {
        this.isTableRefreshed = true;
        try {
            ReviewResourceForRuleCommand reviewResourceForRuleCommand = new ReviewResourceForRuleCommand();
            DaaRule daaRule = new DaaRule();
            daaRule.setUsesDFA();
            reviewResourceForRuleCommand.setUserInitiated(false);
            reviewResourceForRuleCommand.setRule((Rule)daaRule);
            reviewResourceForRuleCommand.setResource(iResource);
            reviewResourceForRuleCommand.addPropertyListener(this);
            reviewResourceForRuleCommand.performExecute();
        }
        catch (CommandException commandException) {
            PMDPlugin.getDefault().logError(this.getString("message.error.pmd_exception"), commandException);
        }
    }

    public void propertyChanged(Object object, int n) {
        if (object instanceof Iterator && n == 1112) {
            this.tableViewer.setInput(object);
        }
    }
}

