/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.attribute.adapter;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.meta.XModelEntity;
import org.jboss.tools.common.meta.action.XAction;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.meta.action.XAttributeData;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.event.XModelTreeEvent;
import org.jboss.tools.common.model.event.XModelTreeListener;
import org.jboss.tools.common.model.ui.IStructuredChangeListener;
import org.jboss.tools.common.model.ui.StructuredChangedEvent;
import org.jboss.tools.common.model.ui.action.sample.XActionWrapper;
import org.jboss.tools.common.model.ui.actions.IActionProvider;
import org.jboss.tools.common.model.ui.attribute.adapter.IModelPropertyEditorAdapter;
import org.jboss.tools.common.model.ui.attribute.adapter.ITableAdapter;
import org.jboss.tools.common.model.ui.dnd.DnDUtil;
import org.jboss.tools.common.model.util.XModelTreeListenerSWTASync;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XChildrenTableStructuredAdapter
implements IAdaptable,
ITableAdapter,
IModelPropertyEditorAdapter,
ISelectionChangedListener,
ISelectionProvider {
    public static final String ADD_LABEL = "&Add...";
    public static final String REMOVE_LABEL = "&Remove...";
    public static final String EDIT_LABEL = "&Edit...";
    public static final String UP_LABEL = "&Up";
    public static final String DOWN_LABEL = "&Down";
    private static final String COPY_XACTION_PATH = "CopyActions.Copy";
    private static final String MOVE_XACTION_PATH = "MoveActions.Move";
    private XModelTreeListener modelTreeListener;
    private XModelTreeListenerSWTASync asyncListener;
    private TableColumn[] tableColumn;
    private Table table;
    private XModel model;
    private XAttribute attribute;
    private XModelObject xmo;
    private Object value;
    private long[] timeStamps;
    private String[] shownProperties;
    private String[] shownEntities;
    private int[] widths;
    private String[] columnLabels;
    private HashMap<String, String> actionMapping = new HashMap();
    private XModelObject selectedObject;
    private ArrayList<IStructuredChangeListener> structureChangeListener = new ArrayList();
    private ArrayList<ISelectionChangedListener> selectionChangeListener = new ArrayList();
    private ISelection selection;
    private boolean makeDefaultActions = true;
    private ActionProvider actionProvider;
    private ISelectionChangedListener selectionChangedListener;
    private ITableLabelProvider tableLabelProvider = new DefaultTableLabelProvider();

    @Override
    public TableColumn[] createTableColumn(Table table, int style) {
        this.table = table;
        if (this.tableColumn == null) {
            if (this.shownProperties == null || this.shownProperties.length == 0) {
                this.shownProperties = new String[]{"name"};
                this.widths = new int[]{100};
            }
            this.tableColumn = new TableColumn[this.shownProperties.length];
            TableLayout layout = new TableLayout();
            int i = 0;
            while (i < this.tableColumn.length) {
                this.tableColumn[i] = new TableColumn(table, style);
                if (this.columnLabels != null && this.columnLabels.length > i) {
                    this.tableColumn[i].setText(this.columnLabels[i]);
                } else {
                    this.tableColumn[i].setText(this.shownProperties[i]);
                }
                ColumnWeightData layoutData = new ColumnWeightData(this.widths[i], true);
                layout.addColumnData((ColumnLayoutData)layoutData);
                ++i;
            }
            table.setLayout((Layout)layout);
            if (this.tableColumn.length < 4) {
                table.addControlListener((ControlListener)new Resize(table));
            }
        }
        return this.tableColumn;
    }

    public Object[] getElements(Object inputElement) {
        if (this.value == null) {
            return new Object[0];
        }
        return (Object[])this.value;
    }

    @Override
    public void dispose() {
        if (this.model != null) {
            this.model.removeModelTreeListener((XModelTreeListener)this.asyncListener);
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Color getForeground(Object element) {
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }

    @Override
    public void setModel(XModel model) {
        this.model = model;
    }

    @Override
    public void setAttribute(XAttribute attribute) {
        this.attribute = attribute;
    }

    @Override
    public XAttribute getAttribute() {
        return this.attribute;
    }

    @Override
    public void setModelObject(XModelObject modelObject) {
        this.xmo = modelObject;
        this.model = modelObject.getModel();
        this.value = this.applyEntitiesFilter(modelObject.getChildren());
        this.timeStamps = this.createTimeStamps();
        this.modelTreeListener = new XMTL();
        this.asyncListener = new XModelTreeListenerSWTASync(this.modelTreeListener);
        if (this.model != null) {
            this.model.addModelTreeListener((XModelTreeListener)this.asyncListener);
        }
    }

    @Override
    public void setAttributeData(XAttributeData attributeData) {
    }

    private long[] createTimeStamps() {
        XModelObject[] os = (XModelObject[])this.value;
        long[] ts = this.value == null ? new long[]{} : new long[os.length];
        int i = 0;
        while (i < ts.length) {
            ts[i] = os[i].getTimeStamp();
            ++i;
        }
        return ts;
    }

    @Override
    public void load() {
    }

    @Override
    public void store() {
    }

    @Override
    public void setAutoStore(boolean autoStore) {
    }

    @Override
    public void addValueChangeListener(PropertyChangeListener l) {
    }

    @Override
    public void removeValueChangeListener(PropertyChangeListener l) {
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value) {
        this.value = value;
        this.value = this.applyEntitiesFilter((XModelObject[])value);
        this.timeStamps = this.createTimeStamps();
    }

    @Override
    public String getStringValue(boolean returnNullAsEmptyString) {
        return this.value instanceof String ? (String)this.value : null;
    }

    @Override
    public void valueChange(PropertyChangeEvent event) {
    }

    public void setShownProperties(String[] shownProperties) {
        this.shownProperties = shownProperties;
    }

    public void setShownEntities(String[] shownEntities) {
        this.shownEntities = shownEntities;
        this.value = this.applyEntitiesFilter((XModelObject[])this.value);
        this.timeStamps = this.createTimeStamps();
    }

    private Object[] applyEntitiesFilter(XModelObject[] children) {
        Object[] result = null;
        if (this.shownEntities == null) {
            return children;
        }
        if (this.xmo != null) {
            HashSet<String> shownEntities = new HashSet<String>();
            if (this.shownEntities != null) {
                int i = 0;
                while (i < this.shownEntities.length) {
                    shownEntities.add(this.shownEntities[i]);
                    ++i;
                }
            }
            if (children != null) {
                ArrayList<XModelObject> shownChilds = new ArrayList<XModelObject>();
                int i = 0;
                while (i < children.length) {
                    if (shownEntities.contains(children[i].getModelEntity().getName())) {
                        shownChilds.add(children[i]);
                    }
                    ++i;
                }
                result = shownChilds.toArray(new XModelObject[shownChilds.size()]);
            }
        }
        return result;
    }

    public void setWidths(int[] is) {
        this.widths = is;
    }

    public void setColumnLabels(String[] strings) {
        this.columnLabels = strings;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IActionProvider.class) {
            return this.getActionProvider();
        }
        return this;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSelection() instanceof StructuredSelection) {
            StructuredSelection structuredSelection = (StructuredSelection)event.getSelection();
            Object object = structuredSelection.getFirstElement();
            this.selectedObject = (XModelObject)object;
            this.actionProvider.setXModelObject(this.selectedObject);
        }
    }

    @Override
    public void addStructureChangeListener(IStructuredChangeListener listener) {
        this.structureChangeListener.add(listener);
    }

    @Override
    public void removeStructureChangeListener(IStructuredChangeListener listener) {
        this.structureChangeListener.remove(listener);
    }

    protected void fireStructureChange() {
        this.updateValue();
        ArrayList<IStructuredChangeListener> copy = new ArrayList<IStructuredChangeListener>(this.structureChangeListener);
        Iterator<IStructuredChangeListener> i = copy.iterator();
        while (i.hasNext()) {
            i.next().structureChanged(new StructuredChangedEvent(this));
        }
        copy.clear();
        if (this.actionProvider != null) {
            this.actionProvider.setXModelObject(this.selectedObject);
        }
    }

    private void updateValue() {
        this.value = this.applyEntitiesFilter(this.xmo.getChildren());
        this.timeStamps = this.createTimeStamps();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangeListener.add(listener);
    }

    public ISelection getSelection() {
        this.selection = new StructuredSelection(new Object[]{this.selectedObject});
        return this.selection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangeListener.remove(listener);
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
    }

    protected void fireSelectionChange() {
        ArrayList<ISelectionChangedListener> copy = new ArrayList<ISelectionChangedListener>(this.selectionChangeListener);
        Iterator<ISelectionChangedListener> i = copy.iterator();
        while (i.hasNext()) {
            i.next().selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
        }
        copy.clear();
    }

    private boolean isCanBeMoveChildren() {
        if (this.shownEntities != null && this.shownEntities.length > 0 && this.xmo != null) {
            XModelEntity entity = this.xmo.getModel().getMetaData().getEntity(this.shownEntities[0]);
            XAction copyXAction = entity.getActionList().getAction(COPY_XACTION_PATH);
            XAction moveXAction = entity.getActionList().getAction(MOVE_XACTION_PATH);
            if (copyXAction != null && moveXAction != null) {
                return true;
            }
        }
        return false;
    }

    private void initializeActionProvider() {
        this.actionProvider = new ActionProvider(this.makeDefaultActions, this.isCanBeMoveChildren());
        this.actionProvider.setXModelObject(this.selectedObject);
    }

    @Override
    public IActionProvider getActionProvider() {
        if (this.actionProvider == null) {
            this.initializeActionProvider();
        }
        return this.actionProvider;
    }

    public HashMap<String, String> getActionMapping() {
        return this.actionMapping;
    }

    public ISelectionChangedListener getSelectionChangedListener() {
        return this.selectionChangedListener;
    }

    public void setSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListener = listener;
    }

    private boolean equals(long[] array1, long[] array2) {
        if (array1 == null && array2 == null) {
            return true;
        }
        if (array1 != null && array2 != null) {
            if (array1.length != array2.length) {
                return false;
            }
            int i = 0;
            while (i < array1.length) {
                if (array1[i] != array2[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private void update() {
        Object[] newValue = this.applyEntitiesFilter(this.xmo.getChildren());
        long[] ts = this.createTimeStamps();
        if (!this.equals(this.timeStamps, ts) || !this.areArraysEqual((Object[])this.value, newValue)) {
            this.value = newValue;
            this.timeStamps = ts;
            this.fireStructureChange();
        }
    }

    private boolean areArraysEqual(Object[] os1, Object[] os2) {
        if (os1 == null && os2 == null) {
            return true;
        }
        if (os1 != null && os2 != null && os1.length == os2.length) {
            int i = 0;
            while (i < os1.length) {
                if (os1[i] != os2[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    @Override
    public ITableLabelProvider getTableLabelProvider() {
        return this.tableLabelProvider;
    }

    @Override
    public void setTableLabelProvider(ITableLabelProvider tableLabelProvider) {
        this.tableLabelProvider = tableLabelProvider;
    }

    @Override
    public boolean hasErrors() {
        return false;
    }

    public boolean isMakeDefaultActions() {
        return this.makeDefaultActions;
    }

    public void setMakeDefaultActions(boolean makeDefaultActions) {
        this.makeDefaultActions = makeDefaultActions;
    }

    @Override
    public String getError() {
        return null;
    }

    @Override
    public void addErrorStateListener(PropertyChangeListener l) {
    }

    class ActionProvider
    implements IActionProvider {
        private ArrayList<IAction> actions = new ArrayList();
        private HashMap<String, IAction> hash = new HashMap();
        private boolean showUpDown = true;
        XActionWrapper addAction;
        XActionWrapper removeAction;
        XActionWrapper editAction;
        XActionWrapper upAction;
        XActionWrapper downAction;

        private ActionProvider() {
            this.addAction = new AddAction(XChildrenTableStructuredAdapter.ADD_LABEL);
            this.removeAction = new RemoveAction(XChildrenTableStructuredAdapter.REMOVE_LABEL);
            this.editAction = new EditAction(XChildrenTableStructuredAdapter.EDIT_LABEL);
            this.upAction = new MoveUpAction();
            this.downAction = new MoveDownAction();
        }

        public ActionProvider(boolean makeDefaultActions, boolean showUpDown) {
            this.addAction = new AddAction(XChildrenTableStructuredAdapter.ADD_LABEL);
            this.removeAction = new RemoveAction(XChildrenTableStructuredAdapter.REMOVE_LABEL);
            this.editAction = new EditAction(XChildrenTableStructuredAdapter.EDIT_LABEL);
            this.upAction = new MoveUpAction();
            this.downAction = new MoveDownAction();
            this.showUpDown = showUpDown;
            if (makeDefaultActions) {
                this.actions.add((IAction)this.addAction);
                this.actions.add((IAction)this.removeAction);
                this.actions.add((IAction)this.editAction);
                if (this.showUpDown) {
                    this.actions.add((IAction)this.upAction);
                    this.actions.add((IAction)this.downAction);
                }
                this.hash.put("ADD_ACTION", (IAction)this.addAction);
                this.hash.put("REMOVE_ACTION", (IAction)this.removeAction);
                this.hash.put("EDIT_ACTION", (IAction)this.editAction);
                if (this.showUpDown) {
                    this.hash.put("UP_ACTION", (IAction)this.upAction);
                    this.hash.put("DOWN_ACTION", (IAction)this.downAction);
                }
                this.hash.put("DOUBLE_CLICK__ACTION", (IAction)this.editAction);
            }
        }

        public void update(ISelection selection) {
            this.removeAction.updateState();
            this.editAction.updateState();
        }

        public void setXModelObject(XModelObject xmo) {
            this.addAction.setXModelObject(XChildrenTableStructuredAdapter.this.xmo);
            this.addAction.setActionPath((String)XChildrenTableStructuredAdapter.this.actionMapping.get("ADD_ACTION"));
            this.removeAction.setXModelObject(xmo);
            this.removeAction.setActionPath((String)XChildrenTableStructuredAdapter.this.actionMapping.get("REMOVE_ACTION"));
            this.editAction.setXModelObject(xmo);
            this.editAction.setActionPath((String)XChildrenTableStructuredAdapter.this.actionMapping.get("EDIT_ACTION"));
            if (this.showUpDown) {
                this.upAction.setXModelObject(xmo);
                this.upAction.setActionPath((String)XChildrenTableStructuredAdapter.this.actionMapping.get("UP_ACTION"));
                this.downAction.setXModelObject(xmo);
                this.downAction.setActionPath((String)XChildrenTableStructuredAdapter.this.actionMapping.get("DOWN_ACTION"));
            }
        }

        public IAction getAction(String actionName) {
            return this.hash.get(actionName);
        }

        public IAction[] getActions() {
            return this.actions.toArray(new IAction[this.actions.size()]);
        }
    }

    class AddAction
    extends XActionWrapper {
        public AddAction(String label) {
            super(label);
        }

        public void run() {
            super.run();
            XChildrenTableStructuredAdapter.this.fireStructureChange();
        }

        protected void initRunningProperties(Properties p) {
        }
    }

    class DefaultTableLabelProvider
    implements ITableLabelProvider {
        DefaultTableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            XModelObject xmo = (XModelObject)element;
            String result = xmo.getAttributeValue(XChildrenTableStructuredAdapter.this.shownProperties[columnIndex]);
            return result != null ? result : MessageFormat.format("no attribute called {0} on entity {1}", XChildrenTableStructuredAdapter.this.shownProperties[columnIndex], xmo.getModelEntity().getName());
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return true;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    class EditAction
    extends XActionWrapper {
        public EditAction() {
        }

        public EditAction(String label) {
            super(label);
        }

        public void setActionPath(String path) {
            this.path = path;
            if ("%SelectIt%".equals(path)) {
                if (this.xmo != null) {
                    this.setEnabled(true);
                } else {
                    this.setEnabled(false);
                }
                return;
            }
            if (this.xmo == null || path == null) {
                this.setEnabled(false);
            } else {
                this.setEnabled(DnDUtil.getEnabledAction(this.xmo, null, path) != null);
            }
        }

        public void setXModelObject(XModelObject xmo) {
            this.xmo = xmo;
            if ("%SelectIt%".equals(this.path)) {
                if (xmo != null) {
                    this.setEnabled(true);
                } else {
                    this.setEnabled(false);
                }
                return;
            }
            if (xmo == null || this.path == null) {
                this.setEnabled(false);
            } else {
                this.setEnabled(xmo.getModelEntity().getActionList().getAction(this.path) != null);
            }
        }

        public void run() {
            if ("%SelectIt%".equals(this.path)) {
                if (XChildrenTableStructuredAdapter.this.selectionChangedListener != null) {
                    if (this.xmo == null) {
                        return;
                    }
                    StructuredSelection selection = new StructuredSelection((Object)this.xmo);
                    SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)new SelectionProvider((ISelection)selection), (ISelection)selection);
                    XChildrenTableStructuredAdapter.this.selectionChangedListener.selectionChanged(event);
                }
            } else {
                super.run();
            }
            XChildrenTableStructuredAdapter.this.fireStructureChange();
        }
    }

    class MoveAction
    extends XActionWrapper {
        public MoveAction(String label) {
            super(label);
        }

        public void setActionPath(String path) {
        }

        public void setXModelObject(XModelObject xmo) {
            XModelObject[] list = (XModelObject[])XChildrenTableStructuredAdapter.this.value;
            this.xmo = xmo;
            if (xmo != null) {
                int index = this.getIndex(list, xmo);
                int targetIngex = this.getTargetIndex(index);
                boolean actionEnabled = xmo.getModelEntity().getActionList().getAction(XChildrenTableStructuredAdapter.COPY_XACTION_PATH) != null && xmo.getModelEntity().getActionList().getAction(XChildrenTableStructuredAdapter.MOVE_XACTION_PATH) != null;
                this.setEnabled(actionEnabled && targetIngex >= 0 && targetIngex < list.length && xmo.isObjectEditable());
            } else {
                this.setEnabled(false);
            }
        }

        private int getIndex(XModelObject[] list, XModelObject child) {
            int i = 0;
            while (i < list.length) {
                if (child.equals(list[i])) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public void run() {
            int targetIndex;
            XModelObject[] list = (XModelObject[])XChildrenTableStructuredAdapter.this.value;
            int index = this.getIndex(list, this.xmo);
            if (index == (targetIndex = this.getTargetIndex(index)) || targetIndex < 0 || targetIndex >= list.length) {
                return;
            }
            XActionInvoker.invoke((String)XChildrenTableStructuredAdapter.COPY_XACTION_PATH, (XModelObject)this.xmo, null, (Properties)new Properties());
            XModelObject prev = list[targetIndex];
            XActionInvoker.invoke((String)XChildrenTableStructuredAdapter.MOVE_XACTION_PATH, (XModelObject)prev, null, (Properties)new Properties());
            if (XChildrenTableStructuredAdapter.this.table != null && !XChildrenTableStructuredAdapter.this.table.isDisposed()) {
                XChildrenTableStructuredAdapter.this.table.setSelection(targetIndex);
            }
            XChildrenTableStructuredAdapter.this.fireStructureChange();
        }

        protected int getTargetIndex(int index) {
            return index;
        }
    }

    class MoveDownAction
    extends MoveAction {
        public MoveDownAction() {
            super(XChildrenTableStructuredAdapter.DOWN_LABEL);
        }

        protected int getTargetIndex(int index) {
            return index + 1;
        }
    }

    class MoveUpAction
    extends MoveAction {
        public MoveUpAction() {
            super(XChildrenTableStructuredAdapter.UP_LABEL);
        }

        protected int getTargetIndex(int index) {
            return index - 1;
        }
    }

    class RemoveAction
    extends XActionWrapper {
        public RemoveAction(String label) {
            super(label);
        }

        public void run() {
            super.run();
            XChildrenTableStructuredAdapter.this.fireStructureChange();
        }
    }

    class Resize
    extends ControlAdapter {
        private boolean resizeLock = false;
        Table table;

        Resize(Table table) {
            this.table = table;
        }

        public void controlResized(ControlEvent e) {
            this.updateColumnWidth();
        }

        private void updateColumnWidth() {
            if (this.resizeLock) {
                return;
            }
            if (this.table == null || this.table.getColumnCount() == 0) {
                return;
            }
            this.resizeLock = true;
            int w = this.table.getClientArea().width - 1;
            int cw = 0;
            int hs = 0;
            int i = 0;
            while (i < this.table.getColumnCount()) {
                cw += this.table.getColumn(i).getWidth();
                hs += this.getWidthHint(i);
                ++i;
            }
            i = 0;
            while (i < this.table.getColumnCount()) {
                TableColumn c = this.table.getColumn(i);
                int dw = (w - cw) * this.getWidthHint(i) / hs;
                try {
                    c.setWidth(c.getWidth() + dw);
                }
                catch (SWTException sWTException) {}
                ++i;
            }
            this.resizeLock = false;
        }

        protected int getWidthHint(int i) {
            return XChildrenTableStructuredAdapter.this.widths == null || XChildrenTableStructuredAdapter.this.widths.length < 2 || XChildrenTableStructuredAdapter.this.widths[i] == 0 ? 10 : XChildrenTableStructuredAdapter.this.widths[i];
        }
    }

    class SelectionProvider
    implements ISelectionProvider {
        ISelection selection;

        public SelectionProvider(ISelection selection) {
            this.selection = selection;
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public ISelection getSelection() {
            return this.selection;
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public void setSelection(ISelection selection) {
        }
    }

    class XMTL
    implements XModelTreeListener {
        XMTL() {
        }

        public void nodeChanged(XModelTreeEvent event) {
            String opath = (String)event.getInfo();
            String npath = event.getModelObject().getPath();
            opath.equals(npath);
            if (XChildrenTableStructuredAdapter.this.xmo == null) {
                return;
            }
            String rootPath = XChildrenTableStructuredAdapter.this.xmo.getPath();
            String eventPath = event.getModelObject().getPath();
            if (rootPath == null || eventPath == null || !eventPath.startsWith(rootPath)) {
                return;
            }
            XChildrenTableStructuredAdapter.this.update();
        }

        public void structureChanged(XModelTreeEvent event) {
            if (XChildrenTableStructuredAdapter.this.xmo == null) {
                return;
            }
            String rootPath = XChildrenTableStructuredAdapter.this.xmo.getPath();
            String eventPath = event.getModelObject().getPath();
            if (rootPath == null || eventPath == null || !eventPath.startsWith(rootPath)) {
                return;
            }
            if (event.kind() == 3) {
                XChildrenTableStructuredAdapter.this.update();
            } else if (event.kind() == 1) {
                XChildrenTableStructuredAdapter.this.update();
                XModelObject addedObject = (XModelObject)event.getInfo();
                if (addedObject != null) {
                    XChildrenTableStructuredAdapter.this.selectedObject = addedObject;
                }
                XChildrenTableStructuredAdapter.this.fireSelectionChange();
            } else if (event.kind() == 2) {
                XChildrenTableStructuredAdapter.this.update();
            }
        }
    }
}

