/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.storage.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.errors.PackMismatchException;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectDatabase;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.storage.file.CachedObjectDirectory;
import org.eclipse.jgit.storage.file.FileObjectDatabase;
import org.eclipse.jgit.storage.file.FileRepository;
import org.eclipse.jgit.storage.file.FileSnapshot;
import org.eclipse.jgit.storage.file.LocalCachedPack;
import org.eclipse.jgit.storage.file.LocalObjectRepresentation;
import org.eclipse.jgit.storage.file.ObjectDirectoryInserter;
import org.eclipse.jgit.storage.file.PackFile;
import org.eclipse.jgit.storage.file.UnpackedObject;
import org.eclipse.jgit.storage.file.UnpackedObjectCache;
import org.eclipse.jgit.storage.file.WindowCursor;
import org.eclipse.jgit.storage.pack.CachedPack;
import org.eclipse.jgit.storage.pack.ObjectToPack;
import org.eclipse.jgit.storage.pack.PackWriter;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.RawParseUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectDirectory
extends FileObjectDatabase {
    private static final PackList NO_PACKS = new PackList(FileSnapshot.DIRTY, new PackFile[0]);
    private static final int RESOLVE_ABBREV_LIMIT = 256;
    private final Config config;
    private final File objects;
    private final File infoDirectory;
    private final File packDirectory;
    private final File alternatesFile;
    private final File cachedPacksFile;
    private final AtomicReference<PackList> packList;
    private final AtomicReference<CachedPackList> cachedPacks;
    private final FS fs;
    private final AtomicReference<FileObjectDatabase.AlternateHandle[]> alternates;
    private final UnpackedObjectCache unpackedObjectCache;

    public ObjectDirectory(Config cfg, File dir, File[] alternatePaths, FS fs) throws IOException {
        this.config = cfg;
        this.objects = dir;
        this.infoDirectory = new File(this.objects, "info");
        this.packDirectory = new File(this.objects, "pack");
        this.alternatesFile = new File(this.infoDirectory, "alternates");
        this.cachedPacksFile = new File(this.infoDirectory, "cached-packs");
        this.packList = new AtomicReference<PackList>(NO_PACKS);
        this.cachedPacks = new AtomicReference();
        this.unpackedObjectCache = new UnpackedObjectCache();
        this.fs = fs;
        this.alternates = new AtomicReference();
        if (alternatePaths != null) {
            FileObjectDatabase.AlternateHandle[] alt = new FileObjectDatabase.AlternateHandle[alternatePaths.length];
            for (int i = 0; i < alternatePaths.length; ++i) {
                alt[i] = this.openAlternate(alternatePaths[i]);
            }
            this.alternates.set(alt);
        }
    }

    @Override
    public final File getDirectory() {
        return this.objects;
    }

    @Override
    public boolean exists() {
        return this.objects.exists();
    }

    @Override
    public void create() throws IOException {
        FileUtils.mkdirs(this.objects);
        FileUtils.mkdir(this.infoDirectory);
        FileUtils.mkdir(this.packDirectory);
    }

    @Override
    public ObjectDirectoryInserter newInserter() {
        return new ObjectDirectoryInserter(this, this.config);
    }

    @Override
    public void close() {
        this.unpackedObjectCache.clear();
        PackList packs = this.packList.get();
        this.packList.set(NO_PACKS);
        for (PackFile p : packs.packs) {
            p.close();
        }
        FileObjectDatabase.AlternateHandle[] alt = this.alternates.get();
        if (alt != null) {
            this.alternates.set(null);
            for (FileObjectDatabase.AlternateHandle od : alt) {
                od.close();
            }
        }
    }

    @Override
    public File fileFor(AnyObjectId objectId) {
        return super.fileFor(objectId);
    }

    public Collection<PackFile> getPacks() {
        PackList list = this.packList.get();
        if (list == NO_PACKS) {
            list = this.scanPacks(list);
        }
        PackFile[] packs = list.packs;
        return Collections.unmodifiableCollection(Arrays.asList(packs));
    }

    @Override
    Collection<? extends CachedPack> getCachedPacks() throws IOException {
        CachedPackList list = this.cachedPacks.get();
        if (list == null || list.snapshot.isModified(this.cachedPacksFile)) {
            list = this.scanCachedPacks(list);
        }
        Collection<CachedPack> result = list.getCachedPacks();
        boolean resultIsCopy = false;
        for (FileObjectDatabase.AlternateHandle h : this.myAlternates()) {
            Collection<CachedPack> altPacks = h.getCachedPacks();
            if (altPacks.isEmpty()) continue;
            if (result.isEmpty()) {
                result = altPacks;
                continue;
            }
            if (!resultIsCopy) {
                result = new ArrayList<CachedPack>(result);
                resultIsCopy = true;
            }
            result.addAll(altPacks);
        }
        return result;
    }

    private CachedPackList scanCachedPacks(CachedPackList old) throws IOException {
        byte[] buf;
        FileSnapshot s = FileSnapshot.save(this.cachedPacksFile);
        try {
            buf = IO.readFully(this.cachedPacksFile);
        }
        catch (FileNotFoundException e) {
            buf = new byte[]{};
        }
        if (old != null && old.snapshot.equals(s) && Arrays.equals(old.raw, buf)) {
            old.snapshot.setClean(s);
            return old;
        }
        ArrayList<LocalCachedPack> list = new ArrayList<LocalCachedPack>(4);
        HashSet<ObjectId> tips = new HashSet<ObjectId>();
        int ptr = 0;
        while (ptr < buf.length) {
            if (buf[ptr] == 35 || buf[ptr] == 10) {
                ptr = RawParseUtils.nextLF(buf, ptr);
                continue;
            }
            if (buf[ptr] == 43) {
                tips.add(ObjectId.fromString(buf, ptr + 2));
                ptr = RawParseUtils.nextLF(buf, ptr + 2);
                continue;
            }
            ArrayList<String> names = new ArrayList<String>(4);
            while (ptr < buf.length && buf[ptr] == 80) {
                int end = RawParseUtils.nextLF(buf, ptr);
                if (buf[end - 1] == 10) {
                    --end;
                }
                names.add(RawParseUtils.decode(buf, ptr + 2, end));
                ptr = RawParseUtils.nextLF(buf, end);
            }
            if (tips.isEmpty() || names.isEmpty()) continue;
            list.add(new LocalCachedPack(this, tips, names));
            tips = new HashSet();
        }
        list.trimToSize();
        return new CachedPackList(s, Collections.unmodifiableList(list), buf);
    }

    @Override
    public PackFile openPack(File pack, File idx) throws IOException {
        String p = pack.getName();
        String i = idx.getName();
        if (p.length() != 50 || !p.startsWith("pack-") || !p.endsWith(".pack")) {
            throw new IOException(MessageFormat.format(JGitText.get().notAValidPack, pack));
        }
        if (i.length() != 49 || !i.startsWith("pack-") || !i.endsWith(".idx")) {
            throw new IOException(MessageFormat.format(JGitText.get().notAValidPack, idx));
        }
        if (!p.substring(0, 45).equals(i.substring(0, 45))) {
            throw new IOException(MessageFormat.format(JGitText.get().packDoesNotMatchIndex, pack));
        }
        PackFile res = new PackFile(idx, pack);
        this.insertPack(res);
        return res;
    }

    public String toString() {
        return "ObjectDirectory[" + this.getDirectory() + "]";
    }

    @Override
    boolean hasObject1(AnyObjectId objectId) {
        if (this.unpackedObjectCache.isUnpacked(objectId)) {
            return true;
        }
        for (PackFile p : this.packList.get().packs) {
            try {
                if (!p.hasObject(objectId)) continue;
                return true;
            }
            catch (IOException e) {
                this.removePack(p);
            }
        }
        return false;
    }

    @Override
    void resolve(Set<ObjectId> matches, AbbreviatedObjectId id) throws IOException {
        int oldSize = matches.size();
        PackList pList = this.packList.get();
        while (true) {
            PackList nList;
            for (PackFile p : pList.packs) {
                try {
                    p.resolve(matches, id, 256);
                }
                catch (IOException e) {
                    this.removePack(p);
                }
                if (matches.size() <= 256) continue;
                return;
            }
            if (matches.size() != oldSize || (nList = this.scanPacks(pList)) == pList || nList.packs.length == 0) break;
            pList = nList;
        }
        String fanOut = id.name().substring(0, 2);
        String[] entries = new File(this.getDirectory(), fanOut).list();
        if (entries != null) {
            for (String e : entries) {
                block9: {
                    if (e.length() != 38) continue;
                    try {
                        ObjectId entId = ObjectId.fromString(fanOut + e);
                        if (id.prefixCompare(entId) != 0) break block9;
                        matches.add(entId);
                    }
                    catch (IllegalArgumentException notId) {
                        continue;
                    }
                }
                if (matches.size() <= 256) continue;
                return;
            }
        }
        for (FileObjectDatabase.AlternateHandle alt : this.myAlternates()) {
            alt.db.resolve(matches, id);
            if (matches.size() <= 256) continue;
            return;
        }
    }

    @Override
    ObjectLoader openObject1(WindowCursor curs, AnyObjectId objectId) throws IOException {
        if (this.unpackedObjectCache.isUnpacked(objectId)) {
            ObjectLoader ldr = this.openObject2(curs, objectId.name(), objectId);
            if (ldr != null) {
                return ldr;
            }
            this.unpackedObjectCache.remove(objectId);
        }
        PackList pList = this.packList.get();
        while (true) {
            for (PackFile p : pList.packs) {
                try {
                    ObjectLoader ldr = p.get(curs, objectId);
                    if (ldr == null) continue;
                    return ldr;
                }
                catch (PackMismatchException e) {
                    pList = this.scanPacks(pList);
                }
                catch (IOException e) {
                    this.removePack(p);
                }
            }
            break;
        }
        return null;
    }

    @Override
    long getObjectSize1(WindowCursor curs, AnyObjectId objectId) throws IOException {
        PackList pList = this.packList.get();
        while (true) {
            for (PackFile p : pList.packs) {
                try {
                    long sz = p.getObjectSize(curs, objectId);
                    if (0L > sz) continue;
                    return sz;
                }
                catch (PackMismatchException e) {
                    pList = this.scanPacks(pList);
                }
                catch (IOException e) {
                    this.removePack(p);
                }
            }
            break;
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    long getObjectSize2(WindowCursor curs, String objectName, AnyObjectId objectId) throws IOException {
        long l;
        File path = this.fileFor(objectName);
        FileInputStream in = new FileInputStream(path);
        try {
            l = UnpackedObject.getSize(in, objectId, curs);
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (FileNotFoundException noFile) {
                return -1L;
            }
        }
        in.close();
        return l;
    }

    @Override
    void selectObjectRepresentation(PackWriter packer, ObjectToPack otp, WindowCursor curs) throws IOException {
        PackList pList = this.packList.get();
        while (true) {
            for (PackFile p : pList.packs) {
                try {
                    LocalObjectRepresentation rep = p.representation(curs, otp);
                    if (rep == null) continue;
                    packer.select(otp, rep);
                }
                catch (PackMismatchException e) {
                    pList = this.scanPacks(pList);
                }
                catch (IOException e) {
                    this.removePack(p);
                }
            }
            break;
        }
        for (FileObjectDatabase.AlternateHandle h : this.myAlternates()) {
            h.db.selectObjectRepresentation(packer, otp, curs);
        }
    }

    @Override
    boolean hasObject2(String objectName) {
        return this.fileFor(objectName).exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    ObjectLoader openObject2(WindowCursor curs, String objectName, AnyObjectId objectId) throws IOException {
        ObjectLoader objectLoader;
        File path = this.fileFor(objectName);
        FileInputStream in = new FileInputStream(path);
        try {
            this.unpackedObjectCache.add(objectId);
            objectLoader = UnpackedObject.open(in, path, objectId, curs);
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (FileNotFoundException noFile) {
                this.unpackedObjectCache.remove(objectId);
                return null;
            }
        }
        in.close();
        return objectLoader;
    }

    @Override
    FileObjectDatabase.InsertLooseObjectResult insertUnpackedObject(File tmp, ObjectId id, boolean createDuplicate) throws IOException {
        if (this.unpackedObjectCache.isUnpacked(id)) {
            FileUtils.delete(tmp);
            return FileObjectDatabase.InsertLooseObjectResult.EXISTS_LOOSE;
        }
        if (!createDuplicate && this.has(id)) {
            FileUtils.delete(tmp);
            return FileObjectDatabase.InsertLooseObjectResult.EXISTS_PACKED;
        }
        File dst = this.fileFor(id);
        if (dst.exists()) {
            FileUtils.delete(tmp);
            return FileObjectDatabase.InsertLooseObjectResult.EXISTS_LOOSE;
        }
        if (tmp.renameTo(dst)) {
            dst.setReadOnly();
            this.unpackedObjectCache.add(id);
            return FileObjectDatabase.InsertLooseObjectResult.INSERTED;
        }
        FileUtils.mkdir(dst.getParentFile());
        if (tmp.renameTo(dst)) {
            dst.setReadOnly();
            this.unpackedObjectCache.add(id);
            return FileObjectDatabase.InsertLooseObjectResult.INSERTED;
        }
        if (!createDuplicate && this.has(id)) {
            FileUtils.delete(tmp);
            return FileObjectDatabase.InsertLooseObjectResult.EXISTS_PACKED;
        }
        FileUtils.delete(tmp);
        return FileObjectDatabase.InsertLooseObjectResult.FAILURE;
    }

    @Override
    boolean tryAgain1() {
        PackList old = this.packList.get();
        if (old.snapshot.isModified(this.packDirectory)) {
            return old != this.scanPacks(old);
        }
        return false;
    }

    @Override
    Config getConfig() {
        return this.config;
    }

    @Override
    FS getFS() {
        return this.fs;
    }

    private void insertPack(PackFile pf) {
        PackFile[] newList;
        PackList n;
        PackList o;
        do {
            o = this.packList.get();
            PackFile[] oldList = o.packs;
            String name = pf.getPackFile().getName();
            for (PackFile p : oldList) {
                if (PackFile.SORT.compare(pf, p) < 0) break;
                if (!name.equals(p.getPackFile().getName())) continue;
                return;
            }
            newList = new PackFile[1 + oldList.length];
            newList[0] = pf;
            System.arraycopy(oldList, 0, newList, 1, oldList.length);
        } while (!this.packList.compareAndSet(o, n = new PackList(o.snapshot, newList)));
    }

    private void removePack(PackFile deadPack) {
        PackFile[] newList;
        PackList n;
        PackList o;
        do {
            o = this.packList.get();
            PackFile[] oldList = o.packs;
            int j = ObjectDirectory.indexOf(oldList, deadPack);
            if (j < 0) break;
            newList = new PackFile[oldList.length - 1];
            System.arraycopy(oldList, 0, newList, 0, j);
            System.arraycopy(oldList, j + 1, newList, j, newList.length - j);
        } while (!this.packList.compareAndSet(o, n = new PackList(o.snapshot, newList)));
        deadPack.close();
    }

    private static int indexOf(PackFile[] list, PackFile pack) {
        for (int i = 0; i < list.length; ++i) {
            if (list[i] != pack) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackList scanPacks(PackList original) {
        AtomicReference<PackList> atomicReference = this.packList;
        synchronized (atomicReference) {
            PackList n;
            PackList o;
            do {
                if ((o = this.packList.get()) != original) {
                    return o;
                }
                n = this.scanPacksImpl(o);
                if (n != o) continue;
                return n;
            } while (!this.packList.compareAndSet(o, n));
            return n;
        }
    }

    private PackList scanPacksImpl(PackList old) {
        Map<String, PackFile> forReuse = ObjectDirectory.reuseMap(old);
        FileSnapshot snapshot = FileSnapshot.save(this.packDirectory);
        Set<String> names = this.listPackDirectory();
        ArrayList<PackFile> list = new ArrayList<PackFile>(names.size() >> 2);
        boolean foundNew = false;
        for (String indexName : names) {
            String base;
            String packName;
            if (indexName.length() != 49 || !indexName.endsWith(".idx") || !names.contains(packName = (base = indexName.substring(0, indexName.length() - 4)) + ".pack")) continue;
            PackFile oldPack = forReuse.remove(packName);
            if (oldPack != null) {
                list.add(oldPack);
                continue;
            }
            File packFile = new File(this.packDirectory, packName);
            File idxFile = new File(this.packDirectory, indexName);
            list.add(new PackFile(idxFile, packFile));
            foundNew = true;
        }
        if (!foundNew && forReuse.isEmpty() && snapshot.equals(old.snapshot)) {
            old.snapshot.setClean(snapshot);
            return old;
        }
        for (PackFile p : forReuse.values()) {
            p.close();
        }
        if (list.isEmpty()) {
            return new PackList(snapshot, ObjectDirectory.NO_PACKS.packs);
        }
        PackFile[] r = list.toArray(new PackFile[list.size()]);
        Arrays.sort(r, PackFile.SORT);
        return new PackList(snapshot, r);
    }

    private static Map<String, PackFile> reuseMap(PackList old) {
        HashMap<String, PackFile> forReuse = new HashMap<String, PackFile>();
        for (PackFile p : old.packs) {
            if (p.invalid()) {
                p.close();
                continue;
            }
            PackFile prior = forReuse.put(p.getPackFile().getName(), p);
            if (prior == null) continue;
            forReuse.put(prior.getPackFile().getName(), prior);
            p.close();
        }
        return forReuse;
    }

    private Set<String> listPackDirectory() {
        String[] nameList = this.packDirectory.list();
        if (nameList == null) {
            return Collections.emptySet();
        }
        HashSet<String> nameSet = new HashSet<String>(nameList.length << 1);
        for (String name : nameList) {
            if (!name.startsWith("pack-")) continue;
            nameSet.add(name);
        }
        return nameSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    FileObjectDatabase.AlternateHandle[] myAlternates() {
        FileObjectDatabase.AlternateHandle[] alt = this.alternates.get();
        if (alt == null) {
            AtomicReference<FileObjectDatabase.AlternateHandle[]> atomicReference = this.alternates;
            synchronized (atomicReference) {
                alt = this.alternates.get();
                if (alt == null) {
                    try {
                        alt = this.loadAlternates();
                    }
                    catch (IOException e) {
                        alt = new FileObjectDatabase.AlternateHandle[]{};
                    }
                    this.alternates.set(alt);
                }
            }
        }
        return alt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileObjectDatabase.AlternateHandle[] loadAlternates() throws IOException {
        ArrayList<FileObjectDatabase.AlternateHandle> l = new ArrayList<FileObjectDatabase.AlternateHandle>(4);
        BufferedReader br = ObjectDirectory.open(this.alternatesFile);
        try {
            String line;
            while ((line = br.readLine()) != null) {
                l.add(this.openAlternate(line));
            }
        }
        finally {
            br.close();
        }
        return l.toArray(new FileObjectDatabase.AlternateHandle[l.size()]);
    }

    private static BufferedReader open(File f) throws FileNotFoundException {
        return new BufferedReader(new FileReader(f));
    }

    private FileObjectDatabase.AlternateHandle openAlternate(String location) throws IOException {
        File objdir = this.fs.resolve(this.objects, location);
        return this.openAlternate(objdir);
    }

    private FileObjectDatabase.AlternateHandle openAlternate(File objdir) throws IOException {
        File parent = objdir.getParentFile();
        if (RepositoryCache.FileKey.isGitRepository(parent, this.fs)) {
            RepositoryCache.FileKey key = RepositoryCache.FileKey.exact(parent, this.fs);
            FileRepository db = (FileRepository)RepositoryCache.open(key);
            return new FileObjectDatabase.AlternateRepository(db);
        }
        ObjectDirectory db = new ObjectDirectory(this.config, objdir, null, this.fs);
        return new FileObjectDatabase.AlternateHandle(db);
    }

    @Override
    public ObjectDatabase newCachedDatabase() {
        return this.newCachedFileObjectDatabase();
    }

    @Override
    FileObjectDatabase newCachedFileObjectDatabase() {
        return new CachedObjectDirectory(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CachedPackList {
        final FileSnapshot snapshot;
        final Collection<LocalCachedPack> packs;
        final byte[] raw;

        CachedPackList(FileSnapshot sn, List<LocalCachedPack> list, byte[] buf) {
            this.snapshot = sn;
            this.packs = list;
            this.raw = buf;
        }

        Collection<CachedPack> getCachedPacks() {
            Collection<CachedPack> p = this.packs;
            return p;
        }
    }

    private static final class PackList {
        final FileSnapshot snapshot;
        final PackFile[] packs;

        PackList(FileSnapshot monitor, PackFile[] packs) {
            this.snapshot = monitor;
            this.packs = packs;
        }
    }
}

