/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.command.convert;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.mvel2.ConversionException;
import org.mvel2.ConversionHandler;
import org.mvel2.conversion.Converter;

public class BooleanConverter
implements ConversionHandler {
    private static final Map<Class<?>, Converter> CNV = new HashMap();
    private static final Set<Object> TRUE = new HashSet<Object>();
    private static final Set<Object> FALSE = new HashSet<Object>();
    private static Converter stringConverter;

    public Object convertFrom(Object in) {
        if (!CNV.containsKey(in.getClass())) {
            throw new ConversionException("cannot convert type: " + in.getClass().getName() + " to: " + Boolean.class.getName());
        }
        return CNV.get(in.getClass()).convert(in);
    }

    public boolean canConvertFrom(Class cls) {
        return CNV.containsKey(cls);
    }

    static {
        TRUE.add("true");
        TRUE.add("yes");
        TRUE.add("y");
        TRUE.add("on");
        FALSE.add("false");
        FALSE.add("no");
        FALSE.add("n");
        FALSE.add("off");
        stringConverter = new Converter(){

            public Object convert(Object o) {
                String s = ((String)o).toLowerCase();
                if (TRUE.contains(s)) {
                    return true;
                }
                if (FALSE.contains(s)) {
                    return false;
                }
                throw new IllegalArgumentException("not a valid boolean: '" + s + "'");
            }
        };
        CNV.put(String.class, stringConverter);
        CNV.put(Object.class, new Converter(){

            public Object convert(Object o) {
                return stringConverter.convert((Object)String.valueOf(o));
            }
        });
        CNV.put(Boolean.class, new Converter(){

            public Object convert(Object o) {
                return o;
            }
        });
        CNV.put(Integer.class, new Converter(){

            public Boolean convert(Object o) {
                return (Integer)o > 0;
            }
        });
        CNV.put(Float.class, new Converter(){

            public Boolean convert(Object o) {
                return ((Float)o).floatValue() > 0.0f;
            }
        });
        CNV.put(Double.class, new Converter(){

            public Boolean convert(Object o) {
                return (Double)o > 0.0;
            }
        });
        CNV.put(Short.class, new Converter(){

            public Boolean convert(Object o) {
                return (Short)o > 0;
            }
        });
        CNV.put(Long.class, new Converter(){

            public Boolean convert(Object o) {
                return (Long)o > 0L;
            }
        });
        CNV.put(Boolean.TYPE, new Converter(){

            public Boolean convert(Object o) {
                return (boolean)((Boolean)o);
            }
        });
        CNV.put(BigDecimal.class, new Converter(){

            public Boolean convert(Object o) {
                return ((BigDecimal)o).doubleValue() > 0.0;
            }
        });
    }
}

