/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.plugins.builtin;

import java.util.Iterator;
import javax.inject.Inject;
import org.jboss.forge.env.Configuration;
import org.jboss.forge.env.ConfigurationScope;
import org.jboss.forge.shell.ShellColor;
import org.jboss.forge.shell.ShellPrintWriter;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.DefaultCommand;
import org.jboss.forge.shell.plugins.Help;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.Topic;

@Alias(value="list-config")
@Topic(value="Shell Environment")
@Help(value="Lists all Forge configuration for the current user and project (if working on a project.)")
public class ListConfigPlugin
implements Plugin {
    private final ShellPrintWriter writer;
    private final Configuration config;

    @Inject
    public ListConfigPlugin(Configuration forge, ShellPrintWriter writer) {
        this.config = forge;
        this.writer = writer;
    }

    @DefaultCommand
    public void listProperties() {
        Iterator properties = this.config.getKeys();
        while (properties.hasNext()) {
            Object key = properties.next();
            if (key == null) continue;
            this.writer.print(ShellColor.BOLD, key.toString());
            this.writer.print("=");
            for (ConfigurationScope scope : ConfigurationScope.values()) {
                Configuration scoped = this.config.getScopedConfiguration(scope);
                if (scoped == null) continue;
                Object value = scoped.getProperty(key.toString());
                this.writer.print(ShellColor.YELLOW, scope.name() + ": ");
                if (value != null) {
                    this.writer.print("[" + value.toString() + "] ");
                    continue;
                }
                this.writer.print("[] ");
            }
            this.writer.println();
        }
    }
}

