/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.plugins.builtin;

import java.util.Map;
import javax.inject.Inject;
import org.jboss.forge.ForgeEnvironment;
import org.jboss.forge.shell.ShellPrintWriter;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.DefaultCommand;
import org.jboss.forge.shell.plugins.Help;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.Topic;

@Alias(value="list-properties")
@Topic(value="Shell Environment")
@Help(value="Lists all current forge properties")
public class ListPropertiesPlugin
implements Plugin {
    final ForgeEnvironment forge;
    private final ShellPrintWriter writer;

    @Inject
    public ListPropertiesPlugin(ForgeEnvironment forge, ShellPrintWriter writer) {
        this.forge = forge;
        this.writer = writer;
    }

    @DefaultCommand
    public void listProperties() {
        Map properties = this.forge.getProperties();
        for (Map.Entry entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            this.writer.print(key + "=");
            if (value != null) {
                this.writer.print(value.toString());
            }
            this.writer.println();
        }
    }
}

