/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.maven.facets;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.Dependent;
import org.jboss.forge.maven.MavenCoreFacet;
import org.jboss.forge.maven.MavenPluginFacet;
import org.jboss.forge.maven.plugins.ConfigurationElement;
import org.jboss.forge.maven.plugins.ConfigurationElementBuilder;
import org.jboss.forge.maven.plugins.MavenPlugin;
import org.jboss.forge.maven.plugins.MavenPluginBuilder;
import org.jboss.forge.project.Facet;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.dependencies.Dependency;
import org.jboss.forge.project.dependencies.DependencyBuilder;
import org.jboss.forge.project.facets.BaseFacet;
import org.jboss.forge.project.facets.JavaSourceFacet;
import org.jboss.forge.project.facets.PackagingFacet;
import org.jboss.forge.project.facets.WebResourceFacet;
import org.jboss.forge.project.packaging.PackagingType;
import org.jboss.forge.resources.DirectoryResource;
import org.jboss.forge.resources.FileResource;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.RequiresFacet;
import org.jboss.forge.shell.plugins.RequiresPackagingType;

@Dependent
@Alias(value="forge.maven.WebResourceFacet")
@RequiresPackagingType(value={PackagingType.WAR})
@RequiresFacet(value={JavaSourceFacet.class, PackagingFacet.class, MavenPluginFacet.class})
public class MavenWebResourceFacet
extends BaseFacet
implements WebResourceFacet,
Facet {
    private Project project;

    public DirectoryResource getWebRootDirectory() {
        return this.project.getProjectRoot().getChildDirectory("src" + File.separator + "main" + File.separator + "webapp");
    }

    public List<DirectoryResource> getWebRootDirectories() {
        ArrayList<DirectoryResource> result = new ArrayList<DirectoryResource>();
        result.add(this.getWebRootDirectory());
        return result;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public Project getProject() {
        return this.project;
    }

    public boolean isInstalled() {
        MavenCoreFacet mavenFacet = (MavenCoreFacet)this.project.getFacet(MavenCoreFacet.class);
        PackagingType packagingType = ((PackagingFacet)this.project.getFacet(PackagingFacet.class)).getPackagingType();
        return mavenFacet.isInstalled() && packagingType.equals((Object)PackagingType.WAR);
    }

    public boolean install() {
        if (!this.isInstalled()) {
            MavenPluginBuilder plugin;
            DependencyBuilder mvnWarPluginDep;
            for (DirectoryResource folder : this.getWebRootDirectories()) {
                folder.mkdirs();
            }
            MavenPluginFacet plugins = (MavenPluginFacet)this.project.getFacet(MavenPluginFacet.class);
            if (!plugins.hasPlugin((Dependency)(mvnWarPluginDep = DependencyBuilder.create((String)"org.apache.maven.plugins:maven-war-plugin").setVersion("2.1.1")))) {
                plugin = MavenPluginBuilder.create().setDependency((Dependency)mvnWarPluginDep);
                plugins.addPlugin((MavenPlugin)plugin);
            } else {
                plugin = plugins.getPlugin((Dependency)mvnWarPluginDep);
            }
            if (plugin.getConfig() == null) {
                // empty if block
            }
            if (!plugin.getConfig().hasConfigurationElement("failOnMissingWebXml")) {
                plugin.getConfig().addConfigurationElement((ConfigurationElement)ConfigurationElementBuilder.create().setName("failOnMissingWebXml").setText("false"));
            } else {
                ConfigurationElementBuilder configElement = ConfigurationElementBuilder.createFromExisting((ConfigurationElement)plugin.getConfig().getConfigurationElement("failOnMissingWebXml"));
                plugin.getConfig().removeConfigurationElement("failOnMissingWebXml");
                plugin.getConfig().addConfigurationElement((ConfigurationElement)configElement);
            }
            plugins.removePlugin((Dependency)mvnWarPluginDep);
            plugins.addPlugin((MavenPlugin)plugin);
        }
        return true;
    }

    public FileResource<?> getWebResource(String relativePath) {
        return (FileResource)this.getWebRootDirectory().getChild(relativePath);
    }

    public FileResource<?> createWebResource(char[] data, String relativePath) {
        FileResource file = (FileResource)this.getWebRootDirectory().getChild(relativePath);
        file.setContents(data);
        return file;
    }

    public FileResource<?> createWebResource(String data, String relativePath) {
        return this.createWebResource(data.toCharArray(), relativePath);
    }
}

