/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.treewalk.filter;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.errors.StopWalkException;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathFilterGroup {
    public static TreeFilter createFromStrings(Collection<String> paths) {
        if (paths.isEmpty()) {
            throw new IllegalArgumentException(JGitText.get().atLeastOnePathIsRequired);
        }
        PathFilter[] p = new PathFilter[paths.size()];
        int i = 0;
        for (String s : paths) {
            p[i++] = PathFilter.create(s);
        }
        return PathFilterGroup.create(p);
    }

    public static TreeFilter createFromStrings(String ... paths) {
        if (paths.length == 0) {
            throw new IllegalArgumentException(JGitText.get().atLeastOnePathIsRequired);
        }
        int length = paths.length;
        PathFilter[] p = new PathFilter[length];
        for (int i = 0; i < length; ++i) {
            p[i] = PathFilter.create(paths[i]);
        }
        return PathFilterGroup.create(p);
    }

    public static TreeFilter create(Collection<PathFilter> paths) {
        if (paths.isEmpty()) {
            throw new IllegalArgumentException(JGitText.get().atLeastOnePathIsRequired);
        }
        PathFilter[] p = new PathFilter[paths.size()];
        paths.toArray(p);
        return PathFilterGroup.create(p);
    }

    private static TreeFilter create(PathFilter[] p) {
        if (p.length == 1) {
            return new Single(p[0]);
        }
        return new Group(p);
    }

    static class Group
    extends TreeFilter {
        private static final Comparator<PathFilter> PATH_SORT = new Comparator<PathFilter>(){

            @Override
            public int compare(PathFilter o1, PathFilter o2) {
                return o1.pathStr.compareTo(o2.pathStr);
            }
        };
        private final PathFilter[] paths;

        private Group(PathFilter[] p) {
            this.paths = p;
            Arrays.sort(this.paths, PATH_SORT);
        }

        public boolean include(TreeWalk walker) {
            int cmp;
            int n = this.paths.length;
            int i = 0;
            do {
                byte[] r;
                if ((cmp = walker.isPathPrefix(r = this.paths[i].pathRaw, r.length)) != 0) continue;
                return true;
            } while (++i < n);
            if (cmp > 0) {
                throw StopWalkException.INSTANCE;
            }
            return false;
        }

        public boolean shouldBeRecursive() {
            for (PathFilter p : this.paths) {
                if (!p.shouldBeRecursive()) continue;
                return true;
            }
            return false;
        }

        public TreeFilter clone() {
            return this;
        }

        public String toString() {
            StringBuilder r = new StringBuilder();
            r.append("FAST(");
            for (int i = 0; i < this.paths.length; ++i) {
                if (i > 0) {
                    r.append(" OR ");
                }
                r.append(this.paths[i].toString());
            }
            r.append(")");
            return r.toString();
        }
    }

    static class Single
    extends TreeFilter {
        private final PathFilter path;
        private final byte[] raw;

        private Single(PathFilter p) {
            this.path = p;
            this.raw = this.path.pathRaw;
        }

        public boolean include(TreeWalk walker) {
            int cmp = walker.isPathPrefix(this.raw, this.raw.length);
            if (cmp > 0) {
                throw StopWalkException.INSTANCE;
            }
            return cmp == 0;
        }

        public boolean shouldBeRecursive() {
            return this.path.shouldBeRecursive();
        }

        public TreeFilter clone() {
            return this;
        }

        public String toString() {
            return "FAST_" + this.path.toString();
        }
    }
}

