/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.texteditors.propertyeditor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.text.javadoc.JavadocContentAccess2;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.loaders.impl.PropertiesLoader;
import org.jboss.tools.common.model.ui.attribute.adapter.JavaClassContentAssistProvider;
import org.jboss.tools.common.model.util.EclipseJavaUtil;
import org.jboss.tools.common.model.util.EclipseResourceUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractPropertiesContentAssistProcessor
implements IContentAssistProcessor {
    protected XModelObject object;

    public void setModelObject(XModelObject object) {
        this.object = object;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        return null;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public Context getContext(ITextViewer viewer, int offset) {
        int b;
        String name;
        int lineOffset;
        Context context = new Context();
        context.offset = offset;
        context.text = viewer.getDocument().get();
        XModelObject[] ps = this.object.getChildren();
        int i = 0;
        while (i < ps.length) {
            String name2 = ps[i].getAttributeValue("name");
            context.allProperties.add(name2);
            ++i;
        }
        context.nameOffset = lineOffset = this.getNameOffset(viewer, offset);
        int valueEnd = this.getValueEnd(viewer, offset);
        String line = viewer.getDocument().get().substring(context.nameOffset, valueEnd);
        if (line.trim().startsWith("#")) {
            context.inComment = true;
            return context;
        }
        int si = PropertiesLoader.getSeparatorIndex((String)line);
        if (si < 0) {
            si = line.length();
        }
        if (si == line.length()) {
            context.inPropertyName = true;
        }
        context.propertyName = name = line.substring(0, si).trim();
        context.nameLength = name.length();
        if (name.length() > 0 && (b = line.indexOf(name)) >= 0) {
            context.nameOffset += b;
        }
        if (offset >= context.nameOffset && offset <= context.nameOffset + context.nameLength) {
            context.inPropertyName = true;
        }
        String value = si >= line.length() ? "" : line.substring(si + 1, line.length());
        context.valueLength = value.length();
        context.propertyValue = value;
        if (si < line.length()) {
            context.valueOffset = lineOffset + si + 1;
            int b2 = line.indexOf(value, si + 1);
            if (b2 > 0) {
                context.valueOffset = lineOffset + b2;
            }
        }
        return context;
    }

    int getNameOffset(ITextViewer viewer, int offset) {
        String body = viewer.getDocument().get();
        int i = offset - 1;
        while (i >= 0) {
            char c = body.charAt(i);
            if (c == '\n' || c == '\r') {
                return i + 1;
            }
            --i;
        }
        return 0;
    }

    int getValueEnd(ITextViewer viewer, int offset) {
        String body = viewer.getDocument().get();
        int i = offset;
        while (i < body.length()) {
            char c = body.charAt(i);
            if (c == '\n' || c == '\r') {
                return i;
            }
            ++i;
        }
        return body.length();
    }

    protected ICompletionProposal getNameProposal(String name, String description, Context context) {
        int nameOffset = context.getNameOffset();
        String namePrefix = context.getNamePrefix();
        if (context.hasProperty(name)) {
            return null;
        }
        if (!name.startsWith(namePrefix)) {
            return null;
        }
        CompletionProposal proposal = new CompletionProposal(name, nameOffset, context.getNameLength(), name.length(), null, name, null, description);
        return proposal;
    }

    protected ICompletionProposal getValueProposal(String value, String description, Context context) {
        int valueOffset = context.getValueOffset();
        String valuePrefix = context.getValuePrefix();
        if (value.length() == 0) {
            return null;
        }
        if (!value.startsWith(valuePrefix)) {
            return null;
        }
        CompletionProposal proposal = new CompletionProposal(value, valueOffset, context.getValueLength(), value.length(), null, value, null, description);
        return proposal;
    }

    protected List<ICompletionProposal> getJavaTypeContentProposals(Context context) {
        return this.getJavaTypeContentProposals(null, context);
    }

    protected List<ICompletionProposal> getJavaTypeContentProposals(XAttribute attr, Context context) {
        String valuePrefix = context.getValuePrefix();
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        JavaClassContentAssistProvider p = new JavaClassContentAssistProvider();
        p.init(this.object, null, attr);
        IContentProposalProvider pp = p.getContentProposalProvider();
        IContentProposal[] ps = pp.getProposals(valuePrefix, valuePrefix.length());
        IProject project = EclipseResourceUtil.getProject((XModelObject)this.object);
        IJavaProject jp = EclipseResourceUtil.getJavaProject((IProject)project);
        if (ps != null) {
            int i = 0;
            while (i < ps.length) {
                String value = ps[i].getContent();
                String descr = AbstractPropertiesContentAssistProcessor.getDescription(jp, value);
                CompletionProposal proposal = new CompletionProposal(value, context.getValueOffset(), context.getValueLength(), value.length(), null, ps[i].getLabel(), null, descr != null ? descr : ps[i].getDescription());
                result.add((ICompletionProposal)proposal);
                ++i;
            }
        }
        return result;
    }

    public static String getDescription(IJavaProject jp, String typeName) {
        String descr = null;
        if (jp != null) {
            try {
                IType type = EclipseJavaUtil.findType((IJavaProject)jp, (String)typeName);
                if (type != null) {
                    descr = JavadocContentAccess2.getHTMLContent((IMember)type, (boolean)true);
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return descr;
    }

    protected class Context {
        boolean inComment = false;
        int offset;
        int nameOffset;
        int nameLength;
        boolean inPropertyName = false;
        String propertyName;
        int valueOffset;
        int valueLength;
        String propertyValue;
        Set<String> allProperties = new HashSet<String>();
        String text;

        protected Context() {
        }

        public boolean isInComment() {
            return this.inComment;
        }

        public boolean isInPropertyName() {
            return this.inPropertyName;
        }

        public int getNameOffset() {
            return this.nameOffset;
        }

        public int getNameLength() {
            return this.nameLength;
        }

        public String getNamePrefix() {
            return this.nameOffset < this.offset ? this.text.substring(this.nameOffset, this.offset) : "";
        }

        public int getValueOffset() {
            return this.valueOffset;
        }

        public String getValuePrefix() {
            return this.valueOffset < this.offset && this.valueOffset >= 0 ? this.text.substring(this.valueOffset, this.offset) : "";
        }

        public int getValueLength() {
            return this.valueLength;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public boolean hasProperty(String property) {
            return this.allProperties.contains(property) && !property.equals(this.propertyName);
        }

        public boolean isInValue() {
            return !this.isInPropertyName() && this.offset >= this.valueOffset;
        }
    }
}

