/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor;

import org.eclipse.compare.Splitter;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IStatusField;
import org.eclipse.ui.texteditor.ITextEditorExtension;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.event.XModelTreeEvent;
import org.jboss.tools.common.model.event.XModelTreeListener;
import org.jboss.tools.common.model.ui.editor.IModelObjectEditorInput;
import org.jboss.tools.common.model.ui.util.ModelUtilities;
import org.jboss.tools.jst.jsp.JspEditorPlugin;
import org.jboss.tools.jst.jsp.bundle.BundleMap;
import org.jboss.tools.jst.jsp.editor.IVisualEditor;
import org.jboss.tools.jst.jsp.jspeditor.JSPMultiPageEditor;
import org.jboss.tools.jst.jsp.jspeditor.StorageRevisionEditorInputAdapter;
import org.jboss.tools.jst.jsp.preferences.VpePreference;
import org.jboss.tools.jst.jsp.selection.bar.SelectionBar;
import org.jboss.tools.vpe.VpePlugin;
import org.jboss.tools.vpe.editor.VpeController;
import org.jboss.tools.vpe.editor.mozilla.MozillaEditor;
import org.jboss.tools.vpe.editor.mozilla.MozillaPreview;
import org.jboss.tools.vpe.editor.mozilla.listener.EditorLoadWindowListener;
import org.jboss.tools.vpe.editor.util.VpeStyleUtil;
import org.jboss.tools.vpe.editor.xpl.CustomSashForm;
import org.jboss.tools.vpe.editor.xpl.EditorSettings;
import org.jboss.tools.vpe.editor.xpl.SashSetting;
import org.jboss.tools.vpe.xulrunner.browser.XulRunnerBrowser;

public class VpeEditorPart
extends EditorPart
implements ITextEditorExtension,
IReusableEditor,
IVisualEditor {
    private IContextActivation fContextActivation;
    private IHandlerActivation sourceActivation;
    private IHandlerActivation visualActivation;
    private IHandlerActivation jumpingActivation;
    private IHandler sourceMaxmin;
    private IHandler visualMaxmin;
    private IHandler jumping;
    private Composite cmpEd;
    private Composite cmpEdTl;
    private CustomSashForm container;
    protected EditorSettings editorSettings;
    private StructuredTextEditor sourceEditor;
    private MozillaEditor visualEditor;
    private BundleMap bundleMap;
    private IEditorPart activeEditor;
    private ControlListener controlListener;
    private XModelTreeListener listener;
    private XModelObject optionsObject;
    private SelectionBar selectionBar;
    private ActivationListener activationListener = new ActivationListener();
    private int visualMode;
    private EditorPart multiPageEditor;
    private int controlCount = 0;
    private MozillaPreview previewWebBrowser = null;
    private Composite sourceContent = null;
    private Composite visualContent = null;
    private Composite previewContent = null;
    private Splitter verticalToolbarSplitter = null;
    private Composite verticalToolbarEmpty = null;
    private ToolBar toolBar = null;

    public StructuredTextEditor getSourceEditor() {
        return this.sourceEditor;
    }

    public EditorPart getParentEditor() {
        return this.multiPageEditor;
    }

    public void addRulerContextMenuListener(IMenuListener listener) {
        if (this.sourceEditor != null) {
            this.sourceEditor.addRulerContextMenuListener(listener);
        }
    }

    public boolean isEditorInputReadOnly() {
        if (this.sourceEditor != null) {
            return this.sourceEditor.isEditorInputReadOnly();
        }
        return false;
    }

    public void removeRulerContextMenuListener(IMenuListener listener) {
        if (this.sourceEditor != null) {
            this.sourceEditor.removeRulerContextMenuListener(listener);
        }
    }

    public void setStatusField(IStatusField field, String category) {
        this.sourceEditor.setStatusField(field, category);
    }

    public VpeEditorPart(EditorPart multiPageEditor, StructuredTextEditor textEditor, int visualMode, BundleMap bundleMap) {
        this.sourceEditor = textEditor;
        this.visualMode = visualMode;
        this.bundleMap = bundleMap;
        this.multiPageEditor = multiPageEditor;
    }

    public VpeEditorPart() {
        this(null, null, 0, null);
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.sourceEditor != null) {
            this.sourceEditor.doSave(monitor);
        }
    }

    public void doSaveAs() {
        if (this.sourceEditor != null) {
            this.sourceEditor.doSaveAs();
            this.setInput(this.sourceEditor.getEditorInput());
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        if (this.editorSettings == null) {
            this.editorSettings = EditorSettings.getEditorSetting((IEditorPart)this);
        } else if (input instanceof FileEditorInput) {
            this.editorSettings.setInput((FileEditorInput)input);
        }
    }

    public void setInput(IEditorInput input) {
        super.setInput(input);
        if (this.visualEditor != null && this.visualEditor.getEditorInput() != null && this.visualEditor.getEditorInput() != this.getEditorInput()) {
            this.visualEditor.setInput(input);
        }
    }

    public boolean isDirty() {
        if (this.sourceEditor != null) {
            return this.sourceEditor.isDirty();
        }
        return false;
    }

    public boolean isSaveAsAllowed() {
        if (this.sourceEditor != null) {
            return this.sourceEditor.isSaveAsAllowed();
        }
        return false;
    }

    public void setVisualMode(int type) {
        switch (type) {
            case 0: {
                this.setVerticalToolbarVisible(JspEditorPlugin.getDefault().getPreferenceStore().getBoolean("Show VPE Toolbar"));
                this.container.setMaximizedControl(null);
                if (this.sourceContent != null) {
                    this.sourceContent.setVisible(true);
                    if (this.sourceEditor != null) {
                        this.activeEditor = this.sourceEditor;
                    }
                }
                if (this.visualContent != null) {
                    this.visualContent.setVisible(true);
                }
                if (this.previewContent == null) break;
                this.previewContent.setVisible(false);
                break;
            }
            case 1: {
                this.setVerticalToolbarVisible(false);
                if (this.sourceContent == null) break;
                this.sourceContent.setVisible(true);
                if (this.sourceEditor != null) {
                    this.activeEditor = this.sourceEditor;
                }
                this.container.setMaximizedControl((Control)this.sourceContent);
                break;
            }
            case 2: {
                this.setVerticalToolbarVisible(false);
                if (this.previewContent == null) break;
                this.previewWebBrowser.rebuildDom();
                this.previewContent.setVisible(true);
                if (this.previewWebBrowser != null) {
                    this.activeEditor = this.previewWebBrowser;
                }
                this.container.setMaximizedControl((Control)this.previewContent);
            }
        }
        if (this.visualEditor != null && this.visualEditor.getController() != null) {
            this.visualEditor.getController().refreshCommands();
        }
        this.container.layout();
        if (this.visualMode == 1 && type != 1) {
            this.visualMode = type;
            if (this.visualEditor != null && this.visualEditor.getController() != null) {
                this.visualEditor.getController().visualRefresh();
                if (type != 2) {
                    this.visualEditor.getController().sourceSelectionChanged();
                }
            }
        }
        this.visualMode = type;
    }

    public int getVisualMode() {
        return this.visualMode;
    }

    public void setVerticalToolbarVisible(boolean visible) {
        if (this.verticalToolbarSplitter == null || this.verticalToolbarEmpty == null || this.toolBar == null) {
            return;
        }
        if (visible) {
            this.verticalToolbarSplitter.setVisible((Control)this.toolBar, true);
            this.verticalToolbarSplitter.setVisible((Control)this.verticalToolbarEmpty, false);
        } else {
            this.verticalToolbarSplitter.setVisible((Control)this.toolBar, false);
            this.verticalToolbarSplitter.setVisible((Control)this.verticalToolbarEmpty, true);
        }
        this.verticalToolbarSplitter.getParent().layout(true, true);
    }

    public void createPartControl(final Composite parent) {
        ++this.controlCount;
        if (this.controlCount > 1) {
            return;
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.jboss.tools.vpe.visual_page_editor");
        this.cmpEdTl = parent;
        GridLayout layoutEdTl = new GridLayout(2, false);
        layoutEdTl.verticalSpacing = 0;
        layoutEdTl.marginHeight = 0;
        layoutEdTl.marginBottom = 3;
        layoutEdTl.marginWidth = 0;
        this.cmpEdTl.setLayout((Layout)layoutEdTl);
        this.cmpEdTl.setLayoutData((Object)new GridData(1808));
        this.verticalToolbarSplitter = new Splitter(this.cmpEdTl, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 2;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        this.verticalToolbarSplitter.setLayout((Layout)layout);
        this.verticalToolbarSplitter.setLayoutData((Object)new GridData(0x1000000, 132, false, true, 1, 2));
        this.verticalToolbarEmpty = new Composite((Composite)this.verticalToolbarSplitter, 0){

            public Point computeSize(int wHint, int hHint, boolean changed) {
                Point point = super.computeSize(wHint, hHint, changed);
                point.x = 1;
                return point;
            }
        };
        this.verticalToolbarEmpty.setLayoutData((Object)new GridData(1040));
        this.verticalToolbarEmpty.setVisible(true);
        this.cmpEd = new Composite(this.cmpEdTl, 2048);
        GridLayout layoutEd = new GridLayout(1, false);
        layoutEd.marginBottom = 0;
        layoutEd.marginHeight = 1;
        layoutEd.marginWidth = 0;
        layoutEd.marginRight = 0;
        layoutEd.marginLeft = 1;
        layoutEd.verticalSpacing = 0;
        layoutEd.horizontalSpacing = 0;
        this.cmpEd.setLayout((Layout)layoutEd);
        this.cmpEd.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.container = new CustomSashForm(this.cmpEd, CustomSashForm.getSplittingDirection(JspEditorPlugin.getDefault().getPreferenceStore().getString("Visual/Source Editors Splitting")));
        if (this.editorSettings != null) {
            this.editorSettings.addSetting(new SashSetting(this.container));
        }
        this.container.setLayoutData(new GridData(4, 4, true, true));
        if (CustomSashForm.isSourceEditorFirst(JspEditorPlugin.getDefault().getPreferenceStore().getString("Visual/Source Editors Splitting"))) {
            this.sourceContent = new Composite((Composite)this.container, 0);
            this.visualContent = new Composite((Composite)this.container, 0);
        } else {
            this.visualContent = new Composite((Composite)this.container, 0);
            this.sourceContent = new Composite((Composite)this.container, 0);
        }
        this.sourceContent.setLayout((Layout)new FillLayout());
        this.visualContent.setLayout((Layout)new FillLayout());
        this.previewContent = new Composite((Composite)this.container, 0);
        this.previewContent.setLayout((Layout)new GridLayout());
        if (this.sourceEditor == null) {
            this.sourceEditor = new StructuredTextEditor(){

                public void safelySanityCheckState(IEditorInput input) {
                    super.safelySanityCheckState(input);
                }
            };
        }
        this.container.setSashBorders(new boolean[]{true, true, true});
        this.controlListener = new ControlListener(){

            public void controlMoved(ControlEvent event) {
            }

            public void controlResized(ControlEvent event) {
                VpeEditorPart.this.container.layout();
            }
        };
        parent.addControlListener(this.controlListener);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                parent.removeControlListener(VpeEditorPart.this.controlListener);
                parent.removeDisposeListener((DisposeListener)this);
                VpeEditorPart.this.controlListener = null;
            }
        });
        final ControlListener visualContentControlListener = new ControlListener(){

            public void controlMoved(ControlEvent event) {
            }

            public void controlResized(ControlEvent event) {
                VpeEditorPart.this.updateVisualEditorVisibility();
            }
        };
        this.visualContent.addControlListener(visualContentControlListener);
        this.visualContent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                VpeEditorPart.this.visualContent.removeControlListener(visualContentControlListener);
                VpeEditorPart.this.visualContent.removeDisposeListener((DisposeListener)this);
            }
        });
        try {
            this.sourceEditor.addPropertyListener(new IPropertyListener(){

                public void propertyChanged(Object source, int propId) {
                    if (propId == 1) {
                        VpeEditorPart.this.setPartName(VpeEditorPart.this.sourceEditor.getTitle());
                    }
                    VpeEditorPart.this.firePropertyChange(propId);
                }
            });
            IEditorInput input = this.getEditorInput();
            if (!(input instanceof IModelObjectEditorInput) && input instanceof IStorageEditorInput) {
                input = new StorageRevisionEditorInputAdapter((IStorageEditorInput)input);
            }
            this.sourceEditor.init(this.getEditorSite(), input);
            if (this.sourceContent != null) {
                this.sourceEditor.createPartControl(this.sourceContent);
                this.sourceContent.addListener(26, new Listener(){

                    public void handleEvent(Event event) {
                        if (event.type == 26 && VpeEditorPart.this.activeEditor != VpeEditorPart.this.sourceEditor) {
                            VpeEditorPart.this.activeEditor = (IEditorPart)VpeEditorPart.this.sourceEditor;
                            VpeEditorPart.this.setFocus();
                        }
                    }
                });
            }
            this.activeEditor = this.sourceEditor;
            this.visualContent.addListener(26, new Listener(){

                public void handleEvent(Event event) {
                    if (event.type == 26 && VpeEditorPart.this.visualEditor != null && VpeEditorPart.this.activeEditor != VpeEditorPart.this.visualEditor) {
                        VpeEditorPart.this.activeEditor = (IEditorPart)VpeEditorPart.this.visualEditor;
                        VpeEditorPart.this.setFocus();
                    }
                }
            });
            this.previewContent.addListener(26, new Listener(){

                public void handleEvent(Event event) {
                    if (event.type == 26 && VpeEditorPart.this.previewWebBrowser != null && VpeEditorPart.this.activeEditor != VpeEditorPart.this.previewWebBrowser) {
                        VpeEditorPart.this.activeEditor = (IEditorPart)VpeEditorPart.this.previewWebBrowser;
                        VpeEditorPart.this.setFocus();
                    }
                }
            });
            IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
            window.getPartService().addPartListener((IPartListener)this.activationListener);
            window.getShell().addShellListener((ShellListener)this.activationListener);
        }
        catch (CoreException e) {
            VpePlugin.reportProblem((Exception)((Object)e));
        }
        this.optionsObject = ModelUtilities.getPreferenceModel().getByPath(VpePreference.EDITOR_PATH);
        this.listener = new XModelTreeListener(){

            public void nodeChanged(XModelTreeEvent event) {
            }

            public void structureChanged(XModelTreeEvent event) {
            }
        };
        this.optionsObject.getModel().addModelTreeListener(this.listener);
        if (this.editorSettings != null) {
            this.editorSettings.apply();
        }
        this.cmpEd.layout();
        this.sourceMaxmin = new AbstractHandler(){

            public Object execute(ExecutionEvent event) throws ExecutionException {
                if (VpeEditorPart.this.getVisualMode() == 0) {
                    Point p = VpeEditorPart.this.visualContent.getSize();
                    if (p.x == 0 || p.y == 0) {
                        VpeEditorPart.this.container.upClicked();
                    } else {
                        VpeEditorPart.this.container.maxDown();
                    }
                }
                return null;
            }
        };
        this.visualMaxmin = new AbstractHandler(){

            public Object execute(ExecutionEvent event) throws ExecutionException {
                if (VpeEditorPart.this.getVisualMode() == 0) {
                    Point p = VpeEditorPart.this.sourceContent.getSize();
                    if (p.x == 0 || p.y == 0) {
                        VpeEditorPart.this.container.downClicked();
                    } else {
                        VpeEditorPart.this.container.maxUp();
                    }
                }
                return null;
            }
        };
        this.jumping = new AbstractHandler(){

            public Object execute(ExecutionEvent event) throws ExecutionException {
                if (VpeEditorPart.this.getVisualMode() == 0) {
                    StructuredTextEditor editor = VpeEditorPart.this.getSourceEditor();
                    if (editor == null) {
                        return null;
                    }
                    StructuredTextViewer viewer = editor.getTextViewer();
                    if (viewer == null) {
                        return null;
                    }
                    StyledText widget = viewer.getTextWidget();
                    if (widget == null || widget.isDisposed()) {
                        return null;
                    }
                    if (widget.isFocusControl()) {
                        if (VpeEditorPart.this.visualEditor != null && VpeEditorPart.this.activeEditor != VpeEditorPart.this.visualEditor) {
                            VpeEditorPart.this.activeEditor = (IEditorPart)VpeEditorPart.this.visualEditor;
                            VpeEditorPart.this.setFocus();
                        }
                    } else if (VpeEditorPart.this.activeEditor != VpeEditorPart.this.sourceEditor) {
                        VpeEditorPart.this.activeEditor = (IEditorPart)VpeEditorPart.this.sourceEditor;
                        VpeEditorPart.this.setFocus();
                    }
                }
                return null;
            }
        };
        this.container.addCustomSashFormListener(new CustomSashForm.ICustomSashFormListener(){

            @Override
            public void dividerMoved(int firstControlWeight, int secondControlWeight) {
                JspEditorPlugin.getDefault().getPreferenceStore().setValue("Size of Visual Editor Pane 0-100%", secondControlWeight);
            }
        });
    }

    public void fillContainer(boolean useCurrentEditorSettings, String currentOrientation) {
        String splitting = useCurrentEditorSettings ? currentOrientation : JspEditorPlugin.getDefault().getPreferenceStore().getString("Visual/Source Editors Splitting");
        CustomSashForm newContainer = new CustomSashForm(this.cmpEd, CustomSashForm.getSplittingDirection(splitting));
        if (this.editorSettings != null) {
            this.editorSettings.clearOldSettings();
            this.editorSettings.addSetting(new SashSetting(newContainer));
        }
        newContainer.setLayoutData(new GridData(4, 4, true, true));
        if (CustomSashForm.isSourceEditorFirst(splitting)) {
            this.sourceContent.setParent((Composite)newContainer);
            this.visualContent.setParent((Composite)newContainer);
        } else {
            this.visualContent.setParent((Composite)newContainer);
            this.sourceContent.setParent((Composite)newContainer);
        }
        this.previewContent.setParent((Composite)newContainer);
        if (this.container.getMaximizedControl() != null) {
            newContainer.setMaximizedControl(this.container.getMaximizedControl());
        }
        if (this.container != null) {
            this.container.dispose();
        }
        this.container = newContainer;
        int defaultWeight = JspEditorPlugin.getDefault().getPreferenceStore().getInt("Size of Visual Editor Pane 0-100%");
        int[] weights = this.container.getWeights();
        if (useCurrentEditorSettings) {
            newContainer.setWeights(weights);
        } else if (defaultWeight == 0) {
            if (CustomSashForm.isSourceEditorFirst(splitting)) {
                this.container.maxDown();
            } else {
                this.container.maxUp();
            }
        } else if (defaultWeight == 1000) {
            if (CustomSashForm.isSourceEditorFirst(splitting)) {
                this.container.maxUp();
            } else {
                this.container.maxDown();
            }
        } else {
            if (CustomSashForm.isSourceEditorFirst(splitting)) {
                weights[0] = 1000 - defaultWeight;
                weights[1] = defaultWeight;
            } else {
                weights[0] = defaultWeight;
                weights[1] = 1000 - defaultWeight;
            }
            if (weights != null && !this.container.isDisposed()) {
                this.container.setWeights(weights);
            }
        }
        this.container.setSashBorders(new boolean[]{true, true, true});
        if (this.controlListener != null && this.cmpEdTl != null && !this.cmpEdTl.isDisposed()) {
            this.cmpEdTl.getParent().removeControlListener(this.controlListener);
        }
        this.controlListener = new ControlListener(){

            public void controlMoved(ControlEvent event) {
            }

            public void controlResized(ControlEvent event) {
                VpeEditorPart.this.container.layout();
            }
        };
        if (this.cmpEdTl != null && !this.cmpEdTl.isDisposed()) {
            this.cmpEdTl.getParent().addControlListener(this.controlListener);
        }
        this.cmpEdTl.layout(true, true);
    }

    public void createVisualEditor() {
        this.visualEditor = new MozillaEditor();
        try {
            this.visualEditor.init(this.getEditorSite(), this.getEditorInput());
        }
        catch (PartInitException e) {
            VpePlugin.reportProblem((Exception)((Object)e));
        }
        this.visualEditor.setEditorLoadWindowListener(new EditorLoadWindowListener(){

            @Override
            public void load() {
                VpeEditorPart.this.visualEditor.setEditorLoadWindowListener(null);
                VpeController vpeController = new VpeController(VpeEditorPart.this);
                vpeController.init(VpeEditorPart.this.sourceEditor, VpeEditorPart.this.visualEditor, VpeEditorPart.this.bundleMap);
            }
        });
        this.toolBar = this.visualEditor.createVisualToolbar((Composite)this.verticalToolbarSplitter);
        this.visualEditor.createPartControl(this.visualContent);
        if (this.multiPageEditor instanceof JSPMultiPageEditor) {
            JSPMultiPageEditor jspMultiPageEditor = (JSPMultiPageEditor)this.multiPageEditor;
            this.selectionBar = jspMultiPageEditor.getSelectionBar();
            if (!XulRunnerBrowser.isCurrentPlatformOfficiallySupported()) {
                jspMultiPageEditor.setXulRunnerBrowserIsNotSupported(true);
            }
        }
    }

    public void createPreviewBrowser() {
        this.previewWebBrowser = new MozillaPreview(this, this.sourceEditor);
        try {
            this.previewWebBrowser.init(this.getEditorSite(), this.getEditorInput());
            this.previewWebBrowser.setEditorLoadWindowListener(new EditorLoadWindowListener(){

                @Override
                public void load() {
                    VpeEditorPart.this.previewWebBrowser.setEditorLoadWindowListener(null);
                    VpeEditorPart.this.previewWebBrowser.buildDom();
                }
            });
            this.previewWebBrowser.createPartControl(this.previewContent);
        }
        catch (PartInitException e) {
            VpePlugin.reportProblem((Exception)((Object)e));
        }
        if (!XulRunnerBrowser.isCurrentPlatformOfficiallySupported() && this.multiPageEditor instanceof JSPMultiPageEditor) {
            JSPMultiPageEditor jspMultiPageEditor = (JSPMultiPageEditor)this.multiPageEditor;
            jspMultiPageEditor.setXulRunnerBrowserIsNotSupported(true);
        }
    }

    public void setFocus() {
        if (this.activeEditor != null) {
            this.activeEditor.setFocus();
        }
    }

    public void dispose() {
        this.deactivateServices();
        this.sourceActivation = null;
        this.sourceMaxmin = null;
        this.visualActivation = null;
        this.visualMaxmin = null;
        this.jumpingActivation = null;
        this.jumping = null;
        if (this.verticalToolbarEmpty != null) {
            if (!this.verticalToolbarEmpty.isDisposed()) {
                this.verticalToolbarEmpty.dispose();
            }
            this.verticalToolbarEmpty = null;
        }
        if (this.optionsObject != null) {
            this.optionsObject.getModel().removeModelTreeListener(this.listener);
            this.listener = null;
            this.optionsObject = null;
        }
        if (this.editorSettings != null) {
            this.editorSettings.dispose();
            this.editorSettings = null;
        }
        if (this.activationListener != null) {
            IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
            window.getPartService().removePartListener((IPartListener)this.activationListener);
            Shell shell = window.getShell();
            if (shell != null && !shell.isDisposed()) {
                shell.removeShellListener((ShellListener)this.activationListener);
            }
            this.activationListener = null;
        }
        if (this.sourceEditor != null) {
            this.sourceEditor.dispose();
            this.sourceEditor = null;
        }
        if (this.visualEditor != null) {
            this.visualEditor.dispose();
            this.visualEditor = null;
        }
        if (this.previewWebBrowser != null) {
            this.previewWebBrowser.dispose();
            this.previewWebBrowser = null;
        }
        if (this.previewContent != null) {
            this.previewContent.dispose();
            this.previewContent = null;
        }
        this.activeEditor = null;
        this.multiPageEditor = null;
        super.dispose();
    }

    public Object getAdapter(Class adapter) {
        if (this.sourceEditor != null) {
            return this.sourceEditor.getAdapter(adapter);
        }
        return null;
    }

    public VpeController getController() {
        if (this.visualEditor == null) {
            return null;
        }
        return this.visualEditor.getController();
    }

    public MozillaPreview getPreviewWebBrowser() {
        return this.previewWebBrowser;
    }

    public MozillaEditor getVisualEditor() {
        return this.visualEditor;
    }

    public void maximizeSource() {
        if (this.container != null) {
            if (CustomSashForm.isSourceEditorFirst(JspEditorPlugin.getDefault().getPreferenceStore().getString("Visual/Source Editors Splitting"))) {
                this.container.maxDown();
            } else {
                this.container.maxUp();
            }
            this.updateVisualEditorVisibility();
        }
    }

    public void maximizeVisual() {
        if (this.container != null) {
            if (CustomSashForm.isSourceEditorFirst(JspEditorPlugin.getDefault().getPreferenceStore().getString("Visual/Source Editors Splitting"))) {
                this.container.maxUp();
            } else {
                this.container.maxDown();
            }
            this.updateVisualEditorVisibility();
        }
    }

    protected void updateVisualEditorVisibility() {
        Point point = this.visualContent.getSize();
        if (point.x == 0 || point.y == 0) {
            VpeController controller = this.getController();
            if (controller != null) {
                controller.setVisualEditorVisible(false);
            }
        } else {
            VpeController controller = this.getController();
            if (controller != null && !controller.isVisualEditorVisible()) {
                controller.setVisualEditorVisible(true);
                if (controller.getSelectionManager() != null) {
                    controller.getSelectionManager().refreshVisualSelection();
                }
                if (!controller.isSynced()) {
                    controller.visualRefresh();
                }
            }
        }
    }

    public void updatePartAccordingToPreferences() {
        if (this.visualEditor != null) {
            this.visualEditor.updateToolbarItemsAccordingToPreferences();
        }
        if (this.getController() != null) {
            boolean prefsShowBundlesAsEL;
            boolean doVisualRefresh = false;
            boolean presfShowBorderForUnknownTags = JspEditorPlugin.getDefault().getPreferenceStore().getBoolean("Show Border for Unknown Tags");
            if (presfShowBorderForUnknownTags != this.getController().getVisualBuilder().isShowBorderForUnknownTags()) {
                this.getController().getVisualBuilder().setShowBorderForUnknownTags(presfShowBorderForUnknownTags);
                doVisualRefresh = true;
            }
            RGB rgb = StringConverter.asRGB((String)JspEditorPlugin.getDefault().getPreferenceStore().getString("Selection border color for visible element"));
            this.visualEditor.getXulRunnerEditor().setVisibleSelectedElementColor(VpeStyleUtil.rgbToString(rgb));
            rgb = StringConverter.asRGB((String)JspEditorPlugin.getDefault().getPreferenceStore().getString("Selection border color for hidden element"));
            this.visualEditor.getXulRunnerEditor().setHiddenSelectedElementColor(VpeStyleUtil.rgbToString(rgb));
            boolean prefsShowNonVisualTags = JspEditorPlugin.getDefault().getPreferenceStore().getBoolean("Show non-visual tags");
            if (prefsShowNonVisualTags != this.getController().getVisualBuilder().isShowInvisibleTags()) {
                this.getController().getVisualBuilder().setShowInvisibleTags(prefsShowNonVisualTags);
                doVisualRefresh = true;
            }
            if ((prefsShowBundlesAsEL = JspEditorPlugin.getDefault().getPreferenceStore().getBoolean("Show Resource Bundles Usage as EL Expressions")) != this.getController().getPageContext().getBundle().isShowBundleUsageAsEL()) {
                this.getController().getPageContext().getBundle().updateShowBundleUsageAsEL(prefsShowBundlesAsEL);
                doVisualRefresh = true;
            }
            boolean prefsShowVPEToolBar = JspEditorPlugin.getDefault().getPreferenceStore().getBoolean("Show VPE Toolbar");
            this.setVerticalToolbarVisible(prefsShowVPEToolBar);
            if (doVisualRefresh) {
                this.getController().visualRefresh();
            }
            this.fillContainer(false, null);
        }
    }

    public void updateSelectionBar(boolean isSelectionBarVisible) {
        if (this.selectionBar != null) {
            this.selectionBar.setVisible(isSelectionBarVisible);
        } else {
            VpePlugin.getDefault().logError("VPE Selection Bar is not initialized.");
        }
    }

    private void deactivateServices() {
        IHandlerService handlerService;
        IContextService contextService;
        if (this.fContextActivation != null && (contextService = (IContextService)this.getSite().getService(IContextService.class)) != null) {
            contextService.deactivateContext(this.fContextActivation);
        }
        if ((handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class)) != null) {
            if (this.sourceActivation != null) {
                handlerService.deactivateHandler(this.sourceActivation);
            }
            if (this.visualActivation != null) {
                handlerService.deactivateHandler(this.visualActivation);
            }
            if (this.jumpingActivation != null) {
                handlerService.deactivateHandler(this.jumpingActivation);
            }
        }
    }

    public CustomSashForm getContainer() {
        return this.container;
    }

    private class ActivationListener
    extends ShellAdapter
    implements IPartListener {
        private static final String VPE_EDITOR_CONTEXT = "org.jboss.tools.vpe.editorContext";
        private static final String VPE_VISUAL_MAXMIN = "org.jboss.tools.vpe.visual.maxmin";
        private static final String VPE_SOURCE_MAXMIN = "org.jboss.tools.vpe.source.maxmin";
        private static final String VPE_JUMPING = "org.jboss.tools.vpe.jumping";
        private IWorkbenchPart fActivePart;
        private boolean fIsHandlingActivation = false;

        private ActivationListener() {
        }

        public void partActivated(IWorkbenchPart part) {
            this.fActivePart = part;
            this.handleActivation();
            if (part == VpeEditorPart.this.multiPageEditor) {
                this.activateKeys();
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
            this.fActivePart = null;
            if (part == VpeEditorPart.this.multiPageEditor) {
                VpeEditorPart.this.deactivateServices();
            }
        }

        public void partOpened(IWorkbenchPart part) {
        }

        public void shellActivated(ShellEvent e) {
            e.widget.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ActivationListener.this.handleActivation();
                }
            });
        }

        private void handleActivation() {
            if (VpeEditorPart.this.visualEditor != null && VpeEditorPart.this.visualEditor.getController() != null) {
                VpeEditorPart.this.visualEditor.getController().refreshCommands();
            }
            if (this.fIsHandlingActivation) {
                return;
            }
            if (this.fActivePart == VpeEditorPart.this.multiPageEditor) {
                this.fIsHandlingActivation = true;
                try {
                    if (VpeEditorPart.this.sourceEditor != null) {
                        if (VpeEditorPart.this.visualEditor != null && VpeEditorPart.this.visualEditor.getController() != null && VpeEditorPart.this.visualEditor.getController().isVisualEditorVisible()) {
                            VpeEditorPart.this.visualEditor.getController().refreshTemplates();
                        }
                        VpeEditorPart.this.sourceEditor.safelySanityCheckState(VpeEditorPart.this.getEditorInput());
                    }
                }
                finally {
                    this.fIsHandlingActivation = false;
                }
            }
        }

        private void activateKeys() {
            IWorkbench workbench = PlatformUI.getWorkbench();
            IContextService contextService = (IContextService)workbench.getAdapter(IContextService.class);
            VpeEditorPart.this.fContextActivation = contextService.activateContext(VPE_EDITOR_CONTEXT);
            IHandlerService handlerService = (IHandlerService)workbench.getService(IHandlerService.class);
            if (handlerService != null) {
                if (VpeEditorPart.this.sourceActivation != null) {
                    handlerService.deactivateHandler(VpeEditorPart.this.sourceActivation);
                }
                VpeEditorPart.this.sourceActivation = handlerService.activateHandler(VPE_SOURCE_MAXMIN, VpeEditorPart.this.sourceMaxmin);
                if (VpeEditorPart.this.visualActivation != null) {
                    handlerService.deactivateHandler(VpeEditorPart.this.visualActivation);
                }
                VpeEditorPart.this.visualActivation = handlerService.activateHandler(VPE_VISUAL_MAXMIN, VpeEditorPart.this.visualMaxmin);
                if (VpeEditorPart.this.jumpingActivation != null) {
                    handlerService.deactivateHandler(VpeEditorPart.this.jumpingActivation);
                }
                VpeEditorPart.this.jumpingActivation = handlerService.activateHandler(VPE_JUMPING, VpeEditorPart.this.jumping);
            }
        }
    }
}

