/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.preferences;

import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.jboss.tools.vpe.editor.preferences.VpeColorSelector;

public class VpeColorFieldEditor
extends FieldEditor {
    private VpeColorSelector colorSelector;

    protected VpeColorFieldEditor() {
    }

    public VpeColorFieldEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
    }

    protected void adjustForNumColumns(int numColumns) {
        ((GridData)this.colorSelector.getButton().getLayoutData()).horizontalSpan = numColumns - 1;
    }

    protected Point computeImageSize(Control window) {
        GC gc = new GC((Drawable)window);
        Font f = JFaceResources.getFontRegistry().get("org.eclipse.jface.defaultfont");
        gc.setFont(f);
        int height = gc.getFontMetrics().getHeight();
        gc.dispose();
        Point p = new Point(height * 3 - 6, height);
        return p;
    }

    protected void createControl(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 8;
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)layout);
        this.doFillIntoGrid(container, layout.numColumns);
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label control = this.getLabelControl(parent);
        control.setLayoutData((Object)new GridData());
        Button colorButton = this.getChangeControl(parent);
        colorButton.setLayoutData((Object)new GridData());
    }

    protected void doLoad() {
        if (this.colorSelector == null) {
            return;
        }
        this.colorSelector.setColorValue(PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)this.getPreferenceName()));
    }

    protected void doLoadDefault() {
        if (this.colorSelector == null) {
            return;
        }
        this.colorSelector.setColorValue(PreferenceConverter.getDefaultColor((IPreferenceStore)this.getPreferenceStore(), (String)this.getPreferenceName()));
    }

    protected void doStore() {
        PreferenceConverter.setValue((IPreferenceStore)this.getPreferenceStore(), (String)this.getPreferenceName(), (RGB)this.colorSelector.getColorValue());
    }

    public VpeColorSelector getColorSelector() {
        return this.colorSelector;
    }

    protected Button getChangeControl(Composite parent) {
        if (this.colorSelector == null) {
            this.colorSelector = new VpeColorSelector(parent);
            this.colorSelector.addListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    VpeColorFieldEditor.this.fireValueChanged(event.getProperty(), event.getOldValue(), event.getNewValue());
                    VpeColorFieldEditor.this.setPresentsDefaultValue(false);
                }
            });
        } else {
            this.checkParent((Control)this.colorSelector.getButton(), parent);
        }
        return this.colorSelector.getButton();
    }

    public int getNumberOfControls() {
        return 1;
    }

    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
        this.getChangeControl(parent).setEnabled(enabled);
    }
}

