/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.template;

import java.util.List;
import java.util.Map;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeAbstractCreator;
import org.jboss.tools.vpe.editor.template.VpeChildrenInfo;
import org.jboss.tools.vpe.editor.template.VpeCreatorInfo;
import org.jboss.tools.vpe.editor.template.VpeCreatorUtil;
import org.jboss.tools.vpe.editor.template.VpeDataTableElements;
import org.jboss.tools.vpe.editor.template.VpeDependencyMap;
import org.jboss.tools.vpe.editor.util.VisualDomUtil;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VpeDataTableColumnCreator
extends VpeAbstractCreator {
    VpeDataTableColumnCreator(Element element, VpeDependencyMap dependencyMap, boolean caseSensitive) {
    }

    @Override
    public VpeCreatorInfo create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument, nsIDOMElement visualElement, Map visualNodeMap) {
        int index = this.getColumnIndex(sourceNode);
        VpeCreatorInfo creatorInfo = null;
        nsIDOMNode visualParent = null;
        nsIDOMNode visualNode = pageContext.getCurrentVisualNode();
        if (visualNode != null) {
            visualParent = visualNode.getParentNode();
        }
        VpeDataTableElements.SourceColumnElements columnElements = new VpeDataTableElements.SourceColumnElements(sourceNode);
        if (visualParent != null && "table".equalsIgnoreCase(visualParent.getNodeName()) && columnElements != null) {
            VpeDataTableElements.VisualDataTableElements visualDataTableElements = VpeDataTableElements.getVisualDataTableElements(visualParent);
            VpeDataTableElements.VisualColumnElements visualColumnElements = new VpeDataTableElements.VisualColumnElements();
            nsIDOMElement col = visualDocument.createElement("col");
            nsIDOMElement colgroup = VpeDataTableElements.getNamedChild(visualParent, "colgroup", 0);
            creatorInfo = new VpeCreatorInfo((nsIDOMNode)col);
            if (colgroup != null) {
                int cnt;
                colgroup.appendChild((nsIDOMNode)col);
                VpeChildrenInfo info = null;
                nsIDOMElement cell = VpeDataTableElements.makeCell((nsIDOMNode)visualDataTableElements.getColumnsHeaderRow(), index, "th", visualDocument);
                info = new VpeChildrenInfo(cell);
                if (columnElements.hasHeader()) {
                    info.addSourceChild(columnElements.getHeader());
                }
                creatorInfo.addChildrenInfo(info);
                String styleClass = "";
                String tableHeaderClass = this.getNodeAttrValue(sourceNode.getParentNode(), "headerClass");
                String columnHeaderClass = this.getNodeAttrValue(sourceNode, "headerClass");
                if (columnHeaderClass != null) {
                    styleClass = columnHeaderClass;
                } else if (tableHeaderClass != null) {
                    styleClass = tableHeaderClass;
                }
                this.setCellClass(cell, styleClass);
                visualColumnElements.setHeaderCell(cell);
                cell = VpeDataTableElements.makeCell((nsIDOMNode)visualDataTableElements.getColumnsFooterRow(), index, "td", visualDocument);
                info = new VpeChildrenInfo(cell);
                if (columnElements.hasFooter()) {
                    info.addSourceChild(columnElements.getFooter());
                }
                creatorInfo.addChildrenInfo(info);
                styleClass = "";
                String tableFooterClass = this.getNodeAttrValue(sourceNode.getParentNode(), "footerClass");
                String columnFooterClass = this.getNodeAttrValue(sourceNode, "footerClass");
                if (columnFooterClass != null) {
                    styleClass = columnFooterClass;
                } else if (tableFooterClass != null) {
                    styleClass = tableFooterClass;
                }
                this.setCellClass(cell, styleClass);
                visualColumnElements.setFooterCell(cell);
                Map<String, List<Node>> headerFacetChildren = null;
                Map<String, List<Node>> footerFacetChildren = null;
                headerFacetChildren = VisualDomUtil.findFacetElements(columnElements.getHeader(), pageContext);
                footerFacetChildren = VisualDomUtil.findFacetElements(columnElements.getFooter(), pageContext);
                boolean headerHtmlElementsPresents = headerFacetChildren != null && headerFacetChildren.get(VisualDomUtil.FACET_HTML_TAGS).size() > 0;
                boolean footerHtmlElementsPresents = footerFacetChildren != null && footerFacetChildren.get(VisualDomUtil.FACET_HTML_TAGS).size() > 0;
                cell = VpeDataTableElements.makeCell((nsIDOMNode)visualDataTableElements.getBodyRow(), index, "td", visualDocument);
                VpeChildrenInfo childrenInfo = new VpeChildrenInfo(cell);
                if (headerHtmlElementsPresents) {
                    for (Node node : headerFacetChildren.get(VisualDomUtil.FACET_HTML_TAGS)) {
                        childrenInfo.addSourceChild(node);
                    }
                }
                if (footerHtmlElementsPresents) {
                    for (Node node : footerFacetChildren.get(VisualDomUtil.FACET_HTML_TAGS)) {
                        childrenInfo.addSourceChild(node);
                    }
                }
                creatorInfo.addChildrenInfo(childrenInfo);
                NodeList list = sourceNode.getChildNodes();
                int n = cnt = list != null ? list.getLength() : 0;
                if (cnt > 0) {
                    Node text;
                    info = new VpeChildrenInfo(cell);
                    boolean useTextNodeAsBody = true;
                    int i = 0;
                    while (i < cnt) {
                        Node node = list.item(i);
                        if (node.getNodeType() == 1) {
                            boolean isFacet = VpeDataTableColumnCreator.namesIsEquals("facet", node.getNodeName());
                            Node attrName = node.getAttributes().getNamedItem("name");
                            if (!isFacet || attrName != null && !"header".equals(attrName.getNodeValue()) && !"footer".equals(attrName.getNodeValue())) {
                                info.addSourceChild(node);
                                useTextNodeAsBody = false;
                            }
                        }
                        ++i;
                    }
                    if (useTextNodeAsBody && (text = VpeCreatorUtil.getTextChildNode(sourceNode)) != null) {
                        info.addSourceChild(text);
                    }
                    creatorInfo.addChildrenInfo(info);
                    String columnClasses = this.getNodeAttrValue(sourceNode.getParentNode(), "columnClasses");
                    if (columnClasses != null && cell != null) {
                        this.setColumnClassesToCell(cell, columnClasses, index);
                    }
                    visualColumnElements.setBodyCell(cell);
                }
                visualNodeMap.put(this, visualColumnElements);
            }
        }
        return creatorInfo;
    }

    private int getColumnIndex(Node sourceNode) {
        int index = 0;
        Node prevNode = sourceNode.getPreviousSibling();
        while (prevNode != null) {
            if (!(sourceNode.getNodeName().indexOf("column") < 0 && sourceNode.getNodeName().indexOf("treeColumn") < 0 || prevNode.getNodeName().indexOf("column") < 0 && prevNode.getNodeName().indexOf("treeColumn") < 0)) {
                ++index;
            } else if (prevNode.getNodeName().equals(sourceNode.getNodeName())) {
                ++index;
            }
            prevNode = prevNode.getPreviousSibling();
        }
        return index;
    }

    @Override
    public boolean isRecreateAtAttrChange(VpePageContext pageContext, Element sourceElement, nsIDOMDocument visualDocument, nsIDOMNode visualNode, Object data, String name, String value) {
        return true;
    }

    @Override
    public Node getNodeForUpdate(VpePageContext pageContext, Node sourceNode, nsIDOMNode visualNode, Map visualNodeMap) {
        return sourceNode.getParentNode();
    }

    @Override
    public void removeElement(VpePageContext pageContext, Element sourceElement, Map visualNodeMap) {
        Object elements = visualNodeMap.get(this);
        if (elements instanceof VpeDataTableElements.VisualColumnElements) {
            VpeDataTableColumnCreator.removeChild(((VpeDataTableElements.VisualColumnElements)elements).getHeaderCell());
            VpeDataTableColumnCreator.removeChild(((VpeDataTableElements.VisualColumnElements)elements).getBodyCell());
            VpeDataTableColumnCreator.removeChild(((VpeDataTableElements.VisualColumnElements)elements).getFooterCell());
        }
    }

    private static void removeChild(nsIDOMElement child) {
        if (child != null && child.getParentNode() != null) {
            child.getParentNode().removeChild((nsIDOMNode)child);
        }
    }

    private static boolean namesIsEquals(String name1, String name2) {
        int ind = name2.indexOf(":");
        return ind < name2.length() && name1.equals(name2.substring(ind >= 0 ? ind + 1 : 0));
    }

    private void setColumnClassesToCell(nsIDOMElement cell, String columnClasses, int index) {
        String[] classes = columnClasses.split(",");
        if (classes.length > 0) {
            int classesCount = classes.length;
            int columnCount = index + 1;
            String className = "";
            if (columnCount <= classesCount) {
                className = classes[columnCount - 1];
            } else {
                int remainder = columnCount % classesCount;
                int classesIndex = remainder == 0 ? classesCount - 1 : remainder - 1;
                className = classes[classesIndex];
            }
            if (className.trim().length() > 0) {
                cell.setAttribute("class", className);
            }
        }
    }

    private void setCellClass(nsIDOMElement cell, String className) {
        if (cell != null && className != null && className.trim().length() > 0) {
            cell.setAttribute("class", className);
        }
    }

    private String getNodeAttrValue(Node node, String attrName) {
        Node attr;
        if (node != null && (attr = node.getAttributes().getNamedItem(attrName)) != null) {
            return attr.getNodeValue();
        }
        return null;
    }
}

