/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.core;

import java.util.Comparator;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.jboss.ide.eclipse.archives.core.ArchivesCore;
import org.jboss.ide.eclipse.archives.core.ArchivesCoreMessages;
import org.jboss.ide.eclipse.archives.core.model.ArchivesModel;
import org.jboss.ide.eclipse.archives.core.model.ArchivesModelException;

public class WorkspaceChangeListener
implements IResourceChangeListener {
    public void resourceChanged(IResourceChangeEvent event) {
        IResource resource;
        Comparator c = new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 instanceof IProject && o2 instanceof IProject) {
                    return ((IProject)o1).getLocation().toOSString().compareTo(((IProject)o2).getLocation().toOSString());
                }
                return 0;
            }
        };
        if ((event.getType() == 4 || event.getType() == 2) && (resource = event.getResource()) instanceof IProject) {
            IProject project = (IProject)resource;
            IResource packages = project.findMember(".packages");
            if (ArchivesModel.instance().isProjectRegistered(project.getLocation()) || packages != null) {
                this.unregister(project);
            }
        }
        final TreeSet projects = new TreeSet(c);
        IResourceDelta delta = event.getDelta();
        try {
            if (delta != null) {
                delta.accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        if (delta.getResource() != null && delta.getResource().getLocation() != null && delta.getResource().getLocation().lastSegment().equals(".packages") && delta.getResource().getProject() != null) {
                            projects.add(delta.getResource().getProject());
                        }
                        return true;
                    }
                });
            }
        }
        catch (CoreException coreException) {}
        if (event.getType() == 4 || event.getType() == 2) {
            for (IProject p : projects) {
                this.unregister(p);
            }
        } else {
            for (final IProject p : projects) {
                try {
                    if (p.getSessionProperty(new QualifiedName("org.jboss.ide.eclipse.archives.core", "localname")) != null) continue;
                    try {
                        new WorkspaceJob(ArchivesCore.bind((String)ArchivesCoreMessages.RefreshProject, (String)p.getName())){

                            public IStatus runInWorkspace(IProgressMonitor monitor) {
                                try {
                                    ArchivesModel.instance().registerProject(p.getLocation(), (IProgressMonitor)new NullProgressMonitor());
                                    p.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                                }
                                catch (CoreException e) {
                                    Status status = new Status(2, "org.jboss.ide.eclipse.archives.core", ArchivesCore.bind((String)ArchivesCoreMessages.RefreshProjectFailed, (String)p.getName()), (Throwable)e);
                                    return status;
                                }
                                return Status.OK_STATUS;
                            }
                        }.schedule();
                    }
                    catch (ArchivesModelException ame) {
                        ArchivesCore.getInstance().getLogger().log(4, ArchivesCore.bind((String)ArchivesCoreMessages.RegisterProjectFailed, (String)p.getName()), (Throwable)ame);
                    }
                }
                catch (CoreException coreException) {}
            }
        }
    }

    protected void unregister(final IProject project) {
        WorkspaceJob job = new WorkspaceJob(ArchivesCoreMessages.UnregisterProject){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                ArchivesModel.instance().unregisterProject(project.getLocation(), (IProgressMonitor)new NullProgressMonitor());
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }
}

