/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.render.template;

import java.util.Stack;
import org.jboss.seam.render.TemplateCompiler;
import org.jboss.seam.render.spi.TemplateResource;
import org.jboss.seam.render.template.Definition;
import org.jboss.seam.render.template.TemplateContext;
import org.jboss.seam.render.util.Assert;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.templates.TemplateRegistry;
import org.mvel2.templates.TemplateRuntime;

public class CompositionContext
extends TemplateContext<String, Definition> {
    private final CompositionContext context;
    private final TemplateCompiler templateCompiler;
    private final VariableResolverFactory variableResolverFactory;
    private final TemplateResource<?> resource;
    private final TemplateRegistry templateRegistry;
    private TemplateRuntime templateRuntime;
    private static ThreadLocal<Stack<CompositionContext>> stack;

    public CompositionContext(TemplateCompiler templateCompiler, VariableResolverFactory factory, TemplateRegistry registry, TemplateResource<?> resource) {
        Assert.notNull(templateCompiler, "TemplateCompiler must not be null.");
        Assert.notNull(factory, "VariableResolverFactory must not be null.");
        Assert.notNull(registry, "TemplateRegistry must not be null.");
        Assert.notNull(resource, "TemplateResource must not be null.");
        this.templateCompiler = templateCompiler;
        this.context = null;
        this.variableResolverFactory = factory;
        this.templateRegistry = registry;
        this.resource = resource;
    }

    private static void initStack() {
        if (stack == null) {
            stack = new ThreadLocal();
        }
        if (stack.get() == null) {
            stack.set(new Stack());
        }
    }

    private static ThreadLocal<Stack<CompositionContext>> getStack() {
        CompositionContext.initStack();
        return stack;
    }

    public CompositionContext(TemplateResource<?> resource, CompositionContext context) {
        Assert.notNull(resource, "TemplateResource must not be null.");
        Assert.notNull(context, "CompositionContext must not be null.");
        this.templateCompiler = context.getTemplateCompiler();
        this.variableResolverFactory = context.getVariableResolverFactory();
        this.templateRegistry = context.getTemplateRegistry();
        this.templateRuntime = context.getTemplateRuntime();
        this.resource = resource;
        this.context = context;
    }

    @Override
    public Definition get(String name) {
        Definition result = (Definition)super.get(name);
        if (result == null && this.context != null) {
            result = this.context.get(name);
        }
        return result;
    }

    public static CompositionContext peek() {
        if (!CompositionContext.getStack().get().isEmpty()) {
            return CompositionContext.getStack().get().peek();
        }
        return null;
    }

    public static CompositionContext push(CompositionContext context) {
        return CompositionContext.getStack().get().push(context);
    }

    public static CompositionContext pop() {
        return CompositionContext.getStack().get().pop();
    }

    public TemplateResource<?> getTemplateResource() {
        return this.resource;
    }

    public CompositionContext getWrapped() {
        return this.context;
    }

    public VariableResolverFactory getVariableResolverFactory() {
        return this.variableResolverFactory;
    }

    public TemplateRegistry getTemplateRegistry() {
        return this.templateRegistry;
    }

    public TemplateRuntime getTemplateRuntime() {
        return this.templateRuntime;
    }

    public void setTemplateRuntime(TemplateRuntime templateRuntime) {
        this.templateRuntime = templateRuntime;
    }

    public TemplateCompiler getTemplateCompiler() {
        return this.templateCompiler;
    }
}

