/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.render.template.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.jboss.seam.render.spi.TemplateResolver;
import org.jboss.seam.render.spi.TemplateResource;

public class FileTemplateResource
implements TemplateResource<File> {
    private final File resource;
    private final TemplateResolver<File> resolvedBy;

    public FileTemplateResource(File file) {
        this.resource = file;
        this.resolvedBy = null;
    }

    public FileTemplateResource(File file, TemplateResolver<File> resolvedBy) {
        this.resource = file;
        this.resolvedBy = resolvedBy;
    }

    @Override
    public File getUnderlyingResource() {
        return this.resource;
    }

    @Override
    public String getPath() {
        return this.resource.getAbsolutePath();
    }

    @Override
    public InputStream getInputStream() {
        try {
            return new FileInputStream(this.resource);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Could not open " + this.getClass().getSimpleName() + " at [" + this.resource.getAbsolutePath() + "]", e);
        }
    }

    @Override
    public TemplateResolver<File> getResolvedBy() {
        return this.resolvedBy;
    }

    @Override
    public long getLastModified() {
        return this.resource.lastModified();
    }
}

