/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.core.jdt;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.jboss.tools.common.core.jdt.Messages;
import org.jboss.tools.common.model.ui.ModelUIPlugin;

public class FavoritesClassController {
    private static final String FAVORITES_CLASSES_LIST = "JavaFavoritesFieldEditor.classes";
    private static final Image CLASS_ICON = JavaPluginImages.get((String)"org.eclipse.jdt.ui.class_obj.gif");
    private static LabelProvider labelProvider = new FavoritesClassLabelProvider();

    public static List<String> getFavoritesClassesList() {
        ArrayList<String> list = new ArrayList<String>();
        String classesList = ModelUIPlugin.getDefault().getPreferenceStore().getString(FAVORITES_CLASSES_LIST);
        if (classesList == null || classesList.length() == 0) {
            classesList = Messages.FavoritesClassController_defaultClasses;
        }
        StringTokenizer st = new StringTokenizer(classesList, ",");
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        return list;
    }

    private static String getClassesListString(Collection list) {
        StringBuffer buffer = new StringBuffer();
        Iterator i = list.iterator();
        while (i.hasNext()) {
            buffer.append((String)i.next()).append(",");
        }
        return buffer.toString();
    }

    public static void push(String className) {
        List<String> list = FavoritesClassController.getFavoritesClassesList();
        int index = -1;
        int i = 0;
        while (i < list.size()) {
            if (className.equals(list.get(i))) {
                index = i;
                break;
            }
            ++i;
        }
        if (index > -1) {
            list.add(0, list.get(index));
            list.remove(index + 1);
        } else {
            list.add(0, className);
        }
        ArrayList<String> newList = new ArrayList<String>();
        if (list.size() > 10) {
            int i2 = 0;
            while (i2 < 10) {
                newList.add(list.get(i2));
                ++i2;
            }
            list = newList;
        }
        IPreferenceStore store = ModelUIPlugin.getDefault().getPreferenceStore();
        store.setValue(FAVORITES_CLASSES_LIST, FavoritesClassController.getClassesListString(list));
        if (store instanceof IPersistentPreferenceStore) {
            try {
                ((IPersistentPreferenceStore)store).save();
            }
            catch (IOException e) {
                ModelUIPlugin.getPluginLog().logError((Throwable)e);
            }
        }
    }

    public static LabelProvider getLabelProvider() {
        return labelProvider;
    }

    static class FavoritesClassLabelProvider
    extends LabelProvider {
        FavoritesClassLabelProvider() {
        }

        public Image getImage(Object element) {
            return CLASS_ICON;
        }
    }
}

