/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.editor;

import java.text.MessageFormat;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.PartInitException;
import org.jboss.tools.common.editor.ErrorMode;
import org.jboss.tools.common.editor.ErrorSelectionListener;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.editor.DefaultEditorPart;

public abstract class AbstractSectionEditor
extends DefaultEditorPart {
    protected SashForm wrapper;
    protected Composite guiControl;
    protected Control control;
    protected ErrorMode errorMode = new ErrorMode();
    protected XModelObject object = null;

    @Override
    public void dispose() {
        if (this.errorMode == null) {
            return;
        }
        this.errorMode.dispose();
        this.errorMode = null;
        this.disposeGui();
        if (!this.wrapper.isDisposed()) {
            try {
                this.wrapper.dispose();
            }
            catch (SWTException e) {
                ModelUIPlugin.getPluginLog().logError((Throwable)e);
            }
        }
        this.wrapper = null;
        this.control = null;
        this.guiControl = null;
        super.dispose();
    }

    @Override
    public Control createControl(Composite parent) {
        this.wrapper = new SashForm(parent, 512);
        this.createErr();
        this.errorMode.setEnabled(false);
        this.guiControl = new Composite((Composite)this.wrapper, 0);
        GridLayout l = new GridLayout();
        l.marginHeight = 0;
        l.marginWidth = 0;
        this.guiControl.setLayout((Layout)l);
        this.wrapper.setWeights(new int[]{10, 30});
        return this.wrapper;
    }

    @Override
    public ISelectionProvider getSelectionProvider() {
        return null;
    }

    protected void fireGuiModified() {
        if (this.wrapper != null) {
            this.wrapper.update();
        }
        if (this.wrapper != null) {
            this.wrapper.layout();
        }
    }

    protected abstract void updateGui();

    protected void disposeGui() {
        if (this.control != null && !this.control.isDisposed()) {
            this.control.dispose();
        }
        this.control = null;
    }

    private void createErr() {
        if (this.errorMode.getControl() != null && !this.errorMode.getControl().isDisposed()) {
            return;
        }
        Control c = this.errorMode.createControl((Composite)this.wrapper);
        c.setLayoutData((Object)new GridData(1808));
    }

    public void setObject(XModelObject object, boolean erroneous) {
        this.object = object;
        boolean bl = erroneous = erroneous || this.isWrongEntity();
        if (object != null) {
            this.updateGui();
        }
        if (this.errorMode.isVisible() != erroneous) {
            this.errorMode.setEnabled(erroneous);
            this.fireGuiModified();
        }
        if (erroneous) {
            this.setErroneousObject(object);
        }
    }

    public final boolean isWrongEntity() {
        return this.object != null && this.isWrongEntity(this.object.getModelEntity().getName());
    }

    protected boolean isWrongEntity(String entity) {
        return false;
    }

    public XModelObject getObject() {
        return this.object;
    }

    private void setErroneousObject(XModelObject object) {
        if (object == null) {
            return;
        }
        String err = object.get("errors");
        if (err == null || err.length() == 0 && this.isWrongEntity(object.getModelEntity().getName())) {
            err = "Warning: @ @0:0@" + MessageFormat.format("This editor is not intended for editing {0}. You can use source page, but its coloring may be inadequate.", object.getAttributeValue("element type"));
        }
        if (err == null) {
            err = "";
        }
        this.errorMode.update(err);
    }

    public void addErrorSelectionListener(ErrorSelectionListener listener) {
        this.errorMode.addErrorSelectionListener(listener);
    }

    public void fireEditorSelected() {
    }

    @Override
    public void gotoMarker(IMarker marker) {
    }

    @Override
    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.createActions();
    }

    @Override
    public void addPropertyListener(IPropertyListener listener) {
    }

    public String getTitle() {
        String s = super.getTitle();
        return s == null ? "" : s;
    }

    @Override
    public Image getTitleImage() {
        return null;
    }

    @Override
    public String getTitleToolTip() {
        return null;
    }

    @Override
    public void removePropertyListener(IPropertyListener listener) {
    }

    @Override
    public void setFocus() {
        if (this.control == null) {
            return;
        }
        if (!this.wrapper.isDisposed()) {
            this.wrapper.setFocus();
        }
    }

    @Override
    public Object getAdapter(Class adapter) {
        return null;
    }

    @Override
    public void doSave(IProgressMonitor monitor) {
    }

    @Override
    public void doSaveAs() {
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public boolean isSaveAsAllowed() {
        return false;
    }

    @Override
    public boolean isSaveOnCloseNeeded() {
        return false;
    }
}

