/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.action.global;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.jboss.tools.common.model.ServiceDialog;
import org.jboss.tools.common.model.options.PreferenceModelUtilities;
import org.jboss.tools.common.model.ui.ModelUIPlugin;

public abstract class AbstractShowUrlActionDelegate
implements IWorkbenchWindowActionDelegate {
    IWorkbenchWindow window;

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    public void run(IAction action) {
        AbstractShowUrlActionDelegate.runURL(this.getUrl());
    }

    protected abstract String getUrl();

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
    }

    public static void runURL(String url) {
        if (url == null || url.length() == 0) {
            return;
        }
        if (!url.startsWith("http://")) {
            url = "http://" + url;
        }
        try {
            IWorkbenchBrowserSupport browserSupport = ModelUIPlugin.getDefault().getWorkbench().getBrowserSupport();
            IWebBrowser browser = browserSupport.createBrowser(134, null, null, null);
            browser.openURL(new URL(url));
        }
        catch (MalformedURLException mue) {
            ServiceDialog d = PreferenceModelUtilities.getPreferenceModel().getService();
            d.showDialog("Error", MessageFormat.format("Incorrect URL: {0}.", mue.getMessage()), new String[]{"OK"}, null, 1);
        }
        catch (PartInitException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
        }
    }
}

