/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.attribute;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.meta.action.XAttributeData;
import org.jboss.tools.common.meta.key.WizardKeys;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.impl.XModelImpl;
import org.jboss.tools.common.model.ui.INewContentProvider;
import org.jboss.tools.common.model.ui.IValueChangeListener;
import org.jboss.tools.common.model.ui.IValueProvider;
import org.jboss.tools.common.model.ui.attribute.IListContentProvider;
import org.jboss.tools.common.model.ui.attribute.IPropertyDescriptorEx;
import org.jboss.tools.common.model.ui.attribute.IXModelSupport;
import org.jboss.tools.common.model.ui.attribute.adapter.AdapterFactory;
import org.jboss.tools.common.model.ui.attribute.adapter.DefaultXAttributeListContentProvider;
import org.jboss.tools.common.model.ui.attribute.adapter.DefaultXAttributeTreeContentProvider;
import org.jboss.tools.common.model.ui.attribute.adapter.DefaultXModelObjectLabelProvider;
import org.jboss.tools.common.model.ui.attribute.adapter.IModelPropertyEditorAdapter;
import org.jboss.tools.common.model.ui.attribute.editor.PropertyEditor;
import org.jboss.tools.common.model.ui.attribute.editor.PropertyEditorFactory;
import org.jboss.tools.common.model.ui.objecteditor.XTable;

public class XAttributePropertyDescription
implements IPropertyDescriptorEx,
IXModelSupport {
    protected XAttribute attribute;
    protected XModelObject modelObject;
    protected XAttributeData attributeData;
    protected PropertyEditor propertyEditor;
    protected IPropertySource propertySource;
    ILabelProvider label;

    protected XAttributePropertyDescription() {
    }

    public XAttributePropertyDescription(IPropertySource propertySource, XAttribute attribute, XModelObject modelObject) {
        this.propertySource = propertySource;
        this.attribute = attribute;
        this.modelObject = modelObject;
        IModelPropertyEditorAdapter adapter = AdapterFactory.getAdapter(attribute, modelObject, modelObject.getModel());
        this.propertyEditor = PropertyEditorFactory.createPropertyEditor((Object)adapter, attribute, modelObject);
    }

    public XAttributePropertyDescription(IPropertySource propertySource, XAttribute attribute, XAttributeData attributeData, XModel model) {
        this.propertySource = propertySource;
        this.attribute = attribute;
        this.attributeData = attributeData;
        IModelPropertyEditorAdapter adapter = AdapterFactory.getAdapter(attribute, attributeData, model);
        this.propertyEditor = PropertyEditorFactory.createPropertyEditor((Object)adapter, attribute, attributeData);
    }

    @Override
    public IPropertySource getPropertySource() {
        return this.propertySource;
    }

    public CellEditor createPropertyEditor(Composite parent) {
        if (!this.isEditable()) {
            return null;
        }
        CellEditor editor = this.propertyEditor.getCellEditor(parent);
        if (editor != null) {
            editor.setValidator(new ICellEditorValidator(){

                public String isValid(Object value) {
                    if (XAttributePropertyDescription.this.modelObject == null) {
                        return null;
                    }
                    String error = ((XModelImpl)XAttributePropertyDescription.this.modelObject.getModel()).getError(XAttributePropertyDescription.this.modelObject, XAttributePropertyDescription.this.attribute.getName(), value == null ? "" : value.toString());
                    return error;
                }
            });
        }
        return !this.isEditable() ? null : editor;
    }

    public void createFieldEditor(Composite parent) {
        this.propertyEditor.getFieldEditor(parent);
    }

    public String getCategory() {
        return null;
    }

    public String getDescription() {
        return this.attribute.getDisplayName();
    }

    public String getDisplayName() {
        String s = WizardKeys.getAttributeDisplayName((XAttribute)this.attribute);
        return s != null ? s : this.attribute.getName();
    }

    public String[] getFilterFlags() {
        return null;
    }

    public Object getHelpContextIds() {
        return null;
    }

    public Object getId() {
        return this.attribute.getName();
    }

    public ILabelProvider getLabelProvider() {
        if (this.label == null) {
            this.label = new LP();
        }
        return this.label;
    }

    public boolean isCompatibleWith(IPropertyDescriptor anotherProperty) {
        return false;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == ILabelProvider.class) {
            return new DefaultXModelObjectLabelProvider();
        }
        if (adapter == ITreeContentProvider.class) {
            return new DefaultXAttributeTreeContentProvider(this.getAttribute(), this.getModel(), this.modelObject);
        }
        if (adapter == IListContentProvider.class) {
            DefaultXAttributeListContentProvider p = new DefaultXAttributeListContentProvider();
            p.setAttribute(this.getAttribute());
            return p;
        }
        if (adapter == INewContentProvider.class) {
            return null;
        }
        if (adapter == ISelectionProvider.class) {
            return null;
        }
        if (adapter == ISelectionChangedListener.class) {
            return null;
        }
        if (adapter == IValueProvider.class) {
            return null;
        }
        if (adapter == IValueChangeListener.class) {
            return null;
        }
        return null;
    }

    @Override
    public XModel getModel() {
        return ((IXModelSupport)this.getPropertySource()).getModel();
    }

    @Override
    public PropertyEditor getPropertyEditor() {
        return !this.isEditable() ? null : this.propertyEditor;
    }

    public XAttribute getAttribute() {
        return this.attribute;
    }

    public void setAttribute(XAttribute attribute) {
        this.attribute = attribute;
    }

    protected boolean isEditable() {
        return this.modelObject == null || this.modelObject.isAttributeEditable(this.attribute.getName());
    }

    class LP
    extends LabelProvider {
        LP() {
        }

        public String getText(Object element) {
            Object value = XAttributePropertyDescription.this.getPropertySource().getPropertyValue(XAttributePropertyDescription.this.getId());
            if (value == null) {
                return null;
            }
            String s = value.toString();
            s = XTable.toVisualValue(s);
            return s;
        }

        public Image getImage(Object element) {
            return null;
        }
    }
}

