/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.attribute;

import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySource2;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.meta.constraint.impl.XAttributeConstraintAList;
import org.jboss.tools.common.meta.key.WizardKeys;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.adapter.IModelObjectAdapter;
import org.jboss.tools.common.model.event.XModelTreeEvent;
import org.jboss.tools.common.model.event.XModelTreeListener;
import org.jboss.tools.common.model.ui.attribute.IXModelSupport;
import org.jboss.tools.common.model.ui.attribute.XAttributePropertyDescription;
import org.jboss.tools.common.model.util.XModelTreeListenerSWTASync;

public class XModelObjectPropertySource
implements IPropertySource,
IXModelSupport,
IModelObjectAdapter,
IPropertySource2 {
    protected ArrayList<IPropertyDescriptor> propertyDescriptors;
    protected XModelObject modelObject;
    protected Properties cachedValues = new Properties();
    private XModelTreeListener listener = new XModelTreeListenerSWTASync(new XModelTreeListenerImpl());

    public void dispose() {
        if (this.modelObject != null && this.modelObject.getModel() != null) {
            this.modelObject.getModel().removeModelTreeListener(this.listener);
            this.listener = null;
        }
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return this.propertyDescriptors.toArray(new IPropertyDescriptor[this.propertyDescriptors.size()]);
    }

    public Object getPropertyValue(Object id) {
        String n = this.getAttributeNameById(id);
        String v = this.modelObject.getAttributeValue(n);
        XAttribute a = this.modelObject.getModelEntity().getAttribute(n);
        if (a != null && v != null && a.getConstraint() instanceof XAttributeConstraintAList) {
            v = WizardKeys.getVisualListValue((XAttribute)a, (String)v);
        }
        this.cachedValues.setProperty(n, v);
        return v;
    }

    public boolean isPropertySet(Object id) {
        String n = this.getAttributeNameById(id);
        String defaultValue = this.modelObject.getModelEntity().getAttribute(n).getDefaultValue();
        return !this.getPropertyValue(id).equals(defaultValue);
    }

    public void resetPropertyValue(Object id) {
        String n = this.getAttributeNameById(id);
        String defaultValue = this.modelObject.getModelEntity().getAttribute(n).getDefaultValue();
        if (defaultValue == null) {
            return;
        }
        if (this.modelObject.isActive()) {
            try {
                this.modelObject.getModel().editObjectAttribute(this.modelObject, n, defaultValue.toString());
            }
            catch (XModelException e) {
                throw new IllegalArgumentException(e);
            }
        } else {
            this.modelObject.setAttributeValue(n, defaultValue.toString());
        }
    }

    private String getAttributeNameById(Object id) {
        return id == null ? null : id.toString();
    }

    public void setPropertyValue(Object id, Object value) {
        if (value == null) {
            return;
        }
        String n = this.getAttributeNameById(id);
        String v = this.cachedValues.getProperty(n);
        if (value.equals(v)) {
            return;
        }
        this.cachedValues.setProperty(n, "" + value);
        value = this.fromVisualToModel(n, value.toString());
        if (this.modelObject.isActive()) {
            try {
                this.modelObject.getModel().editObjectAttribute(this.modelObject, n, value.toString());
            }
            catch (XModelException e) {
                throw new IllegalArgumentException(e);
            }
        } else {
            this.modelObject.setAttributeValue(n, value.toString());
        }
    }

    private String fromVisualToModel(String n, String value) {
        XAttribute a = this.modelObject.getModelEntity().getAttribute(n);
        if (a != null && value != null && a.getConstraint() instanceof XAttributeConstraintAList) {
            String[] vs = ((XAttributeConstraintAList)a.getConstraint()).getValues();
            int i = 0;
            while (i < vs.length) {
                String v = WizardKeys.getVisualListValue((XAttribute)a, (String)vs[i]);
                if (value.equals(v)) {
                    return vs[i];
                }
                ++i;
            }
        }
        return value;
    }

    public void setModelObject(XModelObject object) {
        this.modelObject = object;
        XAttribute[] attrs = this.modelObject.getModelEntity().getAttributes();
        this.propertyDescriptors = new ArrayList();
        int i = 0;
        while (i < attrs.length) {
            if (attrs[i].isVisible() && !"element type".equals(attrs[i].getName())) {
                this.propertyDescriptors.add(new XAttributePropertyDescription(this, attrs[i], this.modelObject));
            }
            ++i;
        }
        XModel model = this.modelObject.getModel();
        if (model.getManager("propertySheetUpdate") == null) {
            model.addModelTreeListener(this.listener);
            model.addManager("propertySheetUpdate", (Object)this.listener);
        }
    }

    @Override
    public XModel getModel() {
        return this.modelObject.getModel();
    }

    public boolean isPropertyResettable(Object id) {
        String n = this.getAttributeNameById(id);
        return this.modelObject != null && this.modelObject.isAttributeEditable(n);
    }

    class XModelTreeListenerImpl
    implements XModelTreeListener {
        XModelTreeListenerImpl() {
        }

        public void nodeChanged(XModelTreeEvent event) {
            if (XModelObjectPropertySource.this.modelObject == null || XModelObjectPropertySource.this.modelObject != event.getModelObject()) {
                return;
            }
            PropertySheet sh = null;
            try {
                sh = (PropertySheet)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.ui.views.PropertySheet");
            }
            catch (NullPointerException nullPointerException) {}
            if (sh == null) {
                return;
            }
            IPage page = sh.getCurrentPage();
            if (page instanceof PropertySheetPage) {
                PropertySheetPage p = (PropertySheetPage)page;
                if (p == null || p.getControl() == null || p.getControl().isDisposed()) {
                    return;
                }
                p.refresh();
            }
        }

        public void structureChanged(XModelTreeEvent event) {
        }
    }
}

