/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.attribute.adapter;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.JavaPackageCompletionProcessor;
import org.eclipse.jface.contentassist.IContentAssistSubjectControl;
import org.eclipse.jface.contentassist.ISubjectControlContentAssistProcessor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.sse.ui.internal.contentassist.CustomCompletionProposal;
import org.jboss.tools.common.model.XFilteredTree;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.attribute.adapter.DefaultXAttributeTreeContentProvider;
import org.jboss.tools.common.model.util.EclipseResourceUtil;

public class DefaultTreeSelectionContentAssistProcessor
extends JavaPackageCompletionProcessor
implements ISubjectControlContentAssistProcessor {
    DefaultXAttributeTreeContentProvider treeProvider;

    public void setTreeProvider(DefaultXAttributeTreeContentProvider treeProvider) {
        this.treeProvider = treeProvider;
    }

    public ICompletionProposal[] computeCompletionProposals(IContentAssistSubjectControl contentAssistSubjectControl, int documentOffset) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        IDocument document = contentAssistSubjectControl.getDocument();
        String text = document.get();
        this.addAttributeValueProposals(proposals, text, documentOffset);
        return proposals.toArray(new ICompletionProposal[0]);
    }

    public void addAttributeValueProposals(List<ICompletionProposal> proposalsList, String text, int offset) {
        if (this.treeProvider == null) {
            return;
        }
        XFilteredTree tree = this.treeProvider.getFilteredTree();
        if (tree == null) {
            this.treeProvider.getElements(null);
            tree = this.treeProvider.getFilteredTree();
        }
        if (tree == null) {
            return;
        }
        XModelObject root = tree.getRoot();
        if (root == null) {
            return;
        }
        String startText = text.substring(0, offset);
        TreeMap<String, Object> pathsMap = new TreeMap<String, Image>();
        this.collectPaths(startText, root, tree, pathsMap);
        String[] paths = pathsMap.keySet().toArray(new String[0]);
        if (paths.length == 1 && text.startsWith(paths[0])) {
            pathsMap = new TreeMap();
            this.collectPaths(paths[0], root, tree, pathsMap);
            paths = pathsMap.keySet().toArray(new String[0]);
        }
        int i = 0;
        while (i < paths.length) {
            String label = paths[i];
            String replacementString = paths[i];
            int replacementBeginPosition = 0;
            int replacementLength = text.length();
            int cursorPosition = replacementString.length();
            if (text.startsWith(replacementString)) {
                replacementString = "";
                replacementLength = 0;
            }
            CustomCompletionProposal proposal = new CustomCompletionProposal(replacementString, replacementBeginPosition, replacementLength, cursorPosition, (Image)pathsMap.get(paths[i]), label, null, null, 800);
            proposalsList.add((ICompletionProposal)proposal);
            ++i;
        }
    }

    void collectPaths(String startText, XModelObject object, XFilteredTree tree, Map<String, Image> map) {
        String value = tree.getValue(object);
        if (value != null && value.startsWith(startText)) {
            if (!(value.length() <= 0 || value.equals(startText) && value.endsWith("/"))) {
                map.put(value, EclipseResourceUtil.getImage((XModelObject)object));
            }
            if (value.length() > startText.length()) {
                return;
            }
        } else if (value != null && !startText.startsWith(value)) {
            return;
        }
        XModelObject[] cs = tree.getChildren(object);
        int i = 0;
        while (i < cs.length) {
            this.collectPaths(startText, cs[i], tree, map);
            ++i;
        }
    }
}

