/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.attribute.adapter.custom;

import java.util.ArrayList;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.model.ui.attribute.IListContentProvider;
import org.jboss.tools.common.model.ui.attribute.adapter.DefaultComboBoxValueAdapter;

public class TomcatJVMListAdapter
extends DefaultComboBoxValueAdapter
implements IListContentProvider {
    protected String[] tags = new String[0];

    @Override
    protected IListContentProvider createListContentProvider(XAttribute attribute) {
        return this;
    }

    @Override
    public void dispose() {
    }

    public Object[] getElements(Object inputElement) {
        if (this.tags.length == 0) {
            this.loadTags();
        }
        return this.tags;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    protected void loadTags() {
        ArrayList<String> list = new ArrayList<String>();
        IVMInstallType[] jvmType = JavaRuntime.getVMInstallTypes();
        int i = 0;
        while (i < jvmType.length) {
            IVMInstall[] jvmInstall = jvmType[i].getVMInstalls();
            int j = 0;
            while (j < jvmInstall.length) {
                list.add(jvmInstall[j].getName());
                ++j;
            }
            ++i;
        }
        this.tags = list.toArray(new String[0]);
    }

    public void propertyChange(PropertyChangeEvent event) {
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == ILabelProvider.class) {
            return new TomcatAdapterList();
        }
        return super.getAdapter(adapter);
    }

    static class TomcatAdapterList
    extends LabelProvider {
        TomcatAdapterList() {
        }

        public String getText(Object text) {
            IVMInstallType[] jvmType = JavaRuntime.getVMInstallTypes();
            int i = 0;
            while (i < jvmType.length) {
                IVMInstall[] jvmInstall = jvmType[i].getVMInstalls();
                int j = 0;
                while (j < jvmInstall.length) {
                    if (jvmInstall[j].getName().equals(text)) {
                        return String.valueOf(jvmInstall[j].getName()) + " - \"" + (jvmInstall[j].getInstallLocation().getPath().length() > 50 ? String.valueOf(jvmInstall[j].getInstallLocation().getPath().substring(50)) + " ..." : jvmInstall[j].getInstallLocation().getPath()) + "\"";
                    }
                    ++j;
                }
                ++i;
            }
            return "";
        }
    }
}

