/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.attribute.editor;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWizard;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.ui.IValueChangeListener;
import org.jboss.tools.common.model.ui.IValueProvider;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.attribute.adapter.DefaultValueAdapter;
import org.jboss.tools.common.model.ui.attribute.adapter.IModelPropertyEditorAdapter;
import org.jboss.tools.common.model.ui.attribute.editor.IPropertyEditor;
import org.jboss.tools.common.model.ui.attribute.editor.JavaAdapter;
import org.jboss.tools.common.model.ui.attribute.editor.JavaEclipseChoicerEditor;
import org.jboss.tools.common.model.ui.attribute.editor.JavaHyperlinkCueLabelProvider;
import org.jboss.tools.common.model.ui.attribute.editor.StringButtonFieldEditorEx;
import org.jboss.tools.common.model.ui.widgets.IWidgetSettings;
import org.jboss.tools.common.model.ui.wizards.INewClassWizard;
import org.jboss.tools.common.model.ui.wizards.INewClassWizardFactory;
import org.jboss.tools.common.model.ui.wizards.NewClassWizard;
import org.jboss.tools.common.model.ui.wizards.NewTypeWizardAdapter;
import org.jboss.tools.common.model.util.AccessibleJava;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.model.util.ModelFeatureFactory;
import org.jboss.tools.common.model.util.XModelObjectUtil;

public class JavaHyperlinkLineFieldEditor
extends StringButtonFieldEditorEx
implements JavaHyperlinkCueLabelProvider.JavaClassHolder {
    private IProject project;
    private String publicId;
    private String xPath;
    AccessibleJava.IContextPackageProvider cpp = null;
    boolean classExists;
    String textCache = null;
    long timeStamp = -1L;

    public JavaHyperlinkLineFieldEditor() {
    }

    public JavaHyperlinkLineFieldEditor(IWidgetSettings settings) {
        super(settings);
    }

    public void setContextPackageProvider(AccessibleJava.IContextPackageProvider cpp) {
        this.cpp = cpp;
    }

    @Override
    public void setPropertyEditor(IPropertyEditor propertyEditor) {
        super.setPropertyEditor(propertyEditor);
        if (propertyEditor != null) {
            this.valueProvider = (IValueProvider)propertyEditor.getAdapter(IValueProvider.class);
            if (this.valueProvider instanceof DefaultValueAdapter && ((DefaultValueAdapter)this.valueProvider).getModel() != null) {
                XAttribute attr;
                IProject project;
                XModelObject xmo = FileSystemsHelper.getFileSystems((XModel)((DefaultValueAdapter)this.valueProvider).getModel());
                if (xmo != null && (project = (IProject)xmo.getModel().getProperties().get("project")) != null) {
                    this.project = project;
                }
                if ((xmo = ((DefaultValueAdapter)this.valueProvider).getModelObject()) != null) {
                    this.publicId = XModelObjectUtil.getDocumentPublicID((XModelObject)xmo);
                }
                if ((attr = ((DefaultValueAdapter)this.valueProvider).getAttribute()) != null) {
                    this.xPath = XModelObjectUtil.getXMLLocalPath((XAttribute)attr);
                    AccessibleJava.IContextPackageProvider cpp = this.getPackageProvider();
                    if (cpp != null) {
                        this.setContextPackageProvider(cpp);
                    }
                }
            }
            this.valueProvider.addValueChangeListener(this);
            this.valueChangeListener = (IValueChangeListener)propertyEditor.getAdapter(IValueChangeListener.class);
            if (this.project != null) {
                this.setLabelAction((IAction)new OpenJavaEditorAction());
                this.setChangeButtonText(JFaceResources.getString((String)"openBrowse"));
            }
        }
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    @Override
    protected void valueChanged() {
        String text;
        super.valueChanged();
        if (this.getTextField() != null && (text = this.getTextField().getText()) != null && text.length() > 0 && this.getLabelAction() != null) {
            this.getLabelAction().setEnabled(Boolean.TRUE.booleanValue());
            return;
        }
        if (this.getLabelAction() != null) {
            this.getLabelAction().setEnabled(Boolean.TRUE.booleanValue());
        }
    }

    @Override
    protected Control createTextChangeControl(Composite parent) {
        Control control = super.createTextChangeControl(parent);
        if (this.getLabelAction() != null) {
            this.getLabelAction().setEnabled(Boolean.TRUE.booleanValue());
        }
        return control;
    }

    @Override
    public Control createTextControl(Composite parent) {
        Control control = super.createTextControl(parent);
        Text text = this.getTextField();
        text.setData("JavaHyperlinkLineFieldEditor", (Object)this);
        return control;
    }

    @Override
    public boolean canCreateClass() {
        String text;
        String string = this.getTextField() != null ? this.getTextField().getText() : (text = this.valueProvider != null ? this.valueProvider.getStringValue(true) : null);
        if (text == null) {
            return false;
        }
        if (text.length() == 0) {
            return true;
        }
        int i = 0;
        while (i < text.length()) {
            char ch = text.charAt(i);
            if (ch != '.' && !Character.isJavaIdentifierPart(ch)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean classExists() {
        String text;
        String string = this.getTextField() != null ? this.getTextField().getText() : (text = this.valueProvider != null ? this.valueProvider.getStringValue(true) : null);
        if (text == null || text.length() == 0) {
            return false;
        }
        JavaAdapter javaAdapter = JavaAdapter.getInstance();
        if (text.equals(this.textCache) && this.timeStamp == javaAdapter.lastTimeChange) {
            return this.classExists;
        }
        javaAdapter.init(this.project, this.publicId, this.xPath, text);
        this.timeStamp = javaAdapter.lastTimeChange;
        this.textCache = text;
        this.classExists = javaAdapter.getJavaElement() != null;
        return this.classExists;
    }

    @Override
    protected String getHyperlinkLableToolTip() {
        return this.classExists() ? "Open" : "Create";
    }

    private AccessibleJava.IContextPackageProvider getPackageProvider() {
        IModelPropertyEditorAdapter adapter = (IModelPropertyEditorAdapter)this.propertyEditor.getInput();
        XAttribute a = adapter.getAttribute();
        if (a == null) {
            return null;
        }
        String cls = a.getProperty("contextPackageProvider");
        if (cls == null || cls.length() == 0) {
            return null;
        }
        try {
            AccessibleJava.IContextPackageProvider o = (AccessibleJava.IContextPackageProvider)ModelFeatureFactory.getInstance().createFeatureInstance(cls);
            if (o != null) {
                o.setObject(((DefaultValueAdapter)adapter).getModelObject());
            }
            return o;
        }
        catch (ClassCastException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
            return null;
        }
    }

    private IJavaSearchScope getScope(String javaProjectName) {
        IJavaElement[] elements = new IJavaElement[]{};
        if (javaProjectName != null) {
            Path path = new Path(javaProjectName);
            IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
            IProject proj = res.getProject();
            IJavaProject jproject = JavaCore.create((IProject)proj);
            IPackageFragmentRoot fCurrRoot = jproject.getPackageFragmentRoot(res);
            elements = new IJavaElement[]{fCurrRoot.getJavaProject()};
        } else {
            IProject[] ps = ModelPlugin.getWorkspace().getRoot().getProjects();
            ArrayList<IJavaProject> l = new ArrayList<IJavaProject>();
            int i = 0;
            while (i < ps.length) {
                if (EclipseResourceUtil.getJavaProject((IProject)ps[i]) != null) {
                    l.add(JavaCore.create((IProject)ps[i]));
                }
                ++i;
            }
            elements = l.toArray(new IJavaElement[0]);
        }
        return SearchEngine.createJavaSearchScope((IJavaElement[])elements);
    }

    public Object callExternal(Shell shell) {
        if (this.propertyEditor instanceof JavaEclipseChoicerEditor) {
            return ((JavaEclipseChoicerEditor)this.propertyEditor).callExternal(shell);
        }
        return null;
    }

    class OpenJavaEditorAction
    extends Action {
        OpenJavaEditorAction() {
        }

        public void run() {
            String text = JavaHyperlinkLineFieldEditor.this.getTextField().getText();
            JavaAdapter javaAdapter = JavaAdapter.getInstance();
            javaAdapter.init(JavaHyperlinkLineFieldEditor.this.project, JavaHyperlinkLineFieldEditor.this.publicId, JavaHyperlinkLineFieldEditor.this.xPath, text);
            IJavaElement javaElement = javaAdapter.getJavaElement();
            if (javaElement == null) {
                NewTypeWizardAdapter wizardAdapter = new NewTypeWizardAdapter(JavaHyperlinkLineFieldEditor.this.project);
                wizardAdapter.setRawClassName(javaAdapter.getClassName());
                wizardAdapter.setRawPackageName(javaAdapter.getPackageName());
                String superClassName = javaAdapter.getSuperClass();
                String[] interfacesName = javaAdapter.getInterfacees();
                wizardAdapter.setRawSuperClassName(superClassName);
                if (interfacesName != null && interfacesName.length > 0) {
                    int i = 0;
                    while (i < interfacesName.length) {
                        wizardAdapter.addRawInterfaceName(interfacesName[i]);
                        ++i;
                    }
                }
                INewClassWizard wizard = null;
                XAttribute a = ((DefaultValueAdapter)JavaHyperlinkLineFieldEditor.this.getPropertyEditor().getInput()).getAttribute();
                if (a != null) {
                    String cls = a.getProperty("newWizardClass");
                    if (cls != null && cls.length() > 0) {
                        wizard = (INewClassWizard)ModelFeatureFactory.getInstance().createFeatureInstance(cls);
                    } else {
                        cls = a.getProperty("newWizardClassFactory");
                        if (cls != null && cls.length() > 0) {
                            INewClassWizardFactory factory = (INewClassWizardFactory)ModelFeatureFactory.getInstance().createFeatureInstance(cls);
                            wizard = factory.createWizard(((DefaultValueAdapter)JavaHyperlinkLineFieldEditor.this.getPropertyEditor().getInput()).getModelObject(), a);
                        }
                    }
                }
                if (wizard == null) {
                    wizard = new NewClassWizard();
                }
                if (wizard instanceof IWorkbenchWizard) {
                    ((IWorkbenchWizard)wizard).init(ModelUIPlugin.getDefault().getWorkbench(), (IStructuredSelection)new StructuredSelection());
                }
                wizard.setAdapter(wizardAdapter);
                WizardDialog dialog = new WizardDialog(ModelUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
                dialog.create();
                int result = dialog.open();
                if (result == 0) {
                    String newValue = wizard.getQualifiedClassName();
                    JavaHyperlinkLineFieldEditor.this.valueProvider.setValue(newValue);
                    if (wizard.getContainer() != null) {
                        wizard.performFinish();
                    }
                }
                if (dialog.getShell() != null && !dialog.getShell().isDisposed()) {
                    dialog.close();
                }
            } else {
                try {
                    JavaUI.openInEditor((IJavaElement)javaElement);
                }
                catch (CoreException e) {
                    ModelUIPlugin.getPluginLog().logError((Throwable)e);
                }
            }
        }
    }
}

