/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.attribute.editor;

import java.beans.PropertyChangeListener;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.IValueChangeListener;
import org.jboss.tools.common.model.ui.IValueProvider;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.attribute.adapter.DefaultValueAdapter;
import org.jboss.tools.common.model.ui.attribute.editor.ExtendedFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IPropertyEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IPropertyFieldEditor;
import org.jboss.tools.common.model.ui.widgets.BorderedControl;
import org.jboss.tools.common.model.ui.widgets.IWidgetSettings;
import org.jboss.tools.common.model.ui.widgets.ScrolledComposite;
import org.jboss.tools.common.model.ui.widgets.border.Border;
import org.jboss.tools.common.util.SwtUtil;

public class NoteFieldEditor
extends ExtendedFieldEditor
implements IFieldEditor,
IPropertyFieldEditor,
IPropertyChangeListener,
PropertyChangeListener {
    protected IPropertyEditor propertyEditor;
    protected IValueChangeListener valueChangeListener;
    protected IValueProvider valueProvider;
    public static final int VALIDATE_ON_KEY_STROKE = 0;
    public static final int VALIDATE_ON_FOCUS_LOST = 1;
    public static int UNLIMITED = -1;
    private boolean isValid;
    protected String stringValue;
    private String oldValue;
    private Text textField;
    private int widthInChars = UNLIMITED;
    private int textLimit = UNLIMITED;
    private String errorMessage;
    private int validateStrategy = 0;

    public NoteFieldEditor() {
    }

    public NoteFieldEditor(IWidgetSettings settings) {
        super(settings);
    }

    public NoteFieldEditor(String name, String labelText, int width, int strategy, Composite parent) {
        this.init(name, labelText);
        this.widthInChars = width;
        this.setValidateStrategy(strategy);
        this.isValid = false;
        this.errorMessage = JFaceResources.getString((String)"StringFieldEditor.errorMessage");
        this.createControl(parent);
    }

    public NoteFieldEditor(String name, String labelText, int width, Composite parent) {
        this(name, labelText, width, 0, parent);
    }

    public NoteFieldEditor(String name, String labelText, Composite parent) {
        this(name, labelText, UNLIMITED, parent);
    }

    @Override
    protected void adjustForNumColumns(int numColumns) {
        GridData d = (GridData)this.textField.getLayoutData();
        d.grabExcessHorizontalSpace = d.horizontalSpan == 1;
        d.horizontalSpan = numColumns - 1;
    }

    protected boolean checkState() {
        return true;
    }

    protected boolean doCheckState() {
        return true;
    }

    public void fillIntoGrid(Composite parent, int numColumns) {
        Assert.isTrue((boolean)(parent.getLayout() instanceof GridLayout));
        this.doFillIntoGrid(parent, numColumns);
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Control control = this.getLabelComposite(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns;
        gd.verticalAlignment = 1024;
        control.setLayoutData((Object)gd);
        this.textField = this.createTextControl(parent);
        gd = new GridData(1808);
        gd.horizontalSpan = numColumns;
        if (this.widthInChars != UNLIMITED) {
            GC gc = new GC((Drawable)this.textField);
            try {
                Point extent = gc.textExtent("X");
                int ext = extent.x;
                if (ext > 30) {
                    ext = 30;
                }
                gd.widthHint = this.widthInChars * ext;
            }
            finally {
                gc.dispose();
            }
        } else {
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
        }
        this.textField.setLayoutData((Object)gd);
    }

    protected void doLoad() {
        if (this.textField != null) {
            String value = this.getPreferenceStore().getString(this.getPreferenceName());
            this.textField.setText(value);
            this.oldValue = this.getTextFieldValue();
        }
    }

    protected void doLoadDefault() {
        if (this.textField != null) {
            String value = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
            this.textField.setText(value);
        }
        this.valueChanged();
    }

    protected void doStore() {
        this.getPreferenceStore().setValue(this.getPreferenceName(), this.getTextFieldValue());
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int getNumberOfControls() {
        return 2;
    }

    public String getStringValue() {
        if (this.textField != null) {
            return this.getTextFieldValue();
        }
        if (this.stringValue != null) {
            return this.stringValue;
        }
        return this.getPreferenceStore().getString(this.getPreferenceName());
    }

    protected Text getTextControl() {
        return this.textField;
    }

    public Text createTextControl(Composite parent) {
        if (this.textField == null) {
            int style = this.getSettings().getStyle("Note.Style");
            if (style == -1) {
                style = 0;
            }
            Color bg = this.getSettings().getColor("Note.Background");
            Color fg = this.getSettings().getColor("Note.Foreground");
            Font font = this.getSettings().getFont("Note.Font");
            Border border = this.getSettings().getBorder("Note.Border");
            this.validateStrategy = this.getSettings().getInt("Note.ValidateStrategy");
            if (this.validateStrategy == -1) {
                this.validateStrategy = 0;
            }
            boolean b = this.isAlwaysReadOnly();
            if (border != null) {
                if (b) {
                    style |= 8;
                }
                BorderedControl borderedControl = new BorderedControl(parent, 0, border);
                this.textField = new Text((Composite)borderedControl, style);
            } else {
                if (b) {
                    // empty if block
                }
                this.textField = new Text(parent, style);
            }
            this.textField.getAccessible();
            if (this.propertyEditor.getInput() instanceof DefaultValueAdapter) {
                String s;
                DefaultValueAdapter a = (DefaultValueAdapter)this.propertyEditor.getInput();
                String string = s = a.getAttribute() == null ? null : a.getAttribute().getProperty("font");
                if (s != null) {
                    Font oldFont = this.textField.getFont();
                    FontData data = oldFont.getFontData()[0];
                    data.setName(s);
                    try {
                        font = new Font(null, data);
                        this.textField.setFont(font);
                        SwtUtil.bindDisposal((Resource)font, (Widget)this.textField);
                    }
                    catch (SWTException e) {
                        ModelUIPlugin.getPluginLog().logError((Throwable)e);
                    }
                }
            }
            this.textField.setBackground(bg);
            this.textField.setForeground(fg);
            if (this.stringValue != null) {
                this.textField.setText(this.getStringValue());
            }
            switch (this.validateStrategy) {
                case 0: {
                    this.textField.addModifyListener(new ModifyListener(){

                        public void modifyText(ModifyEvent e) {
                            NoteFieldEditor.this.valueChanged();
                        }
                    });
                    this.textField.addFocusListener((FocusListener)new FocusAdapter(){

                        public void focusGained(FocusEvent e) {
                            NoteFieldEditor.this.refreshValidState();
                        }

                        public void focusLost(FocusEvent e) {
                            NoteFieldEditor.this.clearErrorMessage();
                        }
                    });
                    break;
                }
                case 1: {
                    this.textField.addKeyListener((KeyListener)new KeyAdapter(){

                        public void keyPressed(KeyEvent e) {
                            NoteFieldEditor.this.clearErrorMessage();
                        }
                    });
                    this.textField.addFocusListener((FocusListener)new FocusAdapter(){

                        public void focusGained(FocusEvent e) {
                            NoteFieldEditor.this.refreshValidState();
                        }

                        public void focusLost(FocusEvent e) {
                            NoteFieldEditor.this.valueChanged();
                            NoteFieldEditor.this.clearErrorMessage();
                        }
                    });
                    this.textField.addModifyListener(new ModifyListener(){

                        public void modifyText(ModifyEvent e) {
                            DefaultValueAdapter a;
                            XModelObject object;
                            if (NoteFieldEditor.this.textField == null || NoteFieldEditor.this.textField.isDisposed()) {
                                return;
                            }
                            String newValue = NoteFieldEditor.this.getTextFieldValue();
                            Object o = NoteFieldEditor.this.propertyEditor.getInput();
                            if (o instanceof DefaultValueAdapter && (object = (a = (DefaultValueAdapter)o).getModelObject()) != null && object.isObjectEditable()) {
                                String oldValue = object.getAttributeValue(a.getAttribute().getName());
                                if (oldValue != null) {
                                    oldValue = NoteFieldEditor.this.removeRSymbol(oldValue);
                                }
                                if (oldValue != null && !oldValue.equals(newValue)) {
                                    object.setModified(true);
                                }
                            }
                        }
                    });
                    break;
                }
                default: {
                    Assert.isTrue((boolean)false, (String)"Unknown validate strategy");
                }
            }
            this.textField.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                    if (NoteFieldEditor.this.textField == null || NoteFieldEditor.this.textField.isDisposed()) {
                        return;
                    }
                    ScrolledComposite.scrollToVisible((Control)NoteFieldEditor.this.textField, new Rectangle(0, 0, 100, ((NoteFieldEditor)NoteFieldEditor.this).textField.getBounds().height));
                }

                public void focusLost(FocusEvent e) {
                }
            });
            this.textField.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    NoteFieldEditor.this.textField = null;
                }
            });
            if (this.textLimit > 0) {
                this.textField.setTextLimit(this.textLimit);
            } else {
                this.textField.setTextLimit(Text.LIMIT);
            }
        } else {
            this.checkParent((Control)this.textField, parent);
        }
        this.init();
        return this.textField;
    }

    public boolean isValid() {
        return this.isValid;
    }

    protected void refreshValidState() {
        this.isValid = this.checkState();
    }

    public void setErrorMessage(String message) {
        this.errorMessage = message;
    }

    public void setFocus() {
        if (this.textField != null) {
            this.textField.setFocus();
        }
    }

    public void setStringValue(String value) {
        value = this.stringValue = this.removeRSymbol(value);
        if (this.textField != null) {
            if (value == null) {
                value = "";
            }
            this.oldValue = this.getTextFieldValue();
            if (!this.oldValue.equals(value)) {
                this.textField.setText(value);
                this.valueChanged();
            }
        }
    }

    public void setTextLimit(int limit) {
        this.textLimit = limit;
        if (this.textField != null) {
            this.textField.setTextLimit(limit);
        }
    }

    public void setValidateStrategy(int value) {
        Assert.isTrue((value == 1 || value == 0 ? 1 : 0) != 0);
        this.validateStrategy = value;
    }

    public void showErrorMessage() {
        this.showErrorMessage(this.errorMessage);
    }

    protected void valueChanged() {
        String newValue;
        this.setPresentsDefaultValue(false);
        boolean oldState = this.isValid;
        this.refreshValidState();
        if (this.isValid != oldState) {
            this.fireStateChanged("field_editor_is_valid", oldState, this.isValid);
        }
        if (!(newValue = this.getTextFieldValue()).equals(this.oldValue)) {
            this.fireValueChanged("field_editor_value", this.oldValue, newValue);
            java.beans.PropertyChangeEvent event = new java.beans.PropertyChangeEvent(this, "value", this.oldValue, newValue);
            this.valueChangeListener.valueChange(event);
            this.oldValue = newValue;
        }
    }

    private String getTextFieldValue() {
        String v = this.textField.getText();
        return this.removeRSymbol(v);
    }

    private String removeRSymbol(String v) {
        if (v == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < v.length()) {
            char c = v.charAt(i);
            if (c != '\r' || i + 1 < v.length() && v.charAt(i + 1) != '\n') {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    public void setValueChangeListener(IValueChangeListener valueChangeListener) {
        this.valueChangeListener = valueChangeListener;
    }

    public void setValueProvider(IValueProvider valueProvider) {
        this.valueProvider = valueProvider;
    }

    protected void init() {
        this.setStringValue(this.valueProvider.getStringValue(true));
        this.setPropertyChangeListener(this);
    }

    @Override
    public void setPropertyEditor(IPropertyEditor propertyEditor) {
        this.propertyEditor = propertyEditor;
        if (propertyEditor != null) {
            this.valueProvider = (IValueProvider)propertyEditor.getAdapter(IValueProvider.class);
            this.valueChangeListener = (IValueChangeListener)propertyEditor.getAdapter(IValueChangeListener.class);
        }
        this.init();
        this.valueProvider.addValueChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("field_editor_value".equals(event.getProperty())) {
            this.setPropertyChangeListener(null);
            java.beans.PropertyChangeEvent e = new java.beans.PropertyChangeEvent(this, "IPropertyEditor.value", event.getOldValue(), event.getNewValue());
            this.valueChangeListener.valueChange(e);
            this.setPropertyChangeListener(this);
        }
    }

    @Override
    public Control[] getControls(Composite parent) {
        return new Control[]{this.getLabelComposite(parent), this.createTextControl(parent)};
    }

    @Override
    public void propertyChange(java.beans.PropertyChangeEvent evt) {
        super.propertyChange(evt);
        this.valueProvider.removeValueChangeListener(this);
        if ("IPropertyEditor.value".equals(evt.getPropertyName())) {
            this.setStringValue(this.valueProvider.getStringValue(true));
        }
        this.valueProvider.addValueChangeListener(this);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.textField != null && !this.textField.isDisposed()) {
            this.textField.setEditable(enabled);
        } else if (this.getTextControl() != null && !this.getTextControl().isDisposed()) {
            boolean e = this.isAlwaysReadOnly();
            this.getTextControl().setEnabled(enabled || e);
        }
    }

    @Override
    public void cut() {
        if (this.textField != null && this.textField.isFocusControl()) {
            this.textField.cut();
            this.valueChanged();
        }
    }

    @Override
    public void copy() {
        if (this.textField != null && this.textField.isFocusControl()) {
            this.textField.copy();
        }
    }

    @Override
    public void paste() {
        if (this.textField != null && this.textField.isFocusControl()) {
            this.textField.paste();
            this.valueChanged();
        }
    }

    @Override
    public void delete() {
    }

    /*
     * Unable to fully structure code
     */
    protected boolean isAlwaysReadOnly() {
        block4: {
            if (this.propertyEditor == null) {
                return false;
            }
            input = this.propertyEditor.getInput();
            if (!(input instanceof DefaultValueAdapter)) break block4;
            a = (DefaultValueAdapter)input;
            o = a.getModelObject();
            if (o != null && !o.isObjectEditable()) ** GOTO lbl10
            return false;
lbl-1000:
            // 1 sources

            {
                o = o.getParent();
lbl10:
                // 2 sources

                ** while (o != null && o.getFileType() < 2)
            }
lbl11:
            // 1 sources

            if (o == null) {
                return false;
            }
            entity = o.getModelEntity().getName();
            if (entity.indexOf("Jar") >= 0) {
                return true;
            }
        }
        return false;
    }
}

