/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.attribute.editor;

import java.beans.PropertyChangeListener;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Slider;
import org.jboss.tools.common.model.ui.IAttributeErrorProvider;
import org.jboss.tools.common.model.ui.IValueChangeListener;
import org.jboss.tools.common.model.ui.IValueProvider;
import org.jboss.tools.common.model.ui.attribute.editor.ExtendedFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IPropertyEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IPropertyFieldEditor;
import org.jboss.tools.common.model.ui.widgets.IWidgetSettings;

public class SliderFieldEditor
extends ExtendedFieldEditor
implements IFieldEditor,
IPropertyFieldEditor,
IPropertyChangeListener,
PropertyChangeListener {
    protected IPropertyEditor propertyEditor;
    protected IValueProvider valueProvider;
    protected IValueChangeListener valueChangeListener;
    private static final String SLIDER_LABEL_DEFAULT_TEXT = "50% / 50% ";
    private static final int MAX_SLIDER_VALUE = 1000;
    private static final int MIN_SLIDER_VALUE = 0;
    private static final int INCREMENT_SLIDER_VALUE = 10;
    private static final int DEFAULT_SLIDER_VALUE = 500;
    private Composite composite = null;
    private Label sliderLabel = null;
    private Slider slider = null;
    private SelectionListener selectionListener = null;
    private int intValue = 0;

    public SliderFieldEditor() {
    }

    public SliderFieldEditor(IWidgetSettings settings) {
        super(settings);
    }

    public SliderFieldEditor(IPropertyEditor propertyEditor) {
        this.propertyEditor = propertyEditor;
    }

    protected void init() {
        try {
            this.intValue = Integer.parseInt(this.valueProvider.getStringValue(true));
        }
        catch (NumberFormatException numberFormatException) {}
        this.setPropertyChangeListener(this);
        this.valueProvider.addValueChangeListener(this);
    }

    @Override
    protected void adjustForNumColumns(int numColumns) {
        if (this.composite != null && this.composite.getLayoutData() != null) {
            ((GridData)this.slider.getLayoutData()).horizontalSpan = numColumns;
        }
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.getLabelComposite(parent);
        Control control = this.createSpinnerControl(parent);
        GridData gd = new GridData(768);
        control.setLayoutData((Object)gd);
    }

    protected void doLoad() {
        if (this.slider != null) {
            this.slider.setSelection(this.getPreferenceStore().getInt(this.getPreferenceName()));
            this.valueChanged();
        }
    }

    protected void doLoadDefault() {
        if (this.slider != null) {
            this.slider.setSelection(this.getPreferenceStore().getDefaultInt(this.getPreferenceName()));
            this.valueChanged();
        }
    }

    protected void doStore() {
        if (this.slider != null) {
            this.getPreferenceStore().setValue(this.getPreferenceName(), this.slider.getSelection());
        }
    }

    public int getNumberOfControls() {
        return 2;
    }

    @Override
    public Control[] getControls(Composite parent) {
        return new Control[]{this.getLabelComposite(parent), this.createSpinnerControl(parent)};
    }

    @Override
    public void setPropertyEditor(IPropertyEditor propertyEditor) {
        this.propertyEditor = propertyEditor;
        if (propertyEditor != null) {
            this.valueProvider = (IValueProvider)propertyEditor.getAdapter(IValueProvider.class);
            this.valueChangeListener = (IValueChangeListener)propertyEditor.getAdapter(IValueChangeListener.class);
            this.setErrorProvider((IAttributeErrorProvider)propertyEditor.getAdapter(IAttributeErrorProvider.class));
        }
        this.init();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("field_editor_value".equals(event.getProperty())) {
            this.setPropertyChangeListener(null);
            java.beans.PropertyChangeEvent e = new java.beans.PropertyChangeEvent(this, "IPropertyEditor.value", event.getOldValue(), event.getNewValue());
            this.valueChangeListener.valueChange(e);
            this.setPropertyChangeListener(this);
        }
    }

    @Override
    public void propertyChange(java.beans.PropertyChangeEvent evt) {
        Object v;
        this.valueProvider.removeValueChangeListener(this);
        if ("IPropertyEditor.value".equals(evt.getPropertyName()) && (v = evt.getNewValue()) != null) {
            this.setStringValue(v.toString());
        }
        this.valueProvider.addValueChangeListener(this);
    }

    protected Control createSpinnerControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 8;
        this.composite.setLayout((Layout)gridLayout);
        GridData gd = new GridData(768);
        this.composite.setLayoutData((Object)gd);
        this.sliderLabel = new Label(this.composite, 0);
        gd = new GridData(16384);
        this.sliderLabel.setLayoutData((Object)gd);
        this.sliderLabel.setText(SLIDER_LABEL_DEFAULT_TEXT);
        Point size = this.sliderLabel.computeSize(-1, -1);
        this.sliderLabel.setSize(size);
        this.slider = new Slider(this.composite, 256);
        gd = new GridData(131840);
        this.slider.setLayoutData((Object)gd);
        this.slider.setMaximum(1000 + this.slider.getThumb());
        this.slider.setMinimum(0);
        this.slider.setIncrement(10);
        this.selectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SliderFieldEditor.this.valueChanged();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.slider.addSelectionListener(this.selectionListener);
        try {
            this.intValue = Integer.parseInt(this.valueProvider.getStringValue(true).toString());
        }
        catch (NumberFormatException numberFormatException) {
            this.intValue = 500;
        }
        this.slider.setSelection(this.intValue);
        String weightsString = this.intValue / 10 + "% / " + (100 - this.intValue / 10) + "%";
        this.slider.setToolTipText(weightsString);
        this.sliderLabel.setText(weightsString);
        this.slider.pack();
        this.sliderLabel.pack();
        return this.composite;
    }

    protected void valueChanged() {
        int newValue = this.slider.getSelection();
        int oldValue = this.intValue;
        this.intValue = newValue;
        java.beans.PropertyChangeEvent event = new java.beans.PropertyChangeEvent(this, "IPropertyEditor.value", oldValue, newValue);
        this.valueChangeListener.valueChange(event);
    }

    private void setStringValue(String stringValue) {
        if (this.slider != null) {
            try {
                this.intValue = Integer.parseInt(stringValue);
                this.slider.setSelection(this.intValue);
                String weightsString = this.intValue / 10 + "% / " + (100 - this.intValue / 10) + "%";
                this.slider.setToolTipText(weightsString);
                if (this.sliderLabel != null) {
                    this.sliderLabel.setText(weightsString);
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    @Override
    public void copy() {
    }

    @Override
    public void cut() {
    }

    @Override
    public void delete() {
    }

    @Override
    public void paste() {
    }
}

