/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.attribute.editor;

import java.beans.PropertyChangeEvent;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.meta.constraint.impl.XAttributeConstraintAList;
import org.jboss.tools.common.meta.key.WizardKeys;
import org.jboss.tools.common.model.ui.IValueChangeListener;
import org.jboss.tools.common.model.ui.IValueProvider;
import org.jboss.tools.common.model.ui.attribute.adapter.DefaultValueAdapter;
import org.jboss.tools.common.model.ui.attribute.editor.ExtendedFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IPropertyFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.PropertyEditor;
import org.jboss.tools.common.model.ui.widgets.IWidgetSettings;

public abstract class ValueEditor
extends PropertyEditor {
    protected CellEditor cellEditor;
    protected ExtendedFieldEditor fieldEditor;

    public ValueEditor() {
    }

    public ValueEditor(IWidgetSettings settings) {
        super(settings);
    }

    @Override
    protected abstract CellEditor createCellEditor(Composite var1);

    @Override
    protected abstract ExtendedFieldEditor createFieldEditor(Composite var1);

    @Override
    public void dispose() {
        super.dispose();
        if (this.cellEditor != null) {
            this.cellEditor.dispose();
        }
        this.cellEditor = null;
        if (this.fieldEditor != null) {
            this.fieldEditor.dispose();
        }
        this.fieldEditor = null;
    }

    @Override
    public CellEditor getCellEditor(Composite parent) {
        if (this.cellEditor == null) {
            this.cellEditor = this.createCellEditor(parent);
            if (this.cellEditor != null) {
                DefaultValueAdapter a;
                IValueProvider valueProvider = (IValueProvider)this.getAdapter(IValueProvider.class);
                Object value = valueProvider.getValue();
                if (this.getInput() instanceof DefaultValueAdapter && (a = (DefaultValueAdapter)this.getInput()).getAttribute().getConstraint() instanceof XAttributeConstraintAList) {
                    value = WizardKeys.getVisualListValue((XAttribute)a.getAttribute(), (String)value.toString());
                }
                this.cellEditor.setValue(value);
            }
        }
        return this.cellEditor;
    }

    @Override
    public ExtendedFieldEditor getFieldEditor(Composite parent) {
        if (this.fieldEditor == null) {
            this.fieldEditor = this.createFieldEditor(parent);
            this.fieldEditor.setLabelText(this.getLabelText());
            if (this.fieldEditor instanceof IPropertyFieldEditor) {
                ((IPropertyFieldEditor)((Object)this.fieldEditor)).setPropertyEditor(this);
            }
            parent.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    ValueEditor.this.fieldEditor = null;
                }
            });
        }
        return this.fieldEditor;
    }

    @Override
    public Object getInput() {
        if (this.input == null) {
            this.setInput(new DefaultValueAdapter());
        }
        return this.input;
    }

    @Override
    public Object getValue() {
        return ((IValueProvider)((IAdaptable)this.getInput()).getAdapter(IValueProvider.class)).getValue();
    }

    @Override
    public void setValue(Object value) {
        PropertyChangeEvent event = new PropertyChangeEvent(this, "IPropertyEditor.value", this.getValue(), value);
        ((IValueChangeListener)((IAdaptable)this.getInput()).getAdapter(IValueChangeListener.class)).valueChange(event);
    }
}

