/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.forms;

import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.forms.DefaultFormContainer;
import org.jboss.tools.common.model.ui.forms.Form;
import org.jboss.tools.common.model.ui.forms.FormRuntimeException;
import org.jboss.tools.common.model.ui.forms.IForm;
import org.jboss.tools.common.model.ui.forms.IFormData;
import org.jboss.tools.common.model.util.ModelFeatureFactory;

public class FormContainer
extends DefaultFormContainer {
    private IFormData formData;

    private FormContainer() {
    }

    public FormContainer(IFormData formData) {
        this.formData = formData;
        this.setHeadingText(formData.getEntityName());
        IForm form = null;
        IFormData[] forms = formData.getForms();
        int i = 0;
        while (i < forms.length) {
            if (!forms[i].isNotLayouredForm()) {
                form = new Form(forms[i]);
            } else {
                try {
                    form = (IForm)ModelFeatureFactory.getInstance().createFeatureInstance(forms[i].getFormClassName());
                }
                catch (ClassCastException e) {
                    ModelUIPlugin.getPluginLog().logError((Throwable)e);
                }
            }
            if (form != null) {
                this.addForm(form);
                form.setParent(this);
            }
            ++i;
        }
    }

    @Override
    public void initialize(Object model) {
        IFormData[] forms = this.formData.getForms();
        String[] entities = this.formData.getEntities();
        if (forms != null && entities != null) {
            XModelObject xmo = (XModelObject)model;
            int i = 0;
            while (i < forms.length) {
                if (forms[i].getEntityName() == null) {
                    this.get(i).initialize(xmo);
                } else {
                    String entity = forms[i].getEntityName();
                    XModelObject child = xmo.getChildByPath(entity);
                    if (child == null) {
                        String message = "Cannot build child form '" + forms[i].getEntityName() + "' for form '" + this.formData.getEntityName() + "'.";
                        FormRuntimeException exc = new FormRuntimeException(message);
                        ModelUIPlugin.getPluginLog().logError((Throwable)exc);
                    } else {
                        this.get(i).initialize(child);
                    }
                }
                ++i;
            }
        } else {
            super.initialize(model);
        }
    }
}

