/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.forms;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.jboss.tools.common.model.ui.forms.DefaultFormContainer;
import org.jboss.tools.common.model.ui.forms.IForm;
import org.jboss.tools.common.model.ui.widgets.IWidgetSettings;
import org.jboss.tools.common.model.ui.widgets.Split;

public class SplitFormContainer
extends DefaultFormContainer {
    int style;
    private IForm firstForm;
    private IForm secondForm;
    private Control control;

    public SplitFormContainer() {
        this.setLayoutData(new GridData(1808));
    }

    public SplitFormContainer(int style) {
        this.style = style;
    }

    public SplitFormContainer(IForm firstForm, IForm secondForm, int style) {
        this.style = style;
        this.firstForm = firstForm;
        this.secondForm = secondForm;
    }

    public SplitFormContainer(IForm firstForm, IForm secondForm) {
        this.style = 256;
        this.firstForm = firstForm;
        this.secondForm = secondForm;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.firstForm != null) {
            this.firstForm.dispose();
        }
        this.firstForm = null;
        if (this.secondForm != null) {
            this.secondForm.dispose();
        }
        this.secondForm = null;
        if (this.control != null && !this.control.isDisposed()) {
            this.control.dispose();
        }
        this.control = null;
    }

    public void setForm(IForm form) {
        this.setFirstForm(form);
    }

    public IForm getForm() {
        return this.getFirstForm();
    }

    public void setExpandable(boolean expandable) {
    }

    public boolean isExpandable() {
        return false;
    }

    @Override
    public void commitChanges(boolean onSave) {
    }

    public Control createFirstForm(Composite parent, IWidgetSettings settings) {
        return this.firstForm.createControl(parent, settings);
    }

    public Control createSecondForm(Composite parent, IWidgetSettings settings) {
        return this.secondForm.createControl(parent, settings);
    }

    @Override
    public Control createControl(Composite parent, IWidgetSettings settings) {
        Composite main = new Composite(parent, settings.getStyle("Composite.Style"));
        settings.setupControl((Control)main);
        main.setLayout(this.getLayout());
        main.setLayoutData(this.getLayoutData());
        Split composite = new Split(main, 256);
        Composite fistFormComposite = new Composite((Composite)composite, settings.getStyle("Composite.Style"));
        settings.setupControl((Control)fistFormComposite);
        fistFormComposite.setLayout(this.getLayout());
        GridData gd = new GridData(1808);
        fistFormComposite.setLayoutData((Object)gd);
        Control firstFormControl = this.createFirstForm(fistFormComposite, settings);
        gd = new GridData(1808);
        firstFormControl.setLayoutData((Object)gd);
        Composite secondFormComposite = new Composite((Composite)composite, settings.getStyle("Composite.Style"));
        settings.setupControl((Control)secondFormComposite);
        secondFormComposite.setLayout(this.getLayout());
        gd = new GridData(1808);
        secondFormComposite.setLayoutData((Object)gd);
        Control secondFormControl = this.createSecondForm(secondFormComposite, settings);
        gd = new GridData(1808);
        secondFormControl.setLayoutData((Object)gd);
        composite.setWeights(new int[]{30, 70});
        composite.setLayoutData(new GridData(1808));
        this.control = main;
        return this.control;
    }

    @Override
    public boolean doGlobalAction(String actionId) {
        boolean result = Boolean.FALSE;
        if (this.firstForm != null) {
            result &= this.firstForm.doGlobalAction(actionId);
        }
        if (this.secondForm != null) {
            result &= this.secondForm.doGlobalAction(actionId);
        }
        return result;
    }

    @Override
    public void expandTo(Object object) {
    }

    @Override
    public Control getControl() {
        return this.control;
    }

    @Override
    public Color getHeadingBackground() {
        return null;
    }

    @Override
    public Color getHeadingForeground() {
        return null;
    }

    @Override
    public Image getHeadingImage() {
        return null;
    }

    @Override
    public String getHeadingText() {
        return "SplitSection";
    }

    @Override
    public void initialize(Object model) {
    }

    @Override
    public boolean isHeadingVisible() {
        return false;
    }

    @Override
    public void setFocus() {
    }

    @Override
    public void setHeadingBackground(Color newHeadingBackground) {
    }

    @Override
    public void setHeadingForeground(Color newHeadingForeground) {
    }

    @Override
    public void setHeadingImage(Image headingImage) {
    }

    @Override
    public void setHeadingVisible(boolean newHeadingVisible) {
    }

    @Override
    public void setHeadingText(String heading) {
    }

    @Override
    public void update() {
    }

    public static void main(String[] args) {
    }

    public IForm getFirstForm() {
        return this.firstForm;
    }

    public IForm getSecondForm() {
        return this.secondForm;
    }

    public void setFirstForm(IForm form) {
        this.firstForm = form;
    }

    public void setSecondForm(IForm form) {
        this.secondForm = form;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.firstForm != null) {
            this.firstForm.setEnabled(enabled);
        }
        if (this.secondForm != null) {
            this.secondForm.setEnabled(enabled);
        }
    }
}

