/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.problem;

import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IconAndMessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.common.model.ui.problem.Problem;
import org.jboss.tools.common.model.ui.problem.ProblemDialogAction;

public class ProblemDialog
extends IconAndMessageDialog {
    private String title;
    private List actions;

    public ProblemDialog(Shell shell, Problem error) {
        super(shell);
        this.setShellStyle(67680);
        this.title = error.getTitle() != null ? error.getTitle() : "";
        this.message = error.getMessage();
        if (error.getLine() != -1) {
            this.message = String.valueOf(this.message) + " at line:" + error.getLine();
        }
        if (error.getColumn() != -1) {
            this.message = String.valueOf(this.message) + " column:" + error.getColumn();
        }
        this.actions = error.getActions();
    }

    protected Image getImage() {
        return Display.getDefault().getSystemImage(1);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    protected Control createDialogArea(Composite parent) {
        return this.createMessageArea(parent);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.actions == null || this.actions.size() == 0) {
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        } else {
            for (ProblemDialogAction action : this.actions) {
                this.createButton(parent, action.getDialogId(), action.getText(), action.isDefault());
            }
        }
    }

    protected void buttonPressed(int buttonId) {
        if (this.actions != null && this.actions.size() > 0) {
            for (ProblemDialogAction action : this.actions) {
                if (buttonId != action.getDialogId()) continue;
                action.run();
            }
        }
        super.buttonPressed(buttonId);
    }

    public int open() {
        return super.open();
    }
}

