/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.problem;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.problem.Problem;
import org.jboss.tools.common.model.ui.problem.ProblemManager;

public class ResourceProblemManager
extends ProblemManager {
    private IResource resource;
    private Map<Problem, IMarker> problemsCache;

    public ResourceProblemManager() {
    }

    public ResourceProblemManager(IResource resource) {
        this.resource = resource;
    }

    @Override
    public Problem addProblem(Problem problem) {
        problem.setLocation(this.resource.getLocation().toOSString());
        super.addProblem(problem);
        return problem;
    }

    public void cache() {
        this.problemsCache = new HashMap<Problem, IMarker>();
        IMarker[] ms = new IMarker[]{};
        if (this.resource != null) {
            try {
                ms = this.resource.findMarkers(null, true, 2);
            }
            catch (CoreException e) {
                ModelUIPlugin.getPluginLog().logError((Throwable)e);
            }
        }
        int i = 0;
        while (i < ms.length) {
            Problem p = this.getProblem(ms[i]);
            int k = this.problems.indexOf(p);
            if (k >= 0) {
                p = (Problem)this.problems.get(k);
            }
            this.problemsCache.put(p, ms[i]);
            ++i;
        }
        this.problems.clear();
    }

    public void commit() {
        Problem[] ps = this.problems.toArray(new Problem[0]);
        int i = 0;
        while (i < ps.length) {
            if (this.problemsCache.containsKey(ps[i])) {
                IMarker m = this.problemsCache.remove(ps[i]);
                int pos_m = m.getAttribute("charStart", -1);
                int pos_i = ps[i].getPosition();
                if (pos_i != pos_m) {
                    try {
                        m.setAttribute("charStart", pos_i);
                        m.setAttribute("charEnd", pos_i + 1);
                    }
                    catch (CoreException e) {
                        ModelUIPlugin.getPluginLog().logError((Throwable)e);
                    }
                }
            } else {
                this.addMarker(ps[i]);
            }
            ++i;
        }
        IMarker[] ms = this.problemsCache.values().toArray(new IMarker[0]);
        int i2 = 0;
        while (i2 < ms.length) {
            try {
                ms[i2].delete();
            }
            catch (CoreException e) {
                ModelUIPlugin.getPluginLog().logError((Throwable)e);
            }
            ++i2;
        }
    }

    private void addMarker(Problem problem) {
        HashMap<String, Object> markerData = new HashMap<String, Object>();
        markerData.put("message", problem.getMessage());
        markerData.put("location", this.resource.getLocation().toOSString());
        markerData.put("lineNumber", problem.getLine());
        markerData.put("severity", 2);
        int position = problem.getPosition();
        if (position != -1) {
            markerData.put("charStart", position);
            markerData.put("charEnd", position + 1);
        }
        this.addMarker(markerData);
    }

    private Problem getProblem(IMarker marker) {
        String message = marker.getAttribute("message", "");
        String location = marker.getAttribute("location", "");
        int line = marker.getAttribute("lineNumber", -1);
        int position = marker.getAttribute("charStart", -1);
        String type = "org.eclipse.core.resources.problemmarker";
        try {
            if (marker.exists()) {
                type = marker.getType();
            }
        }
        catch (CoreException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
        }
        Problem p = new Problem(message, position, line, -1);
        p.setType(type);
        p.setLocation(location);
        return p;
    }

    private void addMarker(HashMap<String, Object> markerData) {
        try {
            MarkerUtilities.createMarker((IResource)this.resource, markerData, (String)"org.eclipse.core.resources.problemmarker");
        }
        catch (CoreException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    public IResource getResource() {
        return this.resource;
    }

    public void setResource(IResource resource) {
        this.resource = resource;
    }
}

