/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.templates.preferences;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.ui.attribute.adapter.ColumnDescription;
import org.jboss.tools.common.model.ui.attribute.adapter.CompositeActionProvider;
import org.jboss.tools.common.model.ui.attribute.adapter.DefaultTableStructuredAdapter;
import org.jboss.tools.common.model.ui.attribute.adapter.DefaultValueAdapter;
import org.jboss.tools.common.model.ui.attribute.editor.IFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.JavaEclipseChoicerEditor;
import org.jboss.tools.common.model.ui.attribute.editor.PropertyEditor;
import org.jboss.tools.common.model.ui.attribute.editor.StringButtonFieldEditorEx;
import org.jboss.tools.common.model.ui.attribute.editor.TableStructuredEditor;
import org.jboss.tools.common.model.ui.templates.model.MetaClassTemplate;
import org.jboss.tools.common.model.ui.templates.model.MetaValue;
import org.jboss.tools.common.model.ui.templates.preferences.AddInterfaceSupport;
import org.jboss.tools.common.model.ui.templates.preferences.Messages;
import org.jboss.tools.common.model.ui.templates.preferences.TableLabelProvider;

public class ClassTemplateComponent {
    XModel model;
    Label xPathLabelValue;
    String initValue = "";
    JavaEclipseChoicerEditor baseClassEditor;
    BaseClassAdapter baseClassAdapter;
    BaseClassAdapterListener baseClassAdapterListener;
    TableStructuredEditor interfacesEditor;
    DefaultTableStructuredAdapter interfacesAdapter;
    CompositeActionProvider interfaceActions;
    MetaClassTemplate selectedTemplate = null;
    Composite composite;

    protected Control createContents(Composite composite) {
        this.composite = composite;
        GridData gd = new GridData(768);
        Label xPathLabel = new Label(composite, 0);
        xPathLabel.setLayoutData((Object)gd);
        xPathLabel.setText(Messages.ClassTemplateComponent_XPATH);
        gd = new GridData(768);
        this.xPathLabelValue = new Label(composite, 0);
        this.xPathLabelValue.setLayoutData((Object)gd);
        this.xPathLabelValue.setText(this.initValue);
        this.baseClassEditor.setLabelText(Messages.ClassTemplateComponent_LABEL_BASECLASS);
        StringButtonFieldEditorEx sb = new StringButtonFieldEditorEx();
        sb.setLabelText(this.baseClassEditor.getLabelText());
        sb.setPropertyEditor(this.baseClassEditor);
        String changeButtonName = this.baseClassEditor.getChangeButtonName();
        if (changeButtonName != null) {
            sb.setChangeButtonText(changeButtonName);
        }
        Control[] control = sb.getControls(composite);
        gd = new GridData(768);
        control[1].setLayoutData((Object)gd);
        this.interfacesEditor.setLabelText(Messages.ClassTemplateComponent_LABEL_INTERFACES);
        control = this.getControls(composite, this.interfacesEditor);
        control[0].dispose();
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        control[1].setLayoutData((Object)gd);
        return composite;
    }

    public void setModel(XModel model) {
        this.model = model;
        this.baseClassEditor = new JavaEclipseChoicerEditor();
        this.baseClassAdapter = new BaseClassAdapter();
        this.baseClassAdapter.setModel(model);
        this.baseClassAdapterListener = new BaseClassAdapterListener();
        this.baseClassAdapter.addValueChangeListener(this.baseClassAdapterListener);
        this.baseClassEditor.setInput(this.baseClassAdapter);
        this.interfacesEditor = new TableStructuredEditor();
        this.interfacesAdapter = new DefaultTableStructuredAdapter();
        this.interfaceActions = new ActionProvider();
        this.interfacesAdapter.setActionProvider(this.interfaceActions);
        this.interfacesAdapter.addColumnDescription(new ColumnDescription(Messages.ClassTemplateComponent_COLUMN_INTERFACES, null, 100, 16384, true, null));
        this.interfacesAdapter.setTableLabelProvider(new TableLabelProvider());
        this.interfacesEditor.setInput(this.interfacesAdapter);
    }

    private void addInterface() {
        if (this.selectedTemplate == null) {
            return;
        }
        String s = AddInterfaceSupport.runAdd(this.model);
        if (s == null) {
            return;
        }
        String[] vs = this.selectedTemplate.getInterfaces().getValues();
        if (vs == null) {
            vs = new String[]{};
        }
        String[] vsn = new String[vs.length + 1];
        System.arraycopy(vs, 0, vsn, 0, vs.length);
        vsn[vs.length] = s;
        this.selectedTemplate.getInterfaces().setValues(vsn);
        this.interfacesAdapter.setValue(this.selectedTemplate.getInterfaces().getValues());
    }

    private void removeInterface() {
        if (this.selectedTemplate == null) {
            return;
        }
        ISelection s = this.interfacesAdapter.getSelection();
        if (s.isEmpty()) {
            return;
        }
        ArrayList<String> l = new ArrayList<String>();
        Object[] vs = this.selectedTemplate.getInterfaces().getValues();
        if (vs == null) {
            return;
        }
        if (vs != null) {
            int i = 0;
            while (i < vs.length) {
                l.add(vs[i]);
                ++i;
            }
        }
        Iterator i = ((StructuredSelection)s).iterator();
        while (i.hasNext()) {
            l.remove(i.next());
        }
        if (l.size() == vs.length) {
            return;
        }
        vs = l.toArray(new String[0]);
        this.selectedTemplate.getInterfaces().setValues((String[])vs);
        this.interfacesAdapter.setValue(vs);
    }

    private void editInterface() {
        if (this.selectedTemplate == null) {
            return;
        }
        ISelection s = this.interfacesAdapter.getSelection();
        if (s.isEmpty()) {
            return;
        }
        String current = ((StructuredSelection)s).getFirstElement().toString();
        ArrayList<String> l = new ArrayList<String>();
        String[] vs = this.selectedTemplate.getInterfaces().getValues();
        if (vs == null) {
            vs = new String[]{};
        }
        int i = 0;
        while (i < vs.length) {
            l.add(vs[i]);
            ++i;
        }
        int index = l.indexOf(current);
        String v = AddInterfaceSupport.runEdit(this.model, current);
        if (v == null || v.equals(current)) {
            return;
        }
        l.set(index, v);
        vs = l.toArray(new String[0]);
        this.selectedTemplate.getInterfaces().setValues(vs);
        this.interfacesAdapter.setValue(this.selectedTemplate.getInterfaces().getValues());
    }

    private Control[] getControls(Composite composite, PropertyEditor editor) {
        return ((IFieldEditor)((Object)editor.getFieldEditor(composite))).getControls(composite);
    }

    public void setSelectedTemplate(MetaClassTemplate selectedTemplate) {
        boolean enabled;
        this.selectedTemplate = selectedTemplate;
        if (selectedTemplate == null) {
            if (this.xPathLabelValue != null) {
                this.xPathLabelValue.setText("");
            } else {
                this.initValue = "";
            }
            this.baseClassAdapter.value = null;
            this.baseClassAdapterListener.value = null;
            this.interfacesAdapter.setValue(null);
        } else {
            if (this.xPathLabelValue != null) {
                this.xPathLabelValue.setText(selectedTemplate.getAxis());
            } else {
                this.initValue = selectedTemplate.getAxis();
            }
            MetaValue v = selectedTemplate.getSuperClass();
            this.baseClassAdapterListener.value = null;
            this.baseClassAdapter.value = v;
            this.baseClassAdapter.load();
            this.baseClassAdapterListener.value = v;
            this.interfacesAdapter.setValue(selectedTemplate.getInterfaces().getValues());
        }
        boolean bl = enabled = selectedTemplate != null;
        if (this.composite != null) {
            this.baseClassEditor.getFieldEditor(this.composite).setEnabled(enabled);
            this.interfacesEditor.getFieldEditor(this.composite).setEnabled(enabled);
        }
    }

    class ActionProvider
    extends CompositeActionProvider {
        IAction addAction = new Action(Messages.ClassTemplateComponent_ADD){

            public void run() {
                ClassTemplateComponent.this.addInterface();
            }
        };
        IAction removeAction = new Action(Messages.ClassTemplateComponent_REMOVE){

            public void run() {
                ClassTemplateComponent.this.removeInterface();
            }
        };
        IAction editAction = new Action(Messages.ClassTemplateComponent_EDIT){

            public void run() {
                ClassTemplateComponent.this.editInterface();
            }
        };

        public ActionProvider() {
            this.addAction(this.addAction);
            this.addAction(this.removeAction);
            this.addAction(this.editAction);
        }

        @Override
        public void update(ISelection selection) {
            this.removeAction.setEnabled(!selection.isEmpty());
            this.editAction.setEnabled(!selection.isEmpty());
        }
    }

    class BaseClassAdapter
    extends DefaultValueAdapter {
        MetaValue value;

        BaseClassAdapter() {
        }

        @Override
        public void load() {
            if (this.value == null) {
                this.setValue("");
            } else {
                String v = this.value.getValue();
                if (v == null) {
                    v = "java.lang.Object";
                }
                this.setValue(v);
            }
        }

        @Override
        public void store() {
            if (this.isStoreLocked()) {
                return;
            }
            if (this.value != null) {
                this.value.setValue(this.getStringValue(true));
            }
        }
    }

    class BaseClassAdapterListener
    implements PropertyChangeListener {
        MetaValue value;

        BaseClassAdapterListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (this.value != null) {
                ClassTemplateComponent.this.baseClassAdapter.store();
            }
        }
    }
}

