/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.texteditors;

import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.texteditor.IAbstractTextEditorHelpContextIds;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProviderExtension;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.jboss.tools.common.editor.ObjectTextEditor;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.impl.DiscardFileHandler;
import org.jboss.tools.common.model.filesystems.impl.FolderImpl;
import org.jboss.tools.common.model.filesystems.impl.FolderLoader;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.editor.IModelObjectEditorInput;
import org.jboss.tools.common.model.ui.messages.UIMessages;
import org.jboss.tools.common.model.ui.texteditors.ITextProvider;
import org.jboss.tools.common.model.ui.texteditors.RevertToSavedAction2;
import org.jboss.tools.common.model.ui.texteditors.SaveAction2;
import org.jboss.tools.common.model.ui.texteditors.TextEditorSupport;
import org.jboss.tools.common.model.ui.texteditors.TextMerge;
import org.jboss.tools.common.model.ui.texteditors.XMLModelObjectFinder;
import org.jboss.tools.common.model.ui.texteditors.xmleditor.XMLTextEditor;
import org.jboss.tools.common.model.util.PositionSearcher;

public class XMLTextEditorComponent
extends XMLTextEditor
implements ObjectTextEditor,
ITextProvider {
    protected TextEditorSupport support = this.createSupport();
    protected boolean isObjectNull = false;
    private ICL changeListener = null;
    protected boolean isStandAlone = false;
    boolean isNullEditor = false;
    private int textChangedLock = 0;
    boolean isUpdating = false;
    XMLModelObjectFinder modelObjectFinder = new XMLModelObjectFinder();

    public XMLTextEditorComponent() {
        this(true);
    }

    public XMLTextEditorComponent(boolean useUseRHDSConfig) {
        super(useUseRHDSConfig);
        this.support.setProvider(this);
        this.changeListener = new ICL();
        ModelPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.changeListener);
    }

    protected TextEditorSupport createSupport() {
        return new TextEditorSupport();
    }

    public TextEditorSupport getSupport() {
        return this.support;
    }

    @Override
    public void createPartControl(Composite parent) {
        if (this.getModel() == null) {
            this.setObject(null);
            this.isNullEditor = true;
            Label label = new Label(parent, 0);
            label.setText(UIMessages.CANNOT_DISPLAY_DOCUMENT_CONTENTS);
            label.setBackground(Display.getDefault().getSystemColor(1));
            return;
        }
        super.createPartControl(parent);
    }

    @Override
    public void setObject(XModelObject object) {
        if (this.isNullEditor) {
            return;
        }
        boolean bl = this.isObjectNull = object == null;
        if (this.isObjectNull) {
            return;
        }
        this.getDocumentListenerRegister().unregister();
        try {
            this.support.setObject(object);
        }
        finally {
            this.getDocumentListenerRegister().register();
        }
    }

    @Override
    public void updateDocument() {
        this.support.update();
    }

    @Override
    public boolean isDirty() {
        return this.isObjectNull || this.isStandAlone ? super.isDirty() : false;
    }

    @Override
    public String getText() {
        String text = null;
        ISourceViewer sv = this.getSourceViewer();
        if (sv == null) {
            return "";
        }
        IDocument d = sv.getDocument();
        if (d == null) {
            return "";
        }
        text = d.get();
        return text == null ? "" : text;
    }

    public boolean isEditable() {
        return !this.isEditorInputReadOnly();
    }

    public boolean isEditorInputReadOnly() {
        if (!(this.getEditorInput() instanceof IModelObjectEditorInput)) {
            return super.isEditorInputReadOnly();
        }
        IModelObjectEditorInput input = (IModelObjectEditorInput)this.getEditorInput();
        if (input == null || input.getXModelObject() == null) {
            return true;
        }
        XModelObject o = input.getXModelObject();
        return !o.isObjectEditable() && !o.isAttributeEditable("body");
    }

    @Override
    public void setModified(boolean set) {
        if (set == this.support.isModified()) {
            return;
        }
        this.support.setModified(set);
        this.firePropertyChange(257);
    }

    @Override
    public boolean isModified() {
        return this.support.isModified();
    }

    @Override
    public void save() {
        if (this.isStandAlone) {
            super.save();
        } else {
            if (!this.isObjectNull && !this.support.canSave(false)) {
                return;
            }
            if (this.isObjectNull) {
                super.doSave(null);
            } else {
                this.support.save();
            }
        }
    }

    @Override
    protected void doSaveYourself() {
        XModelObject f;
        XModelObject o = this.getModelObject();
        XModelObject xModelObject = f = o == null ? null : o.getParent();
        if (f instanceof FolderImpl) {
            try {
                ((FolderImpl)f).saveChild(o);
            }
            catch (XModelException e) {
                ModelPlugin.getPluginLog().logError((Throwable)e);
            }
        }
    }

    @Override
    public void addFocusListener(FocusListener listener) {
        ISourceViewer sv = this.getSourceViewer();
        if (sv != null) {
            sv.getTextWidget().addFocusListener(listener);
        }
    }

    public void removeFocusListener(FocusListener listener) {
        ISourceViewer sv = this.getSourceViewer();
        if (sv != null) {
            this.getSourceViewer().getTextWidget().removeFocusListener(listener);
        }
    }

    @Override
    public void setCursor(int line, int position) {
        ISourceViewer sv = this.getSourceViewer();
        if (sv == null || sv.getDocument() == null) {
            return;
        }
        try {
            int i = sv.getDocument().getLineOffset(line - 1) + position - 1;
            sv.setSelectedRange(i, 0);
            sv.revealRange(i, 0);
        }
        catch (BadLocationException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
        }
        catch (SWTException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    public void doSaveAs() {
        if (this.isStandAlone) {
            super.doSaveAs();
        }
    }

    public void performSaveAs(IProgressMonitor monitor) {
        XModelObject old = this.getModelObject();
        super.performSaveAs(monitor);
        XModelObject o = this.getModelObject();
        if (o != null) {
            if (o.getParent() instanceof FolderLoader) {
                ((FolderLoader)o.getParent()).update();
                if (!o.isActive()) {
                    o = this.getModelObject();
                }
            }
            if (o != null) {
                this.support.setObject(o);
            }
        }
        if (old.isModified()) {
            try {
                new DiscardFileHandler().executeHandler(old, new Properties());
            }
            catch (XModelException xModelException) {}
        }
    }

    @Override
    public void doSave(IProgressMonitor monitor) {
        if (this.isObjectNull || this.isStandAlone) {
            super.doSave(monitor);
        }
    }

    @Override
    public void textChanged(TextEvent event) {
        if (this.textChangedLock > 0) {
            this.firePropertyChange(257);
        } else {
            ++this.support.lock;
            try {
                this.setModified(true);
            }
            finally {
                --this.support.lock;
            }
        }
    }

    @Override
    public void setText(String text) {
        ++this.textChangedLock;
        try {
            if (this.getSourceViewer() == null || this.getSourceViewer().getDocument() == null) {
                return;
            }
            String txt = this.getSourceViewer().getDocument().get();
            if (txt != null && txt.length() > 0) {
                if (!TextMerge.replace(this.getSourceViewer().getDocument(), text)) {
                    this.getSourceViewer().getDocument().set(text);
                }
            } else {
                this.getSourceViewer().getDocument().set(text);
            }
        }
        finally {
            --this.textChangedLock;
        }
    }

    @Override
    public boolean isEqualText(String text) {
        return this.getSourceViewer().getDocument() != null && text.equals(this.getText());
    }

    @Override
    public void doSanityCheckState(IEditorInput input) {
        super.safelySanityCheckState(input);
        if (this.isObjectNull) {
            return;
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {}
                XMLTextEditorComponent.this.support.save(true);
            }
        });
    }

    protected void handleEditorInputChanged() {
        final IDocumentProvider provider = this.getDocumentProvider();
        if (provider == null) {
            this.close(false);
            return;
        }
        final IEditorInput input = this.getEditorInput();
        if (provider instanceof IDocumentProviderExtension) {
            WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) throws CoreException {
                    IDocumentProviderExtension extension = (IDocumentProviderExtension)provider;
                    XMLTextEditorComponent xMLTextEditorComponent = XMLTextEditorComponent.this;
                    xMLTextEditorComponent.textChangedLock = xMLTextEditorComponent.textChangedLock + 1;
                    try {
                        extension.synchronize((Object)input);
                    }
                    finally {
                        XMLTextEditorComponent xMLTextEditorComponent2 = XMLTextEditorComponent.this;
                        xMLTextEditorComponent2.textChangedLock = xMLTextEditorComponent2.textChangedLock - 1;
                    }
                }
            };
            try {
                operation.run(this.getProgressMonitor());
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        } else {
            try {
                this.doSetInput(input);
            }
            catch (CoreException coreException) {}
        }
    }

    @Override
    public void doRevertToSaved() {
        this.support.save();
        this.support.revertToSaved();
    }

    protected void createActions() {
        super.createActions();
        Object action = new RevertToSavedAction2(this);
        action.setHelpContextId(IAbstractTextEditorHelpContextIds.REVERT_TO_SAVED_ACTION);
        action.setActionDefinitionId("org.eclipse.ui.edit.revertToSaved");
        this.setAction(ITextEditorActionConstants.REVERT_TO_SAVED, (IAction)action);
        action = new SaveAction2(this);
        action.setHelpContextId(IAbstractTextEditorHelpContextIds.SAVE_ACTION);
        action.setActionDefinitionId("org.eclipse.ui.file.save");
        this.setAction(ITextEditorActionConstants.SAVE, (IAction)action);
        this.markAsPropertyDependentAction(ITextEditorActionConstants.SAVE, true);
    }

    @Override
    public void selectModelObject(XModelObject object) {
        this.selectModelObject(object, null);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.changeListener != null) {
            ModelPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.changeListener);
            this.changeListener = null;
        }
    }

    @Override
    public void selectModelObject(XModelObject object, String attribute) {
        PositionSearcher searcher = new PositionSearcher();
        searcher.init(this.getText(), object, attribute);
        searcher.execute();
        int bp = searcher.getStartPosition();
        int ep = searcher.getEndPosition();
        if (ep >= bp && bp >= 0) {
            this.selectAndReveal(bp, ep - bp);
        }
    }

    @Override
    public void updateModification() {
        XModelObject object = this.support.getModelObject();
        if (object != null && !object.isModified() && this.support.isModified()) {
            this.setModified(false);
        } else {
            this.firePropertyChange(257);
        }
    }

    private void updateAnnotationModel() {
    }

    @Override
    public void gotoMarker(IMarker marker) {
        super.gotoMarker(marker);
    }

    @Override
    public XModelObject findModelObjectAtCursor() {
        XModelObject o = this.getModelObject();
        if (o == null) {
            return null;
        }
        ISelection selection = this.getSelectionProvider().getSelection();
        if (!(selection instanceof ITextSelection)) {
            return null;
        }
        int offset = ((ITextSelection)selection).getOffset();
        if (offset < 0) {
            return o;
        }
        IndexedRegion region = this.getModel().getIndexedRegion(offset);
        return this.modelObjectFinder.findModelObject(region, o);
    }

    class ICL
    implements IResourceChangeListener {
        ICL() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if (event == null || event.getDelta() == null || XMLTextEditorComponent.this.isUpdating) {
                return;
            }
            if (!(XMLTextEditorComponent.this.getEditorInput() instanceof IFileEditorInput)) {
                return;
            }
            IFile f = ((IFileEditorInput)XMLTextEditorComponent.this.getEditorInput()).getFile();
            if (f == null) {
                return;
            }
            IMarkerDelta[] md = event.findMarkerDeltas(null, true);
            boolean b = false;
            int i = 0;
            while (i < md.length && !b) {
                b = f.equals((Object)md[i].getResource());
                ++i;
            }
            if (b) {
                XMLTextEditorComponent.this.updateAnnotationModel();
            }
        }
    }
}

