/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.texteditors.xmleditor;

import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.StructuredTextViewerConfiguration;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.xml.core.internal.document.AttrImpl;
import org.eclipse.wst.xml.core.internal.document.ElementImpl;
import org.eclipse.wst.xml.ui.StructuredTextViewerConfigurationXML;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.model.XModelBuffer;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.XModelTransferBuffer;
import org.jboss.tools.common.model.filesystems.impl.FileAnyImpl;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.dnd.ModelTransfer;
import org.jboss.tools.common.model.ui.editor.EditorDescriptor;
import org.jboss.tools.common.model.ui.editor.IModelObjectEditorInput;
import org.jboss.tools.common.model.ui.editors.dnd.DropCommandFactory;
import org.jboss.tools.common.model.ui.editors.dnd.DropData;
import org.jboss.tools.common.model.ui.editors.dnd.EmptyTagProposalFactory;
import org.jboss.tools.common.model.ui.editors.dnd.context.DropContext;
import org.jboss.tools.common.model.ui.editors.dnd.context.IDNDTextEditor;
import org.jboss.tools.common.model.ui.texteditors.dnd.TextEditorDrop;
import org.jboss.tools.common.model.ui.texteditors.dnd.TextEditorDropProvider;
import org.jboss.tools.common.model.ui.views.palette.PaletteInsertHelper;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.common.text.xml.IOccurrencePreferenceProvider;
import org.jboss.tools.common.text.xml.XMLTextViewerConfiguration;
import org.jboss.tools.common.text.xml.XmlEditorPlugin;
import org.jboss.tools.common.text.xml.ui.FreeCaretStyledText;
import org.jboss.tools.jst.jsp.text.xpl.IStructuredTextOccurrenceStructureProvider;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class XMLTextEditor
extends StructuredTextEditor
implements IDocumentListener,
IDNDTextEditor,
IOccurrencePreferenceProvider {
    private IStructuredTextOccurrenceStructureProvider fOccurrenceModelUpdater;
    IEditorInput input;
    XModelObject object = null;
    private boolean useRHDSConfig = true;
    boolean modified = false;
    boolean lock = false;
    int lastpos = -1;
    String lastContext = null;
    private DocumentListenerRegistry documentListenerRegistry;

    public XMLTextEditor() {
        this(true);
    }

    public XMLTextEditor(boolean useRHDSConfig) {
        this.useRHDSConfig = useRHDSConfig;
        if (useRHDSConfig) {
            super.setSourceViewerConfiguration((SourceViewerConfiguration)new XMLTextViewerConfiguration());
        }
    }

    protected void setSourceViewerConfiguration(SourceViewerConfiguration config) {
        if (this.useRHDSConfig && !(config instanceof XMLTextViewerConfiguration) && (config instanceof StructuredTextViewerConfigurationXML || !(config instanceof StructuredTextViewerConfiguration))) {
            XMLTextViewerConfiguration r = new XMLTextViewerConfiguration();
            r.setInitialConfiguration(config);
            config = r;
        }
        super.setSourceViewerConfiguration(config);
    }

    protected void initializeDrop(ITextViewer textViewer) {
        StyledText c = textViewer.getTextWidget();
        Label l = new Label((Composite)c, 0);
        l.dispose();
    }

    public IStructuredTextOccurrenceStructureProvider getOccurrencePreferenceProvider() {
        return this.fOccurrenceModelUpdater;
    }

    public String getEditorId() {
        return "org.eclipse.wst.xml.ui";
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.fOccurrenceModelUpdater = XmlEditorPlugin.getDefault().getOccurrenceStructureProviderRegistry("org.jboss.tools.common.text.xml").getCurrentOccurrenceProvider("org.jboss.tools.common.text.xml");
        if (this.fOccurrenceModelUpdater != null) {
            this.fOccurrenceModelUpdater.install((StructuredTextEditor)this, (ProjectionViewer)this.getTextViewer());
        }
        this.createDrop();
        this.setModified(false);
        this.getDocumentListenerRegister().unregister();
        this.getDocumentListenerRegister().register();
        Object dtid = this.getSourceViewer().getTextWidget().getData("DropTarget");
        if (dtid != null && dtid instanceof DropTarget) {
            DropTarget dropTarget = (DropTarget)dtid;
            dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

                private FreeCaretStyledText getFreeCaretControl(Object sourceOrTarget) {
                    if (sourceOrTarget == null) {
                        return null;
                    }
                    Control control = null;
                    if (sourceOrTarget instanceof DropTarget) {
                        control = ((DropTarget)sourceOrTarget).getControl();
                    } else if (sourceOrTarget instanceof DragSource) {
                        control = ((DragSource)sourceOrTarget).getControl();
                    } else {
                        return null;
                    }
                    if (control instanceof FreeCaretStyledText) {
                        return (FreeCaretStyledText)control;
                    }
                    return null;
                }

                public void dragEnter(DropTargetEvent event) {
                    FreeCaretStyledText fcst = this.getFreeCaretControl(event.widget);
                    if (fcst != null) {
                        fcst.enableFreeCaret(true);
                    }
                }

                public void dragLeave(DropTargetEvent event) {
                    FreeCaretStyledText fcst = this.getFreeCaretControl(event.widget);
                    if (fcst != null) {
                        fcst.enableFreeCaret(false);
                    }
                }

                public void dragOperationChanged(DropTargetEvent event) {
                    FreeCaretStyledText fcst = this.getFreeCaretControl(event.widget);
                    if (fcst != null) {
                        fcst.enableFreeCaret(false);
                    }
                }

                public void dragOver(DropTargetEvent event) {
                    FreeCaretStyledText fcst = this.getFreeCaretControl(event.widget);
                    if (fcst != null) {
                        int pos = XMLTextEditor.this.getPosition((StyledText)fcst, event.x, event.y);
                        Point p = fcst.getLocationAtOffset(pos);
                        fcst.myRedraw(p.x, p.y);
                    }
                }

                public void drop(DropTargetEvent event) {
                    FreeCaretStyledText fcst = this.getFreeCaretControl(event.widget);
                    if (fcst != null) {
                        fcst.enableFreeCaret(false);
                    }
                }
            });
        }
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        ISourceViewer sv = super.createSourceViewer(parent, ruler, styles);
        sv.getTextWidget().addFocusListener((FocusListener)new TextFocusListener());
        return sv;
    }

    protected StructuredTextViewer createStructedTextViewer(Composite parent, IVerticalRuler verticalRuler, int styles) {
        return new StructuredTextViewer(parent, verticalRuler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles){

            protected StyledText createTextWidget(Composite parent, int styles) {
                return new FreeCaretStyledText(parent, styles);
            }
        };
    }

    private void saveInThread() {
        if (!XMLTextEditor.super.isDirty()) {
            return;
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {}
                XMLTextEditor.this.save();
            }
        });
    }

    public void save() {
        block7: {
            if (!this.lock && this.isModified()) {
                this.lock = true;
                try {
                    try {
                        FileAnyImpl f = (FileAnyImpl)this.getModelObject();
                        if (f != null) {
                            f.edit(this.getSourceViewer().getDocument().get());
                        }
                    }
                    catch (XModelException e) {
                        ModelUIPlugin.getPluginLog().logError((Throwable)e);
                        this.setModified(false);
                        this.lock = false;
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    this.setModified(false);
                    this.lock = false;
                    throw throwable;
                }
                this.setModified(false);
                this.lock = false;
            }
        }
        this.getSourceViewer().getAnnotationModel().disconnect(this.getSourceViewer().getDocument());
        this.getSourceViewer().getAnnotationModel().connect(this.getSourceViewer().getDocument());
    }

    public void setModified(boolean set) {
        if (this.modified != set) {
            XModelObject o;
            this.modified = set;
            if (set && (o = this.getModelObject()) != null) {
                o.setModified(true);
            }
            super.firePropertyChange(257);
        }
    }

    public boolean isModified() {
        return this.modified;
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        this.input = input;
        if (input instanceof IModelObjectEditorInput) {
            this.object = ((IModelObjectEditorInput)input).getXModelObject();
        }
        if (this.getSourceViewer() != null && this.getSourceViewer().getDocument() != null) {
            this.getDocumentListenerRegister().unregister();
            this.getDocumentListenerRegister().register();
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == EditorDescriptor.class) {
            return new EditorDescriptor("xml");
        }
        return super.getAdapter(adapter);
    }

    public boolean isDirty() {
        if (this.getEditorInput() instanceof IModelObjectEditorInput) {
            XModelObject o = this.getModelObject();
            if (o != null && o.isModified()) {
                return true;
            }
            return this.isModified();
        }
        return super.isDirty();
    }

    public boolean isSaveOnCloseNeeded() {
        return super.isSaveOnCloseNeeded() || this.isModified();
    }

    public void doSave(IProgressMonitor monitor) {
        XModelObject o = this.getModelObject();
        if (o != null) {
            this.save();
            if (!(this.getEditorInput() instanceof IFileEditorInput) && this.getEditorInput() instanceof ILocationProvider) {
                this.doSaveYourself();
            } else {
                o.setModified(false);
                XModelObjectLoaderUtil.updateModifiedOnSave((XModelObject)o);
            }
        }
        this.superDoSave(monitor);
    }

    protected final void superDoSave(IProgressMonitor monitor) {
        super.doSave(monitor);
    }

    protected void doSaveYourself() {
    }

    public XModelObject getModelObject() {
        if (this.getEditorInput() instanceof IModelObjectEditorInput) {
            return ((IModelObjectEditorInput)this.getEditorInput()).getXModelObject();
        }
        return null;
    }

    private String _getContext(int pos) {
        if (this.lastpos == pos && pos >= 0) {
            pos = this.lastpos;
            return this.lastContext;
        }
        this.lastpos = pos;
        this.lastContext = null;
        this.getSourceViewer().getDocument();
        IndexedRegion region = this.getModel().getIndexedRegion(pos);
        if (region instanceof ElementImpl) {
            ElementImpl jspElement = (ElementImpl)region;
            NamedNodeMap attributes = jspElement.getAttributes();
            if (pos == jspElement.getStartOffset() || pos == jspElement.getEndStartOffset()) {
                this.lastContext = "text";
                return "text";
            }
            int i = 0;
            while (i < attributes.getLength()) {
                Node attribute = attributes.item(i);
                if (attribute instanceof AttrImpl) {
                    AttrImpl jspAttr = (AttrImpl)attribute;
                    ITextRegion valueRegion = jspAttr.getValueRegion();
                    if (valueRegion == null) {
                        this.lastContext = "none";
                        return "none";
                    }
                    int startPos = jspElement.getStartOffset() + valueRegion.getStart();
                    int endPos = jspElement.getStartOffset() + valueRegion.getTextEnd();
                    if (pos > startPos && pos < endPos) {
                        this.lastContext = "attribute";
                        return "attribute";
                    }
                }
                ++i;
            }
            this.lastContext = "none";
            return "none";
        }
        if (region instanceof Text) {
            this.lastContext = "text";
            return "text";
        }
        if (region instanceof DocumentType) {
            this.lastContext = "none";
            return "none";
        }
        if (region == null) {
            this.lastContext = "text";
            return "text";
        }
        this.lastContext = "none";
        return "none";
    }

    public void textChanged(TextEvent event) {
        this.setModified(super.isSaveOnCloseNeeded());
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
        StyledText text;
        this.textChanged(null);
        StyledText styledText = text = this.getSourceViewer() != null ? this.getSourceViewer().getTextWidget() : null;
        if (text != null && !text.isDisposed() && !text.isFocusControl() && text.isVisible()) {
            this.saveInThread();
        }
    }

    public void doRevertToSaved() {
        this.save();
        XModelObject o = this.getModelObject();
        Properties p = new Properties();
        XActionInvoker.invoke((String)"FileTXT", (String)"DiscardActions.Discard", (XModelObject)o, (Properties)p);
        if (!"true".equals(p.getProperty("done"))) {
            return;
        }
        super.doRevertToSaved();
        if (o.isModified()) {
            o.setModified(false);
        }
        this.modified = false;
        this.firePropertyChange(257);
        this.updatePartControl(this.getEditorInput());
    }

    public void dispose() {
        this.getDocumentListenerRegister().unregister();
        this.documentListenerRegistry = null;
        if (this.fOccurrenceModelUpdater != null) {
            this.fOccurrenceModelUpdater.uninstall();
            this.fOccurrenceModelUpdater = null;
        }
        super.dispose();
    }

    private void createDrop() {
        DropTarget target = new DropTarget((Control)this.getSourceViewer().getTextWidget(), 3);
        Transfer[] types = new Transfer[]{ModelTransfer.getInstance(), HTMLTransfer.getInstance(), TextTransfer.getInstance(), FileTransfer.getInstance()};
        target.setTransfer(types);
        target.addDropListener((DropTargetListener)new DTL());
    }

    @Override
    public void runDropCommand(final String flavor, final String data) {
        XModelBuffer b = XModelTransferBuffer.getInstance().getBuffer();
        final XModelObject o = b == null ? null : b.source();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (o != null && !XModelTransferBuffer.getInstance().isEnabled()) {
                    XModelTransferBuffer.getInstance().enable();
                    XModelTransferBuffer.getInstance().getBuffer().addSource(o);
                }
                try {
                    DropCommandFactory.getInstance().getDropCommand(flavor, EmptyTagProposalFactory.getInstance()).execute(new DropData(flavor, data, XMLTextEditor.this.getEditorInput(), XMLTextEditor.this.getSourceViewer(), XMLTextEditor.this.getSelectionProvider()));
                }
                finally {
                    XModelTransferBuffer.getInstance().disable();
                }
            }
        });
    }

    private int getPosition(int x, int y) {
        ISourceViewer v = this.getSourceViewer();
        if (v == null) {
            return 0;
        }
        return this.getPosition(v.getTextWidget(), x, y);
    }

    private int getPosition(StyledText t, int x, int y) {
        if (t == null || t.isDisposed()) {
            return 0;
        }
        Point pp = t.toControl(x, y);
        x = pp.x;
        y = pp.y;
        int lineIndex = (t.getTopPixel() + y) / t.getLineHeight();
        if (lineIndex >= t.getLineCount()) {
            return t.getCharCount();
        }
        int c = 0;
        try {
            c = t.getOffsetAtLocation(new Point(x, y));
            if (c < 0) {
                c = 0;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (lineIndex + 1 >= t.getLineCount()) {
                return t.getCharCount();
            }
            c = t.getOffsetAtLine(lineIndex + 1) - (t.getLineDelimiter() == null ? 0 : t.getLineDelimiter().length());
        }
        return c;
    }

    protected DocumentListenerRegistry getDocumentListenerRegister() {
        if (this.documentListenerRegistry == null) {
            this.documentListenerRegistry = new DocumentListenerRegistry();
        }
        return this.documentListenerRegistry;
    }

    class DTL
    implements DropTargetListener {
        DropContext dropContext = new DropContext();
        int lastpos = -1;
        int lastdetail = -1;

        DTL() {
        }

        public void dragEnter(DropTargetEvent event) {
            this.lastpos = -1;
        }

        public void dragLeave(DropTargetEvent event) {
            this.lastpos = -1;
        }

        public void dragOperationChanged(DropTargetEvent event) {
        }

        public void dragOver(DropTargetEvent event) {
            if (!XMLTextEditor.this.isEditable() || XMLTextEditor.this.getModelObject() != null && !XMLTextEditor.this.getModelObject().isObjectEditable()) {
                event.detail = 0;
                return;
            }
            this.dropContext.setDropTargetEvent((TypedEvent)event);
            if (this.dropContext.getFlavor() == null) {
                event.detail = 0;
                return;
            }
            int pos = XMLTextEditor.this.getPosition(event.x, event.y);
            if (this.lastpos == pos && pos >= 0) {
                pos = this.lastpos;
                event.detail = this.lastdetail;
                return;
            }
            this.lastpos = pos;
            this.dropContext.clean();
            XMLTextEditor.this.getSourceViewer().getDocument();
            IndexedRegion region = XMLTextEditor.this.getModel().getIndexedRegion(pos);
            if (region instanceof ElementImpl) {
                ElementImpl jspElement = (ElementImpl)region;
                NamedNodeMap attributes = jspElement.getAttributes();
                if (pos == jspElement.getStartOffset() || pos == jspElement.getEndStartOffset()) {
                    this.lastdetail = 2;
                    event.detail = 2;
                    return;
                }
                int i = 0;
                while (i < attributes.getLength()) {
                    Node attribute = attributes.item(i);
                    if (attribute instanceof AttrImpl) {
                        AttrImpl jspAttr = (AttrImpl)attribute;
                        ITextRegion valueRegion = jspAttr.getValueRegion();
                        if (valueRegion == null) {
                            this.lastdetail = 0;
                            event.detail = 0;
                            return;
                        }
                        int startPos = jspElement.getStartOffset() + valueRegion.getStart();
                        int endPos = jspElement.getStartOffset() + valueRegion.getTextEnd();
                        if (pos > startPos && pos < endPos) {
                            this.dropContext.setOverAttributeValue(true);
                            this.lastdetail = 2;
                            event.detail = 2;
                            return;
                        }
                    }
                    ++i;
                }
                this.lastdetail = 0;
                event.detail = 0;
            } else if (region instanceof Text) {
                this.lastdetail = 2;
                event.detail = 2;
            } else if (region instanceof DocumentType) {
                this.lastdetail = 0;
                event.detail = 0;
            } else if (region == null) {
                this.lastdetail = 2;
                event.detail = 2;
            }
        }

        public void drop(DropTargetEvent event) {
            int offset = XMLTextEditor.this.getPosition(event.x, event.y);
            XMLTextEditor.this.selectAndReveal(offset, 0);
            this.dropContext.runDropCommand(XMLTextEditor.this, (TypedEvent)event);
        }

        public void dropAccept(DropTargetEvent event) {
        }
    }

    protected class DocumentListenerRegistry {
        IDocument document = null;

        protected DocumentListenerRegistry() {
        }

        public void unregister() {
            if (this.document != null) {
                this.document.removeDocumentListener((IDocumentListener)XMLTextEditor.this);
            }
        }

        public void register() {
            if (XMLTextEditor.this.getSourceViewer() == null) {
                return;
            }
            this.document = XMLTextEditor.this.getSourceViewer().getDocument();
            if (this.document != null) {
                this.document.addDocumentListener((IDocumentListener)XMLTextEditor.this);
            }
        }
    }

    class TextEditorDropProviderImpl
    implements TextEditorDropProvider,
    TextEditorDrop.TextEditorDropProvider2 {
        TextEditorDropProviderImpl() {
        }

        @Override
        public ISourceViewer getSourceViewer() {
            return XMLTextEditor.this.getSourceViewer();
        }

        @Override
        public XModelObject getModelObject() {
            return XMLTextEditor.this.getModelObject();
        }

        @Override
        public void insert(Properties p) {
            PaletteInsertHelper.getInstance().insertIntoEditor(this.getSourceViewer(), p);
        }

        @Override
        public String getContext(int pos) {
            return XMLTextEditor.this._getContext(pos);
        }
    }

    class TextFocusListener
    extends FocusAdapter {
        TextFocusListener() {
        }

        public void focusLost(FocusEvent e) {
            XMLTextEditor.this.saveInThread();
        }
    }
}

