/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.views.navigator;

import java.util.Properties;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.BuildAction;
import org.eclipse.ui.actions.CloseResourceAction;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.framelist.FrameList;
import org.eclipse.ui.views.navigator.IResourceNavigator;
import org.eclipse.ui.views.navigator.ResourceComparator;
import org.eclipse.ui.views.navigator.ResourceNavigatorActionGroup;
import org.eclipse.ui.views.navigator.ResourcePatternFilter;
import org.eclipse.ui.views.navigator.ResourceSorter;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.model.XFilteredTree;
import org.jboss.tools.common.model.XJob;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.event.XModelTreeEvent;
import org.jboss.tools.common.model.impl.trees.FileSystemsTree;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.project.IModelNature;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.action.ModelContributionManager;
import org.jboss.tools.common.model.ui.dnd.ControlDragDrop;
import org.jboss.tools.common.model.ui.editor.IModelObjectEditorInput;
import org.jboss.tools.common.model.ui.navigator.NavigatorLabelProvider;
import org.jboss.tools.common.model.ui.navigator.NavigatorStatusLineProvider;
import org.jboss.tools.common.model.ui.navigator.TreeViewerDragDropProvider;
import org.jboss.tools.common.model.ui.navigator.TreeViewerMenuInvoker;
import org.jboss.tools.common.model.ui.navigator.TreeViewerModelListenerImpl;
import org.jboss.tools.common.model.ui.select.XModelObjectSelectionProvider;
import org.jboss.tools.common.model.ui.views.navigator.ModelNavigatorActionGroup;
import org.jboss.tools.common.model.ui.views.navigator.NavigatorContentProvider;
import org.jboss.tools.common.model.ui.views.navigator.NavigatorMenuInvoker;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.model.util.ModelFeatureFactory;

public class NavigatorViewPart
extends ViewPart
implements ISaveablePart,
ISetSelectionTarget,
IResourceNavigator,
IShowInTarget {
    public static final String VIEW_ID = "org.jboss.tools.common.model.ui.navigator.NavigatorViewPart";
    private TreeViewer viewer;
    private XModelObjectSelectionProvider selectionProvider = new XModelObjectSelectionProvider();
    private TreeViewerDragDropProvider dndProvider = new TreeViewerDragDropProvider();
    private ControlDragDrop dnd = new ControlDragDrop();
    private CloseResourceAction closeProjectAction;
    private BuildAction buildProjectAction;
    private BuildAction rebuildProjectAction;
    protected NavigatorContentProvider contentProvider;
    private IMemento memento = null;
    private NavigatorStatusLineProvider statusLineProvider = new NavigatorStatusLineProvider();
    private ActivationListener fActivationListener = new ActivationListener();
    boolean useModelMenu = true;
    IWorkingSet workingSet = null;
    protected ResourceSorter resourceSorter = null;
    String[] filtersPreference = new String[0];
    protected boolean isLinkingEnabled = false;
    ResourceNavigatorActionGroup actionGroup;
    ModelContributionManager menuMgr;
    TreeViewerMenuInvoker listener;
    private IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
            if (part instanceof IEditorPart && part != NavigatorViewPart.this) {
                NavigatorViewPart.this.editorActivated((IEditorPart)part);
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    };
    boolean isHandlingActivation = false;

    public NavigatorViewPart() {
        this.selectionProvider.addSelectionChangedListener(new SL());
    }

    public void setFocus() {
        this.getViewer().getTree().setFocus();
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public void createPartControl(Composite parent) {
        this.createViewer(parent);
        this.viewer.setInput((Object)this.getInitialInput());
        this.selectionProvider.addHost("viewer", (ISelectionProvider)this.viewer, true);
        this.getSite().setSelectionProvider((ISelectionProvider)this.selectionProvider);
        if (this.memento != null) {
            this.restoreLinkingEnabled();
        }
        this.initActionBars();
        this.dndProvider.setViewer(this.viewer);
        this.dnd.setProvider(this.dndProvider);
        this.dnd.enable();
        this.initContextMenu();
        this.activateF3();
        this.getSite().getPage().addPartListener(this.partListener);
        if (this.memento != null) {
            this.restoreState(this.memento);
        }
        this.memento = null;
    }

    private void activateF3() {
        IHandlerService h = (IHandlerService)this.getViewSite().getActionBars().getServiceLocator().getService(IHandlerService.class);
        Action action = new Action(){

            public boolean isEnabled() {
                return true;
            }

            public void run() {
                ISelection s = NavigatorViewPart.this.viewer.getSelection();
                if (s.isEmpty() || !(s instanceof StructuredSelection)) {
                    return;
                }
                StructuredSelection ss = (StructuredSelection)s;
                Object o = ss.getFirstElement();
                if (!(o instanceof XModelObject)) {
                    return;
                }
                XModelObject object = (XModelObject)o;
                if (XActionInvoker.getAction((String)"Open", (XModelObject)object) == null) {
                    return;
                }
                XActionInvoker.invoke((String)"Open", (XModelObject)object, null);
            }
        };
        h.activateHandler("org.eclipse.jdt.ui.edit.text.java.open.editor", (IHandler)new ActionHandler((IAction)action));
    }

    private IAction createActionInstance(String name) {
        return (IAction)ModelFeatureFactory.getInstance().createFeatureInstance(name);
    }

    protected String[] getActionClasses() {
        String[] actions = new String[]{};
        return actions;
    }

    protected void initActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        String[] actions = this.getActionClasses();
        int i = 0;
        while (i < actions.length) {
            IAction action = this.createActionInstance(actions[i]);
            if (action != null) {
                bars.getToolBarManager().add(action);
            }
            ++i;
        }
        this.closeProjectAction = new CloseResourceAction(this.getViewer().getTree().getShell());
        this.getSite().getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this.closeProjectAction);
        this.getViewSite().getActionBars().setGlobalActionHandler(IDEActionFactory.CLOSE_PROJECT.getId(), (IAction)this.closeProjectAction);
        this.buildProjectAction = new BuildAction(this.getViewer().getTree().getShell(), 10);
        this.getSite().getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this.buildProjectAction);
        this.getViewSite().getActionBars().setGlobalActionHandler(IDEActionFactory.BUILD_PROJECT.getId(), (IAction)this.buildProjectAction);
        this.rebuildProjectAction = new BuildAction(this.getViewer().getTree().getShell(), 6);
        this.getSite().getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this.rebuildProjectAction);
        this.getViewSite().getActionBars().setGlobalActionHandler(IDEActionFactory.BUILD_PROJECT.getId(), (IAction)this.rebuildProjectAction);
        this.makeActions();
        this.getActionGroup().fillActionBars(this.getViewSite().getActionBars());
        this.updateActionBars((IStructuredSelection)this.viewer.getSelection());
    }

    public void dispose() {
        if (this.getSite() != null && this.getSite().getSelectionProvider() != null) {
            this.getSite().getSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)this.closeProjectAction);
            this.getSite().getSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)this.buildProjectAction);
            this.getSite().getSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)this.rebuildProjectAction);
        }
        if (this.getSite() != null) {
            this.getSite().getWorkbenchWindow().getShell().removeShellListener((ShellListener)this.fActivationListener);
        }
        super.dispose();
    }

    protected void createViewer(Composite parent) {
        this.viewer = new TreeViewer(parent, 770);
        this.viewer.setUseHashlookup(true);
        this.initContentProvider(this.viewer);
        this.initLabelProvider(this.viewer);
        this.initListeners(this.viewer);
    }

    protected void initLabelProvider(TreeViewer treeViewer) {
        treeViewer.setLabelProvider((IBaseLabelProvider)new NavigatorLabelProvider());
    }

    protected void initContentProvider(TreeViewer treeViewer) {
        NavigatorContentProvider c = new NavigatorContentProvider();
        ML listener = new ML();
        listener.setViewer(treeViewer);
        c.setListener(listener);
        this.contentProvider = c;
        treeViewer.setContentProvider((IContentProvider)this.contentProvider);
    }

    protected void initListeners(TreeViewer treeViewer) {
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NavigatorViewPart.this.handleSelectionChanged(event);
            }
        });
        this.listener = this.createMenuInvoker();
        this.listener.setViewer((Viewer)this.viewer);
        if (this.useModelMenu) {
            this.viewer.getTree().addMouseListener((MouseListener)this.listener);
        }
    }

    protected TreeViewerMenuInvoker createMenuInvoker() {
        return new NavigatorMenuInvoker();
    }

    public XModelObject getSelectedModelObject() {
        if (this.getViewer() == null || this.getViewer().getTree() == null || this.getViewer().getTree().isDisposed()) {
            return null;
        }
        TreeItem[] ti = this.getViewer().getTree().getSelection();
        if (ti == null || ti.length == 0) {
            return null;
        }
        return this.getModelObjectForWidget((Widget)ti[0]);
    }

    public XModelObject getModelObjectForWidget(Widget widget) {
        if (!(widget instanceof TreeItem)) {
            return null;
        }
        TreeItem item = (TreeItem)widget;
        Object itemData = item.getData();
        return !(itemData instanceof XModelObject) ? null : (XModelObject)itemData;
    }

    protected IAdaptable getInitialInput() {
        IAdaptable input = this.getSite().getPage().getInput();
        if (input != null) {
            IResource resource = null;
            resource = input instanceof IResource ? (IResource)input : (IResource)input.getAdapter(IResource.class);
            if (resource != null) {
                switch (resource.getType()) {
                    case 1: {
                        return resource.getParent();
                    }
                    case 2: 
                    case 4: 
                    case 8: {
                        return (IContainer)resource;
                    }
                }
            }
        }
        return ModelUIPlugin.getWorkspace().getRoot();
    }

    public Object getAdapter(Class adapter) {
        return super.getAdapter(adapter);
    }

    /*
     * Unable to fully structure code
     */
    public void doSave(IProgressMonitor monitor) {
        o = this.getSelectedModelObject();
        if (o != null) ** GOTO lbl5
        return;
lbl-1000:
        // 1 sources

        {
            o = o.getParent();
lbl5:
            // 2 sources

            ** while (o != null && o.getFileType() == 0)
        }
lbl6:
        // 1 sources

        if (o == null || o.getFileType() != 1) {
            return;
        }
        XActionInvoker.invoke((String)"SaveActions.Save", (XModelObject)o, null);
        this.firePropertyChange(257);
    }

    public void doSaveAs() {
    }

    /*
     * Unable to fully structure code
     */
    public boolean isDirty() {
        o = this.getSelectedModelObject();
        if (o != null) ** GOTO lbl5
        return false;
lbl-1000:
        // 1 sources

        {
            o = o.getParent();
lbl5:
            // 2 sources

            ** while (o != null && o.getFileType() == 0)
        }
lbl6:
        // 1 sources

        if (o == null || o.getFileType() != 1) {
            return false;
        }
        return o.isModified();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return false;
    }

    public void selectReveal(ISelection selection) {
        XModelObject root;
        Object object;
        if (selection instanceof IStructuredSelection && (object = ((IStructuredSelection)selection).getFirstElement()) instanceof IProject && (root = this.contentProvider.getRootByProject((IProject)object)) != null) {
            this.getSite().getSelectionProvider().setSelection((ISelection)new StructuredSelection((Object)root));
        }
    }

    public void init(IViewSite site, IMemento _memento) throws PartInitException {
        this.init(site);
        this.memento = _memento;
        site.getWorkbenchWindow().getShell().addShellListener((ShellListener)this.fActivationListener);
    }

    public void saveState(IMemento _memento) {
        XModelObject o = this.getSelectedModelObject();
        if (o != null) {
            _memento.putString("selection", this.getNodePath(o));
        }
        this.saveLinkingEnabled(_memento);
    }

    public void restoreState(IMemento _memento) {
        String selection = _memento.getString("selection");
        XModelObject o = this.findModelObject(selection);
        if (o != null) {
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)o));
        }
        this.restoreLinkingEnabled();
    }

    private String getNodePath(XModelObject o) {
        IProject p = (IProject)o.getModel().getProperties().get("project");
        return String.valueOf(p.getName()) + ":" + o.getPath();
    }

    private XModelObject findModelObject(String nodepath) {
        if (nodepath == null || nodepath.length() == 0) {
            return null;
        }
        int i = nodepath.indexOf(":");
        IProject p = ModelUIPlugin.getWorkspace().getRoot().getProject(nodepath.substring(0, i));
        return EclipseResourceUtil.getObjectByPath((IProject)p, (String)nodepath.substring(i + 1));
    }

    protected void handleSelectionChanged(SelectionChangedEvent event) {
        IStructuredSelection sel = (IStructuredSelection)event.getSelection();
        this.updateStatusLine(sel);
        this.updateActionBars(sel);
        this.linkToEditor(sel);
    }

    protected void updateStatusLine(IStructuredSelection selection) {
        String msg = this.statusLineProvider.getStatusLineMessage(selection);
        this.getViewSite().getActionBars().getStatusLineManager().setMessage(msg);
    }

    public ResourcePatternFilter getPatternFilter() {
        return new ResourcePatternFilter();
    }

    public IWorkingSet getWorkingSet() {
        return this.workingSet;
    }

    public void setWorkingSet(IWorkingSet workingSet) {
        this.workingSet = workingSet;
    }

    public ResourceSorter getSorter() {
        return this.resourceSorter;
    }

    public void setSorter(ResourceSorter sorter) {
        this.resourceSorter = sorter;
    }

    public void setFiltersPreference(String[] patterns) {
        this.filtersPreference = patterns;
    }

    public FrameList getFrameList() {
        return null;
    }

    public boolean isLinkingEnabled() {
        return this.isLinkingEnabled;
    }

    public void setLinkingEnabled(boolean enabled) {
        IEditorPart editor;
        this.isLinkingEnabled = enabled;
        if (enabled && (editor = this.getSite().getPage().getActiveEditor()) != null && editor != this) {
            this.editorActivated(editor);
        }
    }

    protected void makeActions() {
        this.setActionGroup(new ModelNavigatorActionGroup(this));
    }

    protected ResourceNavigatorActionGroup getActionGroup() {
        return this.actionGroup;
    }

    protected void setActionGroup(ResourceNavigatorActionGroup actionGroup) {
        this.actionGroup = actionGroup;
    }

    protected void updateActionBars(IStructuredSelection selection) {
        ResourceNavigatorActionGroup group = this.getActionGroup();
        if (group != null) {
            group.setContext(new ActionContext((ISelection)selection));
            group.updateActionBars();
        }
    }

    protected void initContextMenu() {
        this.menuMgr = new ModelContributionManager(this.getSite().getShell(), this.listener);
        this.menuMgr.setRemoveAllWhenShown(true);
        this.menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                NavigatorViewPart.this.fillContextMenu(manager);
            }
        });
        TreeViewer treeViewer = this.getViewer();
        Menu menu = this.menuMgr.createContextMenu((Control)treeViewer.getTree());
        treeViewer.getTree().setMenu(menu);
        this.getSite().registerContextMenu((MenuManager)this.menuMgr, (ISelectionProvider)treeViewer);
        this.listener.setStandardInvoker(this.menuMgr);
    }

    public void callMenu() {
        this.fillContextMenu((IMenuManager)this.menuMgr);
        Menu menu = this.menuMgr.createContextMenu((Control)this.viewer.getTree());
        menu.setVisible(true);
    }

    protected void fillContextMenu(IMenuManager menu) {
        menu.update(true);
    }

    public TreeViewer getTreeViewer() {
        return this.getViewer();
    }

    private void saveLinkingEnabled(IMemento _memento) {
        _memento.putInteger("LinkModelProjectsToEditor", this.isLinkingEnabled ? 1 : 0);
    }

    private void restoreLinkingEnabled() {
        Integer val = this.memento.getInteger("LinkModelProjectsToEditor");
        if (val != null) {
            this.isLinkingEnabled = val != 0;
        }
    }

    protected void editorActivated(IEditorPart editor) {
        if (!this.isLinkingEnabled()) {
            return;
        }
        IEditorInput input = editor.getEditorInput();
        XModelObject o = null;
        if (input instanceof IModelObjectEditorInput) {
            o = ((IModelObjectEditorInput)input).getXModelObject();
        } else if (input instanceof IFileEditorInput) {
            IFileEditorInput fileInput = (IFileEditorInput)input;
            IFile file = fileInput.getFile();
            if (file == null) {
                return;
            }
            o = this.getObjectByResource(file);
        }
        if (o == null) {
            return;
        }
        StructuredSelection newSelection = new StructuredSelection((Object)o);
        if (!this.getTreeViewer().getSelection().equals(o)) {
            this.getTreeViewer().setSelection((ISelection)newSelection);
        }
    }

    protected XModelObject getObjectByResource(IFile file) {
        XModelObject o = EclipseResourceUtil.getObjectByResource((IResource)file);
        if (o == null || this.contentProvider == null) {
            return o;
        }
        XFilteredTree t = this.contentProvider.getFilteredTree(o);
        if (!(t instanceof FileSystemsTree)) {
            return o;
        }
        FileSystemsTree fst = (FileSystemsTree)t;
        return fst.getRepresentation(o);
    }

    protected void linkToEditor(IStructuredSelection selection) {
        if (!this.isLinkingEnabled()) {
            return;
        }
        Object obj = selection.getFirstElement();
        if (obj instanceof IAdaptable && selection.size() == 1) {
            IFile file = (IFile)((IAdaptable)obj).getAdapter(IFile.class);
            if (file == null && obj instanceof XModelObject) {
                XModelObject o = (XModelObject)obj;
                Properties p = new Properties();
                p.setProperty("onlySelectIfOpen", "true");
                if (XActionInvoker.getAction((String)"Open", (XModelObject)o) != null) {
                    XActionInvoker.invoke((String)"Open", (XModelObject)o, (Properties)p);
                }
                return;
            }
            IWorkbenchPage page = this.getSite().getPage();
            IEditorPart editor = page.findEditor((IEditorInput)new FileEditorInput(file));
            if (editor != null) {
                page.bringToTop((IWorkbenchPart)editor);
                return;
            }
        }
    }

    private void handleActivation() throws XModelException {
        if (this.isHandlingActivation) {
            return;
        }
        this.isHandlingActivation = true;
        IProject[] ps = null;
        ps = ModelUIPlugin.getWorkspace().getRoot().getProjects();
        if (ps == null) {
            return;
        }
        int i = 0;
        while (i < ps.length) {
            IModelNature n = EclipseResourceUtil.getModelNature((IProject)ps[i]);
            if (n != null) {
                n.getModel().update();
            }
            ++i;
        }
        this.isHandlingActivation = false;
    }

    public ResourceComparator getComparator() {
        return null;
    }

    public void setComparator(ResourceComparator comparator) {
    }

    public boolean show(ShowInContext context) {
        Object input = context.getInput();
        XModelObject o = null;
        if (input instanceof IModelObjectEditorInput) {
            o = ((IModelObjectEditorInput)input).getXModelObject();
        } else if (input instanceof IFileEditorInput) {
            IFileEditorInput fileInput = (IFileEditorInput)input;
            IFile file = fileInput.getFile();
            if (file == null) {
                return false;
            }
            o = this.getObjectByResource(file);
        }
        if (o == null) {
            return false;
        }
        StructuredSelection newSelection = new StructuredSelection((Object)o);
        if (!this.getTreeViewer().getSelection().equals(o)) {
            this.getTreeViewer().setSelection((ISelection)newSelection);
        }
        return true;
    }

    class ActivationListener
    extends ShellAdapter {
        ActivationListener() {
        }

        public void shellActivated(ShellEvent event) {
            if (NavigatorViewPart.this.isHandlingActivation) {
                return;
            }
            event.widget.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    XJob.addRunnable((XJob.XRunnable)new ActivationXRunnable());
                }
            });
        }
    }

    class ActivationXRunnable
    implements XJob.XRunnable {
        ActivationXRunnable() {
        }

        public String getId() {
            return "Activation";
        }

        public void run() {
            try {
                NavigatorViewPart.this.handleActivation();
            }
            catch (XModelException e) {
                ModelPlugin.getPluginLog().logError((Throwable)e);
            }
        }
    }

    class ML
    extends TreeViewerModelListenerImpl {
        ML() {
        }

        @Override
        public void nodeChanged(XModelTreeEvent event) {
            super.nodeChanged(event);
            NavigatorViewPart.this.firePropertyChange(257);
        }
    }

    class SL
    implements ISelectionChangedListener {
        SL() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            NavigatorViewPart.this.firePropertyChange(257);
        }
    }
}

