/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.views.palette;

import java.io.File;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IActionBars;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.event.ActionDeclinedException;
import org.jboss.tools.common.model.event.XModelTreeEvent;
import org.jboss.tools.common.model.event.XModelTreeListener;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.dnd.DnDUtil;
import org.jboss.tools.common.model.ui.dnd.ModelTransfer;
import org.jboss.tools.common.model.ui.util.StringUtilities;
import org.jboss.tools.common.model.ui.views.palette.IPaletteAdapter;
import org.jboss.tools.common.model.ui.views.palette.IPalettePageAdapter;
import org.jboss.tools.common.model.ui.views.palette.PaletteContents;
import org.jboss.tools.common.model.ui.views.palette.PaletteDescriptionManager;
import org.jboss.tools.common.model.ui.views.palette.model.IPaletteNode;
import org.jboss.tools.common.model.ui.views.palette.model.PaletteElement;
import org.jboss.tools.common.model.ui.views.palette.model.PaletteModel;
import org.jboss.tools.common.model.util.EclipseResourceUtil;

public class PaletteAdapter
implements IPaletteAdapter {
    private static final int TEXT_MARGIN = 4;
    private IPalettePageAdapter viewPart = null;
    private PaletteModel model = null;
    private ScrolledComposite pane = null;
    private PaletteModelListener modelListener = null;
    private PaletteDescriptionManager descriptionManager = null;
    private PaletteResizeManager resizeManager = null;
    private PaletteDropTargetManager dropManager = null;
    private QualifiedName persistentTabQualifiedName = new QualifiedName("", "Palette_tab");
    private String selectedTab = null;
    private boolean fWindowsFlag;

    @Override
    public void setPaletteViewPart(IPalettePageAdapter viewPart) {
        this.viewPart = viewPart;
    }

    @Override
    public void initActionBars() {
        IActionBars bars = this.viewPart.getActionBars();
        if (bars != null) {
            this.createPaletteTabs();
            IMenuManager menuManager = bars.getMenuManager();
            bars.getToolBarManager().add((IAction)new PaletteEditAction());
            bars.getToolBarManager().add((IAction)new ShowHideTabsAction());
            if (this.selectedTab != null) {
                ActionContributionItem item = (ActionContributionItem)menuManager.find(this.selectedTab);
                if (item != null) {
                    item.getAction().run();
                }
            } else {
                IContributionItem[] actions = menuManager.getItems();
                if (actions.length > 0 && actions[0] instanceof ActionContributionItem) {
                    ((ActionContributionItem)actions[0]).getAction().run();
                }
            }
        }
    }

    @Override
    public Control createControl(Composite composite) {
        String osName = System.getProperty("os.name");
        this.fWindowsFlag = osName != null && osName.toUpperCase().indexOf("WINDOWS") != -1;
        try {
            this.selectedTab = ModelUIPlugin.getWorkspace().getRoot().getPersistentProperty(this.persistentTabQualifiedName);
        }
        catch (CoreException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
        }
        this.pane = new ScrolledComposite(composite, 512);
        this.pane.setExpandHorizontal(true);
        this.pane.setExpandVertical(true);
        this.descriptionManager = new PaletteDescriptionManager();
        this.resizeManager = new PaletteResizeManager();
        this.dropManager = new PaletteDropTargetManager();
        this.model = PaletteModel.getInstance();
        this.createPaletteTabs();
        this.modelListener = new PaletteModelListener();
        this.model.addModelTreeListener(this.modelListener);
        return this.pane;
    }

    private void createPaletteTabs() {
        IActionBars bars = this.viewPart.getActionBars();
        if (bars == null) {
            return;
        }
        IMenuManager menuManager = bars.getMenuManager();
        IPaletteNode root = this.model.getRoot();
        IPaletteNode[] nodes = root.getChildren();
        if (nodes != null) {
            int i = 0;
            while (i < nodes.length) {
                this.createPaletteTab(nodes[i], menuManager);
                ++i;
            }
        }
    }

    private void createPaletteTab(IPaletteNode node, IMenuManager manager) {
        String title = node.getTitle();
        Composite tab = new Composite((Composite)this.pane, 0);
        tab.setData((Object)node);
        RowLayout layout = new RowLayout(256);
        layout.pack = true;
        layout.justify = false;
        layout.marginLeft = 0;
        layout.marginTop = 0;
        layout.marginRight = 0;
        layout.marginBottom = 0;
        layout.spacing = 0;
        tab.setLayout((Layout)layout);
        IPaletteNode[] elems = node.getChildren();
        if (elems != null) {
            int i = 0;
            while (i < elems.length) {
                this.createPaletteElement(tab, elems[i]);
                ++i;
            }
        }
        manager.add((IAction)new PaletteTabAction(tab, title));
    }

    private void createPaletteElement(Composite tab, IPaletteNode node) {
        ToolBar tlb = new ToolBar(tab, 0x800100);
        ToolItem item = new ToolItem(tlb, 8);
        item.setText(StringUtilities.dottedString(node.getTitle(), 46, (Control)tlb));
        Image image = node.getImage();
        if (image != null) {
            image.setBackground(tlb.getBackground());
            image.setBackground(new Color((Device)tlb.getDisplay(), 255, 0, 0));
            item.setImage(image);
            if (this.fWindowsFlag) {
                item.setDisabledImage(image);
            }
        }
        item.setData((Object)node);
        item.addSelectionListener((SelectionListener)new PaletteSelectionListener(node));
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (!this.fWindowsFlag) {
            return;
        }
        Control[] tabs = this.pane.getChildren();
        int i = 0;
        while (i < tabs.length) {
            if (tabs[i] instanceof Composite) {
                Control[] elems = ((Composite)tabs[i]).getChildren();
                int j = 0;
                while (j < elems.length) {
                    if (elems[j] instanceof ToolBar) {
                        ToolBar tlb = (ToolBar)elems[j];
                        int k = 0;
                        int c = tlb.getItemCount();
                        while (k < c) {
                            tlb.getItem(k).setEnabled(enabled);
                            ++k;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void reload(XModelObject xtab) {
        IAction action;
        int i;
        this.model.reload();
        IActionBars bars = this.viewPart.getActionBars();
        IMenuManager menuManager = bars.getMenuManager();
        String oldTitle = null;
        Control oldTab = this.pane.getContent();
        Control[] oldTabs = this.pane.getChildren();
        IContributionItem[] oldActions = menuManager.getItems();
        this.createPaletteTabs();
        int i2 = 0;
        while (i2 < oldActions.length) {
            IAction action2;
            if (oldTitle == null && oldTab != null && oldActions[i2] instanceof ActionContributionItem && (action2 = ((ActionContributionItem)oldActions[i2]).getAction()) instanceof PaletteTabAction && ((PaletteTabAction)action2).tab == oldTab) {
                oldTitle = action2.getText();
            }
            menuManager.remove(oldActions[i2]);
            ++i2;
        }
        IAction newAction = null;
        IContributionItem[] newActions = menuManager.getItems();
        if (xtab != null) {
            i = 0;
            while (i < newActions.length) {
                if (newActions[i] instanceof ActionContributionItem && (action = ((ActionContributionItem)newActions[i]).getAction()) instanceof PaletteTabAction && ((IPaletteNode)((PaletteTabAction)action).tab.getData()).getXModelObject() == xtab) {
                    newAction = action;
                    break;
                }
                ++i;
            }
        }
        if (newAction == null && oldTitle != null) {
            i = 0;
            while (i < newActions.length) {
                if (newActions[i] instanceof ActionContributionItem && oldTitle.equalsIgnoreCase((action = ((ActionContributionItem)newActions[i]).getAction()).getText())) {
                    newAction = action;
                    break;
                }
                ++i;
            }
        }
        if (newAction == null && newActions.length > 0 && newActions[0] instanceof ActionContributionItem) {
            newAction = ((ActionContributionItem)newActions[0]).getAction();
        }
        if (newAction != null) {
            newAction.run();
        }
        i = 0;
        while (i < oldTabs.length) {
            oldTabs[i].dispose();
            ++i;
        }
        this.setEnabled(this.viewPart.isEnabled());
    }

    @Override
    public void dispose() {
        this.dropManager.dispose();
        this.descriptionManager.dispose();
        if (this.model != null) {
            this.model.removeModelTreeListener(this.modelListener);
        }
        if (this.viewPart.getActionBars() != null) {
            this.viewPart.getActionBars().getToolBarManager().removeAll();
        }
        try {
            if (this.selectedTab != null) {
                ModelUIPlugin.getWorkspace().getRoot().setPersistentProperty(this.persistentTabQualifiedName, this.selectedTab);
            }
        }
        catch (CoreException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    @Override
    public void setPaletteContents(PaletteContents contents) {
    }

    private class PaletteDropTargetManager
    extends DropTargetAdapter {
        private DropTarget target = null;

        private PaletteDropTargetManager() {
        }

        public void install(Composite tab) {
            this.dispose();
            Transfer[] types = new Transfer[]{ModelTransfer.getInstance(), FileTransfer.getInstance()};
            this.target = new DropTarget((Control)tab, 3);
            this.target.setTransfer(types);
            this.target.addDropListener((DropTargetListener)this);
        }

        public void dispose() {
            if (this.target != null) {
                if (!this.target.isDisposed()) {
                    this.target.removeDropListener((DropTargetListener)this);
                    this.target.dispose();
                }
                this.target = null;
            }
        }

        public void dragOver(DropTargetEvent event) {
            XModelObject o = null;
            if (FileTransfer.getInstance().isSupportedType(event.currentDataType)) {
                File f = this.getFile(event);
                if (f != null) {
                    IFile ef = EclipseResourceUtil.getFile((String)f.getAbsolutePath());
                    o = ef == null ? null : EclipseResourceUtil.getObjectByResource((IResource)ef);
                }
            } else {
                o = event.currentDataType.type != ModelTransfer.MODEL_ID ? null : this.getModelObject(event.x, event.y);
            }
            boolean enabled = o != null && DnDUtil.isPasteEnabled(o);
            event.detail = enabled ? 1 : 0;
        }

        public void drop(DropTargetEvent event) {
            XModelObject o = null;
            if (FileTransfer.getInstance().isSupportedType(event.currentDataType)) {
                File f = this.getFile(event);
                if (f != null) {
                    IFile ef = EclipseResourceUtil.getFile((String)f.getAbsolutePath());
                    o = ef == null ? null : EclipseResourceUtil.getObjectByResource((IResource)ef);
                }
            } else {
                o = event.currentDataType.type != ModelTransfer.MODEL_ID ? null : this.getModelObject(event.x, event.y);
            }
            if (o != null) {
                try {
                    DnDUtil.paste(o, new Properties());
                    PaletteAdapter.this.model.getXModel().saveOptions();
                }
                catch (ActionDeclinedException actionDeclinedException) {
                }
                catch (XModelException e) {
                    this.message((Exception)((Object)e));
                }
            } else {
                event.detail = 0;
            }
        }

        private XModelObject getModelObject(int x, int y) {
            IPaletteNode node = null;
            Composite tab = (Composite)this.target.getControl();
            Control[] controls = tab.getChildren();
            int i = 0;
            while (i < controls.length) {
                Rectangle area;
                if (controls[i] instanceof ToolBar && (area = controls[i].getBounds()).contains(x, y)) {
                    ToolItem item = ((ToolBar)controls[i]).getItem(new Point(x - area.x, y - area.y));
                    if (item == null) break;
                    node = (IPaletteNode)item.getData();
                    break;
                }
                ++i;
            }
            if (node == null) {
                node = (IPaletteNode)tab.getData();
            }
            return node.getXModelObject();
        }

        private void message(Exception e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
        }

        private File getFile(DropTargetEvent event) {
            String[] s = (String[])event.data;
            return s == null || s.length == 0 ? null : new File(s[0]);
        }
    }

    private class PaletteEditAction
    extends Action {
        public PaletteEditAction() {
            super("Palette Editor", PaletteAdapter.this.model.createImageDescriptor("palette_editor.gif"));
            this.setToolTipText("Palette Editor");
        }

        public void run() {
            PaletteAdapter.this.model.openEditor(PaletteAdapter.this.pane.getShell());
        }
    }

    private class PaletteModelListener
    implements XModelTreeListener {
        private boolean isTransaction = false;
        private boolean isDirty = false;
        private XModelObject lastAddedTab = null;

        private PaletteModelListener() {
        }

        public void nodeChanged(XModelTreeEvent event) {
            this.run(event);
        }

        public void structureChanged(XModelTreeEvent event) {
            this.run(event);
        }

        private void run(XModelTreeEvent event) {
            if ("transaction_begin".equals(event.getInfo())) {
                this.isTransaction = true;
                return;
            }
            if ("transaction_end".equals(event.getInfo())) {
                this.isTransaction = false;
                if (this.isDirty) {
                    this.isDirty = false;
                    PaletteAdapter.this.reload(this.lastAddedTab);
                    this.lastAddedTab = null;
                }
                return;
            }
            XModel xmodel = PaletteAdapter.this.model.getXModel();
            XModelObject exo = event.getModelObject();
            boolean q = event.kind() == 3 && xmodel.getRoot().getPath().equals(exo.getPath());
            XModelObject xroot = xmodel.getRoot("Palette");
            if (xroot == null || this.isExist(xroot, event.getModelObject()) || q) {
                Object info;
                if (event.kind() == 1 && xroot != null && xroot.getPath().equals(exo.getPath()) && (info = event.getInfo()) instanceof XModelObject) {
                    this.lastAddedTab = (XModelObject)info;
                }
                if (this.isTransaction) {
                    this.isDirty = true;
                } else {
                    PaletteAdapter.this.reload(this.lastAddedTab);
                    this.lastAddedTab = null;
                }
            }
        }

        private boolean isExist(XModelObject root, XModelObject modelObject) {
            if (root == null || modelObject == null) {
                return false;
            }
            if (modelObject.getPath() == null || root.getPath() == null) {
                return false;
            }
            return (String.valueOf(modelObject.getPath()) + "/").startsWith(String.valueOf(root.getPath()) + "/");
        }
    }

    private class PaletteResizeManager
    extends ControlAdapter {
        Composite tab = null;

        private PaletteResizeManager() {
        }

        public void install(Composite tab) {
            this.dispose();
            this.tab = tab;
            this.resize();
            tab.addControlListener((ControlListener)this);
        }

        public void dispose() {
            if (this.tab != null) {
                if (!this.tab.isDisposed()) {
                    this.tab.removeControlListener((ControlListener)this);
                }
                this.tab = null;
            }
        }

        public void controlResized(ControlEvent event) {
            this.resize();
        }

        private void resize() {
            int width = ((PaletteAdapter)PaletteAdapter.this).pane.getClientArea().width;
            if (width > 0) {
                int height = this.tab.computeSize((int)width, (int)-1).y;
                PaletteAdapter.this.pane.setMinHeight(height);
            }
        }
    }

    private class PaletteSelectionListener
    extends SelectionAdapter {
        IPaletteNode node;

        public PaletteSelectionListener(IPaletteNode node) {
            this.node = node;
        }

        public void widgetSelected(SelectionEvent event) {
            PaletteAdapter.this.viewPart.insertIntoEditor(((PaletteElement)this.node).getXModelObject());
        }
    }

    private class PaletteTabAction
    extends Action {
        private Composite tab;

        public PaletteTabAction(Composite tab, String text) {
            super(text);
            this.tab = tab;
            this.setId(text);
        }

        public Composite getTab() {
            return this.tab;
        }

        public void run() {
            if (PaletteAdapter.this.pane.getContent() != null) {
                PaletteAdapter.this.dropManager.dispose();
                PaletteAdapter.this.resizeManager.dispose();
                PaletteAdapter.this.descriptionManager.setEnabled(false);
            }
            PaletteAdapter.this.viewPart.setContentDescription(this.getText());
            PaletteAdapter.this.pane.setContent((Control)this.tab);
            PaletteAdapter.this.descriptionManager.install((Control)this.tab);
            PaletteAdapter.this.resizeManager.install(this.tab);
            PaletteAdapter.this.dropManager.install(this.tab);
            PaletteAdapter.this.selectedTab = this.getId();
        }
    }

    private class ShowHideTabsAction
    extends Action {
        public ShowHideTabsAction() {
            super("Show/Hide tabs", PaletteAdapter.this.model.createImageDescriptor("show-hide.gif"));
            this.setToolTipText("Show/Hide");
        }

        public void run() {
            PaletteAdapter.this.model.runShowHideDialog();
        }
    }
}

