/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.views.palette.editor;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.meta.action.XActionItem;
import org.jboss.tools.common.meta.action.XActionList;
import org.jboss.tools.common.meta.help.HelpUtil;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.event.XModelTreeEvent;
import org.jboss.tools.common.model.event.XModelTreeListener;
import org.jboss.tools.common.model.options.PreferenceModelUtilities;
import org.jboss.tools.common.model.options.SharableElement;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.ui.navigator.FilteredTreeContentProvider;
import org.jboss.tools.common.model.ui.navigator.NavigatorLabelProvider;
import org.jboss.tools.common.model.ui.navigator.TreeViewerMenuInvoker;
import org.jboss.tools.common.model.ui.navigator.TreeViewerModelListenerImpl;
import org.jboss.tools.common.model.ui.objecteditor.XModelObjectEditor;
import org.jboss.tools.common.model.ui.views.palette.editor.PaletteDialogState;
import org.jboss.tools.common.model.util.XModelTreeListenerSWTSync;

public class PaletteDialog
extends Dialog {
    protected TreeViewer treeViewer = null;
    protected XModelObjectEditor objectEditor = new XModelObjectEditor();
    protected FilteredTreeContentProvider contentProvider = new FilteredTreeContentProvider();
    protected TreeViewerModelListenerImpl listener = new TreeViewerModelListenerImpl();
    protected XModelTreeListenerSWTSync syncListener = new XModelTreeListenerSWTSync(this.listener);
    protected XModelTreeListener listener2 = new ObjectListener();
    protected XModelTreeListenerSWTSync syncListener2 = new XModelTreeListenerSWTSync(this.listener2);
    Button restoreDefaults = null;
    TreeViewerMenuInvoker menu = new TreeViewerMenuInvoker(){

        @Override
        protected XActionList getActionList(XModelObject o) {
            XActionList l = super.getActionList(o);
            if (l != null) {
                l = (XActionList)l.copy(new XActionItem.Acceptor(){

                    public boolean accepts(XActionItem item) {
                        return !item.getName().startsWith("Propert");
                    }
                });
            }
            return l;
        }
    };
    PaletteDialogState state = new PaletteDialogState(this);
    SL sl = new SL();
    SashForm sash;
    Composite control;

    public void dispose() {
        if (this.treeViewer != null && this.treeViewer.getTree() != null && !this.treeViewer.getTree().isDisposed()) {
            this.treeViewer.getTree().removeSelectionListener((SelectionListener)this.sl);
        }
        this.sl = null;
        this.treeViewer = null;
        if (this.objectEditor != null) {
            this.objectEditor.dispose();
        }
        this.objectEditor = null;
        if (this.syncListener != null) {
            this.syncListener.dispose();
        }
        this.syncListener = null;
        if (this.syncListener2 != null) {
            this.syncListener2.dispose();
        }
        this.syncListener2 = null;
    }

    public PaletteDialog(Shell shell) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.menu.setOnKeyRelease(true);
    }

    public void create() {
        super.create();
        this.getShell().setText("Palette Editor");
        this.state.loadState();
    }

    protected Control createContents(Composite parent) {
        Control c = super.createContents(parent);
        this.createEditorComponents((Composite)this.getDialogArea());
        this.control = (Composite)c;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.jboss.tools.common.model.ui.templates.palette_editor");
        return c;
    }

    protected void createEditorComponents(Composite parent) {
        SashForm panel;
        this.sash = panel = new SashForm(parent, 0);
        panel.setLayoutData((Object)new GridData(1808));
        this.treeViewer = new TreeViewer((Composite)panel);
        this.contentProvider.setModel(PreferenceModelUtilities.getPreferenceModel());
        this.contentProvider.setViewer(this.treeViewer);
        this.contentProvider.setFilteredTreeName("PaletteTree");
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new NavigatorLabelProvider());
        this.treeViewer.setInput((Object)this.contentProvider);
        this.treeViewer.refresh();
        this.menu.setViewer((Viewer)this.treeViewer);
        this.treeViewer.getTree().addMouseListener((MouseListener)this.menu);
        this.treeViewer.getTree().addKeyListener((KeyListener)this.menu);
        this.treeViewer.getTree().addSelectionListener((SelectionListener)this.sl);
        this.treeViewer.getTree().setVisible(true);
        this.treeViewer.setAutoExpandLevel(2);
        Composite right = new Composite((Composite)panel, 0);
        right.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(1, false);
        layout.marginTop = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginBottom = 0;
        right.setLayout((Layout)layout);
        Control c = this.objectEditor.createControl(right);
        c.setLayoutData((Object)new GridData(1808));
        this.restoreDefaults = new Button(right, 0);
        this.restoreDefaults.setText("Restore Defaults");
        GridData gd = new GridData();
        gd.horizontalAlignment = 0x1000008;
        this.restoreDefaults.setLayoutData((Object)gd);
        this.restoreDefaults.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                PaletteDialog.this.restoreDefaults();
            }
        });
        this.activate();
        this.treeViewer.setAutoExpandLevel(2);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void okPressed() {
        this.objectEditor.stopEditing();
        super.okPressed();
    }

    public void activate() {
        this.listener.setViewer(this.treeViewer);
        PreferenceModelUtilities.getPreferenceModel().addModelTreeListener((XModelTreeListener)this.syncListener);
        PreferenceModelUtilities.getPreferenceModel().addModelTreeListener((XModelTreeListener)this.syncListener2);
    }

    public boolean close() {
        this.state.saveState();
        boolean b = super.close();
        if (b) {
            PreferenceModelUtilities.getPreferenceModel().removeModelTreeListener((XModelTreeListener)this.syncListener);
            PreferenceModelUtilities.getPreferenceModel().removeModelTreeListener((XModelTreeListener)this.syncListener2);
        }
        this.dispose();
        return b;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 17) {
            HelpUtil.helpEclipse((XModel)PreferenceModelUtilities.getPreferenceModel(), (String)"PaletteEditor");
        } else {
            super.buttonPressed(buttonId);
        }
    }

    private SharableElement getSelectedElementWithGeneralScope(XModelObject o) {
        if (!(o instanceof SharableElement)) {
            return null;
        }
        SharableElement e = (SharableElement)o;
        return e.scopeExists("general") ? e : null;
    }

    private void restoreDefaults() {
        XModelObject o = this.menu.getSelectedModelObject();
        SharableElement e = this.getSelectedElementWithGeneralScope(o);
        if (e == null) {
            return;
        }
        this.restoreDefaults(e);
    }

    private void restoreDefaults(SharableElement e) {
        if (!e.scopeExists("general")) {
            return;
        }
        XAttribute[] as = e.getModelEntity().getAttributes();
        int i = 0;
        while (i < as.length) {
            String n;
            if (as[i].isVisible() && !"name".equals(n = as[i].getName())) {
                String v = e.getAttributeValue(n, "general");
                String cv = e.getAttributeValue(n);
                if (cv == null || !cv.equals(v)) {
                    try {
                        e.getModel().editObjectAttribute((XModelObject)e, n, v);
                    }
                    catch (XModelException exc) {
                        ModelPlugin.getPluginLog().logError((Throwable)exc);
                    }
                }
            }
            ++i;
        }
        SharableElement[] cs = e.getSharableChildren();
        int i2 = 0;
        while (i2 < cs.length) {
            this.restoreDefaults(cs[i2]);
            ++i2;
        }
    }

    class ObjectListener
    implements XModelTreeListener {
        ObjectListener() {
        }

        public void nodeChanged(XModelTreeEvent event) {
            if (event.getModelObject() == PaletteDialog.this.menu.getSelectedModelObject()) {
                PaletteDialog.this.objectEditor.update();
            }
        }

        public void structureChanged(XModelTreeEvent event) {
        }
    }

    class SL
    extends SelectionAdapter {
        SL() {
        }

        public void widgetSelected(SelectionEvent e) {
            XModelObject o = PaletteDialog.this.menu.getSelectedModelObject();
            PaletteDialog.this.objectEditor.setModelObject(o);
            if (PaletteDialog.this.restoreDefaults != null && !PaletteDialog.this.restoreDefaults.isDisposed()) {
                SharableElement element = PaletteDialog.this.getSelectedElementWithGeneralScope(o);
                PaletteDialog.this.restoreDefaults.setEnabled(element != null);
            }
        }
    }
}

