/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.wizards.special;

import java.util.Properties;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.common.meta.action.SpecialWizard;
import org.jboss.tools.common.meta.action.impl.SpecialWizardControlListener;
import org.jboss.tools.common.meta.action.impl.SpecialWizardSupport;
import org.jboss.tools.common.meta.action.impl.WizardDataValidator;
import org.jboss.tools.common.meta.help.HelpUtil;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.ui.ModelUIImages;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.action.CommandBar;
import org.jboss.tools.common.model.ui.wizards.special.AbstractSpecialWizardStep;
import org.jboss.tools.common.model.ui.wizards.special.DefaultSpecialWizardDialog;
import org.jboss.tools.common.model.ui.wizards.special.ISpecialWizardStep;
import org.jboss.tools.common.model.ui.wizards.special.ProgressPart;
import org.jboss.tools.common.model.ui.wizards.standard.DefaultStandardWizard;
import org.jboss.tools.common.model.util.ModelFeatureFactory;

public class DefaultSpecialWizard
implements SpecialWizard,
SpecialWizardControlListener {
    protected SpecialWizardSupport support = null;
    protected ISpecialWizardStep wizardStep = null;
    protected DefaultSpecialWizardDialog dialog = null;
    ProgressPart progressPart = null;
    private ValidationRunnable validationRunnable = new ValidationRunnable();

    public void setObject(Object object) {
        this.setSupport((SpecialWizardSupport)((Object[])object)[0]);
    }

    public int execute() {
        Shell shell = (Shell)this.support.getProperties().get("shell");
        if (shell == null) {
            shell = ModelUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
        }
        if (this.support.canBeProcessedByStandardWizard()) {
            DefaultStandardWizard dsw = new DefaultStandardWizard();
            dsw.setWindowTitle(this.support.getTitle());
            dsw.setSupport(this.support);
            dsw.setDefaultPageImageDescriptor(ModelUIImages.getImageDescriptor(ModelUIImages.WIZARD_DEFAULT));
            WizardDialog wd = new WizardDialog(shell, (IWizard)dsw);
            wd.create();
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)wd.getShell(), "org.eclipse.ui.new_wizard_shortcut_context");
            int ii = wd.open();
            return ii;
        }
        this.dialog = new DefaultSpecialWizardDialog(shell);
        this.dialog.setWizard(this);
        this.dialog.create();
        this.progressPart = new ProgressPart(this.dialog.getShell(), this);
        this.support.getProperties().put("dialogShell", this.dialog.getShell());
        this.support.getProperties().put("IRunnableContext", this.progressPart);
        this.open();
        return 0;
    }

    public ProgressPart getProgressPart() {
        return this.progressPart;
    }

    public boolean needsProgressMonitor() {
        return true;
    }

    private void open() {
        if (this.validationRunnable == null) {
            this.validationRunnable = new ValidationRunnable();
        }
        this.dialog.getShell().pack(true);
        this.setStep();
        try {
            this.support.action("STEP");
        }
        catch (XModelException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
        }
        this.dialog.open();
    }

    public void action(String name) {
        if (this.dialog == null) {
            return;
        }
        CommandBar bar = this.dialog.getCommandBar();
        bar.disable();
        if (SpecialWizardSupport.HELP.equals(name)) {
            HelpUtil.helpEclipse((XModel)this.support.getTarget().getModel(), (String)this.support.getHelpKey());
            return;
        }
        try {
            this.save();
            this.support.action(name);
            this.dialog.setMessage("");
        }
        catch (XModelException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
        }
        this.setStep();
    }

    private void setStep() {
        if (this.wizardStep != null) {
            this.wizardStep.dispose();
        }
        if (this.support.isFinished()) {
            this.dispose();
            return;
        }
        int i = this.support.getStepId();
        if (this.support.isFinished()) {
            return;
        }
        String message = this.support.getMessage(i);
        if (i >= 0) {
            this.wizardStep = this.getStep(i);
            if (this.wizardStep == null) {
                return;
            }
            this.wizardStep.update();
        } else {
            this.wizardStep = null;
        }
        if (this.wizardStep == null) {
            return;
        }
        this.dialog.setMaximumSize(this.wizardStep.getMaximumSize());
        this.dialog.setMinimumSize(this.wizardStep.getMinimumSize());
        this.dialog.updateDialogArea();
        this.dialog.updateButtonsBar(this.getSupport().getActionNames(i));
        this.dialog.getShell().setText(this.support.getTitle());
        this.dialog.setTitle(this.support.getSubtitle());
        if (message != null) {
            this.dialog.setMessage(message);
        }
        this.wizardStep.validate();
    }

    private ISpecialWizardStep getStep(int i) {
        if (i < 0) {
            return null;
        }
        String cls = this.support.getStepImplementingClass(i);
        ISpecialWizardStep step = null;
        try {
            step = (ISpecialWizardStep)ModelFeatureFactory.getInstance().createFeatureInstance(cls);
            if (step instanceof AbstractSpecialWizardStep) {
                ((AbstractSpecialWizardStep)step).setWizard(this);
            }
            step.setSupport(this.support, i);
        }
        catch (ClassCastException classCastException) {
            ModelUIPlugin.getPluginLog().logError("Cannot load class '" + cls + "'.");
        }
        return step;
    }

    public void save() {
        if (this.wizardStep != null) {
            this.wizardStep.save();
        }
    }

    public void dispose() {
        this.stopValidator();
        if (this.dialog == null) {
            return;
        }
        if (this.dialog.getShell() != null && !this.dialog.getShell().isDisposed()) {
            this.dialog.close();
        }
        this.dialog = null;
    }

    public SpecialWizardSupport getSupport() {
        return this.support;
    }

    public void setSupport(SpecialWizardSupport support) {
        this.support = support;
        if (support != null) {
            support.setControlListener((SpecialWizardControlListener)this);
        }
    }

    public ISpecialWizardStep getWizardStep() {
        return this.wizardStep;
    }

    public void setWizardStep(ISpecialWizardStep step) {
        this.wizardStep = step;
    }

    public void dataChanged(WizardDataValidator validator, Properties data) {
        if (validator == null) {
            return;
        }
        if (this.validationRunnable == null) {
            return;
        }
        this.validationRunnable.setData(validator, data);
        this.validationRunnable.safeUpdateValidationData();
    }

    public void stopValidator() {
        if (this.validationRunnable == null) {
            return;
        }
        this.validationRunnable = null;
    }

    class ValidationRunnable
    implements Runnable {
        Properties data;
        WizardDataValidator validator;
        long timeStamp = -1L;
        long lastTimeStamp = -1L;

        ValidationRunnable() {
        }

        public void setData(WizardDataValidator validator, Properties data) {
            this.data = data;
            this.validator = validator;
            this.timeStamp = System.currentTimeMillis();
        }

        @Override
        public void run() {
        }

        void safeUpdateValidationData() {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    ValidationRunnable.this.updateValidationData();
                }
            });
        }

        void updateValidationData() {
            if (DefaultSpecialWizard.this.validationRunnable == null) {
                return;
            }
            this.validator.validate(this.data);
            String message = this.validator.getErrorMessage();
            String warning = this.validator.getWarningMessage();
            if (DefaultSpecialWizard.this.wizardStep != null && (!DefaultSpecialWizard.this.wizardStep.isDataChanged() || message == null && warning == null)) {
                DefaultSpecialWizard.this.dialog.setErrorMessage(null);
                String m = DefaultSpecialWizard.this.support.getMessage(DefaultSpecialWizard.this.support.getStepId());
                if (m == null || m.length() == 0) {
                    m = message == null ? warning : message;
                }
                DefaultSpecialWizard.this.dialog.setMessage(m);
            } else {
                DefaultSpecialWizard.this.dialog.setErrorMessage(message);
                if (message != null || warning == null) {
                    DefaultSpecialWizard.this.dialog.setMessage(null);
                } else {
                    DefaultSpecialWizard.this.dialog.setMessage(warning, 2);
                }
            }
            CommandBar bar = DefaultSpecialWizard.this.dialog.getCommandBar();
            String[] s = DefaultSpecialWizard.this.support.getActionNames(this.validator.getId());
            int i = 0;
            while (i < s.length) {
                bar.setEnabled(s[i], this.validator.isCommandEnabled(s[i]));
                ++i;
            }
        }
    }
}

