/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.wizards.special;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Properties;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.jboss.tools.common.meta.action.XAttributeData;
import org.jboss.tools.common.meta.action.impl.SpecialWizardSupport;
import org.jboss.tools.common.model.ui.attribute.XAttributeSupport;
import org.jboss.tools.common.model.ui.wizards.special.AbstractSpecialWizardStep;

public class SpecialWizardStep
extends AbstractSpecialWizardStep
implements PropertyChangeListener {
    protected XAttributeSupport attributes = new XAttributeSupport();
    protected boolean isDataChanged = false;
    protected Composite stepControl = null;

    @Override
    public void dispose() {
        if (this.wizard != null) {
            this.wizard.getProgressPart().dispose();
        }
        super.dispose();
        if (this.attributes != null) {
            this.attributes.dispose();
        }
        this.attributes = null;
    }

    @Override
    public void setSupport(SpecialWizardSupport support, int i) {
        super.setSupport(support, i);
        if (this.attributes == null) {
            this.attributes = new XAttributeSupport();
        }
        this.attributes.removePropertyChangeListener(this);
        this.attributes.init(support.getTarget(), support.getEntityData()[i]);
        this.attributes.addPropertyChangeListener(this);
    }

    @Override
    public Control createControl(Composite parent) {
        this.stepControl = this.attributes.createControl(parent);
        String focusAttr = this.support.getFocusAttribute(this.id);
        if (focusAttr != null && this.attributes.getFieldEditorByName(focusAttr) != null) {
            this.attributes.getFieldEditorByName(focusAttr).setFocus();
        }
        this.updateFieldEnablement();
        return this.stepControl;
    }

    @Override
    public void save() {
        if (this.attributes != null) {
            this.attributes.store();
        }
    }

    @Override
    public void clear() {
        if (this.attributes != null) {
            this.attributes.load();
        }
    }

    @Override
    public Point getMinimumSize() {
        return null;
    }

    @Override
    public Point getMaximumSize() {
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent arg0) {
        this.isDataChanged = true;
        this.attributes.store();
        this.validate();
        this.updateFieldEnablement();
    }

    @Override
    public void validate() {
        if (this.validator == null || this.attributes == null) {
            return;
        }
        this.wizard.dataChanged(this.validator, this.attributes.getValues());
    }

    @Override
    public boolean isDataChanged() {
        return this.isDataChanged;
    }

    public void updateFieldEnablement() {
        if (this.stepControl == null || this.stepControl.isDisposed()) {
            return;
        }
        Properties p = this.attributes.getValues();
        XAttributeData[] ad = this.support.getEntityData()[this.id].getAttributeData();
        int i = 0;
        while (i < ad.length) {
            String n = ad[i].getAttribute().getName();
            boolean b = this.support.isFieldEditorEnabled(this.id, n, p);
            FieldEditor f = this.attributes.getFieldEditorByName(n);
            if (f != null) {
                f.setEnabled(b, this.stepControl);
            }
            ++i;
        }
    }
}

