/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.propertieseditor;

import org.eclipse.swt.graphics.Color;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.action.CommandBar;
import org.jboss.tools.common.propertieseditor.PropertiesEditor;
import org.jboss.tools.common.propertieseditor.bundlemodel.BundleModel;
import org.jboss.tools.common.propertieseditor.bundlemodel.PropertyModel;

public class BundleLocaleEditor
extends PropertiesEditor {
    BundleModel bundleModel;

    @Override
    public void dispose() {
        super.dispose();
        if (this.bundleModel != null) {
            this.bundleModel.dispose();
        }
        this.bundleModel = null;
    }

    public void setBundleModel(BundleModel bundleModel) {
        this.bundleModel = bundleModel;
    }

    @Override
    protected Color getItemColor(int i) {
        if (this.bundleModel == null) {
            return DEFAULT_COLOR;
        }
        XModelObject o = this.helper.getModelObject(i);
        PropertyModel pm = this.bundleModel.getPropertyModel(o, this.bundleModel.getCurrentLocale());
        if (pm == null) {
            return GREYED_COLOR;
        }
        return pm.hasValue(this.bundleModel.getCurrentLocale()) ? DEFAULT_COLOR : GREYED_COLOR;
    }

    @Override
    protected void edit() {
        XModelObject o = this.helper.getModelObject(this.xtable.getSelectionIndex());
        if (o != null) {
            this.callAction(o, "Properties.Edit");
            this.updatePropertyModel();
        }
    }

    @Override
    protected void add() {
        long ts = this.helper.getModelObject().getTimeStamp();
        super.add();
        this.updatePropertyModel();
        if (ts != this.helper.getModelObject().getTimeStamp()) {
            this.bundleModel.setModified(true);
        }
    }

    @Override
    protected void delete() {
        long ts = this.helper.getModelObject().getTimeStamp();
        super.delete();
        if (ts != this.helper.getModelObject().getTimeStamp()) {
            this.bundleModel.setModified(true);
        }
    }

    private void updatePropertyModel() {
        XModelObject o = this.helper.getModelObject(this.xtable.getSelectionIndex());
        if (o == null) {
            return;
        }
        PropertyModel pm = this.bundleModel.getPropertyModel(o, this.bundleModel.getCurrentLocale());
        if (pm != null) {
            pm.commit();
        }
    }

    @Override
    protected boolean isReadOnly() {
        return this.bundleModel == null || !this.bundleModel.isEditable();
    }

    @Override
    protected void setMargins(CommandBar bar) {
        bar.getLayout().setMargins(10, 10, 0, 5);
    }
}

