/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.project.services;

import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessBean;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jboss.forge.resources.DirectoryResource;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.resources.ResourceHandles;
import org.jboss.forge.resources.UnknownFileResource;
import org.jboss.forge.shell.events.PostStartup;

@Singleton
public class ResourceFactory
implements Extension {
    @Inject
    private Instance<BeanManager> managerInstance;
    private final List<ResourceGenerator> resourceGenerators = new ArrayList<ResourceGenerator>();
    private volatile ResourceGenerator lastTypeLoaded = new ResourceGenerator(){

        @Override
        public boolean matches(String name) {
            return false;
        }
    };

    public void setManager(@Observes PostStartup event, Instance<BeanManager> manager) {
        this.managerInstance = manager;
    }

    public void scan(@Observes ProcessBean<Resource<?>> event, BeanManager manager) {
        Bean bean = event.getBean();
        Class clazz = bean.getBeanClass();
        if (clazz.isAnnotationPresent(ResourceHandles.class)) {
            for (String pspec : clazz.getAnnotation(ResourceHandles.class).value()) {
                Pattern p = Pattern.compile(ResourceFactory.pathspecToRegEx(pspec));
                CreationalContext creationalCtx = manager.createCreationalContext((Contextual)bean);
                Resource rInst = (Resource)manager.getReference(bean, (Type)bean.getBeanClass(), creationalCtx);
                this.resourceGenerators.add(new ResourceGenerator(p, rInst));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E, T extends Resource<E>> T createFromType(Class<T> type, E underlyingResource) {
        ResourceFactory resourceFactory = this;
        synchronized (resourceFactory) {
            for (ResourceGenerator gen : this.resourceGenerators) {
                Resource resource = (Resource)gen.getResource();
                if (!type.isAssignableFrom(resource.getClass())) continue;
                this.lastTypeLoaded = gen;
                Resource result = (Resource)this.lastTypeLoaded.getResource();
                return (T)result.createFrom(underlyingResource);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource<File> getResourceFrom(File file) {
        if ((file = file.getAbsoluteFile()).isDirectory()) {
            return new DirectoryResource(this, file);
        }
        String name = file.getName();
        ResourceFactory resourceFactory = this;
        synchronized (resourceFactory) {
            if (this.lastTypeLoaded.matches(name)) {
                return this.lastTypeLoaded.getResource(File.class).createFrom(file);
            }
            for (ResourceGenerator gen : this.resourceGenerators) {
                if (!gen.matches(name)) continue;
                this.lastTypeLoaded = gen;
                return this.lastTypeLoaded.getResource(File.class).createFrom(file);
            }
        }
        return new UnknownFileResource(this, file);
    }

    public BeanManager getManagerInstance() {
        if (this.managerInstance != null) {
            return (BeanManager)this.managerInstance.get();
        }
        return null;
    }

    private static String pathspecToRegEx(String pathSpec) {
        return "^" + pathSpec.replaceAll("\\*", "\\.\\*").replaceAll("\\?", "\\.") + "$";
    }

    static class ResourceGenerator {
        private Pattern pattern;
        private Resource<?> resource;

        ResourceGenerator() {
        }

        ResourceGenerator(Pattern pattern, Resource<?> resource) {
            this.pattern = pattern;
            this.resource = resource;
        }

        public boolean matches(String name) {
            return this.pattern.matcher(name).matches();
        }

        public <T> T getResource() {
            return (T)this.resource;
        }

        public <T> Resource<T> getResource(Class<T> type) {
            return this.resource;
        }
    }
}

