/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.resources;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.resources.VirtualResource;

public class EntryResource<K, V>
extends VirtualResource<Map.Entry<K, V>> {
    private Map.Entry<K, V> entry;

    public EntryResource(Resource<?> parent, K key, V value) {
        super(parent);
        this.entry = new ConcreteEntry(key, value);
    }

    public K getKey() {
        return this.entry.getKey();
    }

    public V getValue() {
        return this.entry.getValue();
    }

    @Override
    public boolean delete() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean delete(boolean recursive) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        return this.getKey() + " = " + this.getValue();
    }

    @Override
    public Map.Entry<K, V> getUnderlyingResourceObject() {
        return this.entry;
    }

    @Override
    protected List<Resource<?>> doListResources() {
        return Collections.emptyList();
    }

    private class ConcreteEntry
    implements Map.Entry<K, V> {
        private K key;
        private V value;

        private ConcreteEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            this.value = value;
            return this.getValue();
        }
    }
}

